/*
 * Decompiled with CFR 0.152.
 */
package panda.divergentunderground.integration;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import panda.divergentunderground.DivergentUnderground;
import panda.divergentunderground.experimental.CompatibilityPlugin;
import panda.divergentunderground.experimental.ICompatibilityPlugin;
import panda.divergentunderground.init.ModBlocks;
import panda.divergentunderground.init.ModItems;
import panda.divergentunderground.proxy.ClientProxy;
import panda.divergentunderground.registries.OreRegistry;
import panda.divergentunderground.registries.RockRegistry;

@CompatibilityPlugin(value="ic2")
public class IndustrialCraftCompat
implements ICompatibilityPlugin {
    private static final String texturePath = "ic2:blocks/resource/";
    private static final String modid = "ic2";
    public static final Block IC2_BLOCK = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("ic2:resource"));
    public static final Block HARD_COPPER = ModBlocks.makeHardBlock(IC2_BLOCK.func_176203_a(1), 1, "ic2:blocks/resource/copper_ore", "ic2", "copper");
    public static final Block HARD_LEAD = ModBlocks.makeHardBlock(IC2_BLOCK.func_176203_a(2), 1, "ic2:blocks/resource/lead_ore", "ic2", "lead");
    public static final Block HARD_TIN = ModBlocks.makeHardBlock(IC2_BLOCK.func_176203_a(3), 1, "ic2:blocks/resource/tin_ore", "ic2", "tin");
    public static final Block HARD_URANIUM = ModBlocks.makeHardBlock(IC2_BLOCK.func_176203_a(4), 1, "ic2:blocks/resource/uranium_ore", "ic2", "uranium");
    public static final Item ORE_COPPER = ModItems.makeOre("ic2", "copper");
    public static final Item ORE_TIN = ModItems.makeOre("ic2", "tin");
    public static final Item ORE_LEAD = ModItems.makeOre("ic2", "lead");
    public static final Item ORE_URANIUM = ModItems.makeOre("ic2", "uranium");

    @Override
    public void preInit() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void init() {
        RockRegistry.addRock(IC2_BLOCK, 1, ModItems.ROCK_STONE);
        RockRegistry.addRock(IC2_BLOCK, 2, ModItems.ROCK_STONE);
        RockRegistry.addRock(IC2_BLOCK, 3, ModItems.ROCK_STONE);
        RockRegistry.addRock(IC2_BLOCK, 4, ModItems.ROCK_STONE);
        OreRegistry.addOre(IC2_BLOCK, 1, ORE_COPPER);
        OreRegistry.addOre(IC2_BLOCK, 2, ORE_LEAD);
        OreRegistry.addOre(IC2_BLOCK, 3, ORE_TIN);
        OreRegistry.addOre(IC2_BLOCK, 4, ORE_URANIUM);
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)HARD_COPPER);
        registry.register((IForgeRegistryEntry)HARD_TIN);
        registry.register((IForgeRegistryEntry)HARD_LEAD);
        registry.register((IForgeRegistryEntry)HARD_URANIUM);
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)ORE_COPPER);
        registry.register((IForgeRegistryEntry)ORE_TIN);
        registry.register((IForgeRegistryEntry)ORE_LEAD);
        registry.register((IForgeRegistryEntry)ORE_URANIUM);
        ModItems.registerItemBlock((IForgeRegistry<Item>)registry, HARD_COPPER);
        ModItems.registerItemBlock((IForgeRegistry<Item>)registry, HARD_TIN);
        ModItems.registerItemBlock((IForgeRegistry<Item>)registry, HARD_LEAD);
        ModItems.registerItemBlock((IForgeRegistry<Item>)registry, HARD_URANIUM);
        DivergentUnderground.doDicts("Copper", ORE_COPPER, HARD_COPPER);
        DivergentUnderground.doDicts("Tin", ORE_TIN, HARD_TIN);
        DivergentUnderground.doDicts("Lead", ORE_LEAD, HARD_LEAD);
        DivergentUnderground.doDicts("Uranium", ORE_URANIUM, HARD_URANIUM);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        ClientProxy.registerItemModel(ORE_COPPER);
        ClientProxy.registerBlockModel(HARD_COPPER);
        ClientProxy.registerItemModel(ORE_TIN);
        ClientProxy.registerBlockModel(HARD_TIN);
        ClientProxy.registerItemModel(ORE_LEAD);
        ClientProxy.registerBlockModel(HARD_LEAD);
        ClientProxy.registerItemModel(ORE_URANIUM);
        ClientProxy.registerBlockModel(HARD_URANIUM);
    }
}

