/*
 * Decompiled with CFR 0.152.
 */
package panda.divergentunderground.init;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import panda.divergentunderground.DivergentUnderground;
import panda.divergentunderground.common.items.ItemChisel;
import panda.divergentunderground.common.items.ItemDU;
import panda.divergentunderground.init.ModBlocks;

@Mod.EventBusSubscriber
public final class ModItems {
    public static final String ITEMSDIR = "divergentunderground:items/";
    public static final Item ORE_GOLD = ModItems.makeOre("gold");
    public static final Item ORE_IRON = ModItems.makeOre("iron");
    public static final Item ROCK_ANDESITE = ModItems.makeRock("andesite");
    public static final Item ROCK_DIORITE = ModItems.makeRock("diorite");
    public static final Item ROCK_GRANITE = ModItems.makeRock("granite");
    public static final Item ROCK_NETHERRACK = ModItems.makeRock("netherrack");
    public static final Item ROCK_ENDSTONE = ModItems.makeRock("endstone");
    public static final Item ROCK_SANDSTONE = ModItems.makeRock("sandstone");
    public static final Item ROCK_RED_SANDSTONE = ModItems.makeRock("red_sandstone");
    public static final Item ROCK_STONE = ModItems.makeRock("stone");
    public static final Item UNCUT_EMERALD = ModItems.makeGem("emerald");
    public static final Item UNCUT_DIAMOND = ModItems.makeGem("diamond");
    public static final Item CHISEL = ModItems.simply(new ItemChisel(), "chisel");

    private ModItems() {
        DivergentUnderground.logger.info("Registering Items");
    }

    public static Item makeExternalRock(String modid, String key) {
        return ModItems.externalSimply(new ItemDU("divergentunderground:items/rock_" + modid + "_" + key), "rock_" + modid + "_" + key, modid);
    }

    public static Item makeRock(String modid, String key) {
        return ModItems.simply(new ItemDU("divergentunderground:items/integration/" + modid + "/rock_" + modid + "_" + key), "rock_" + modid + "_" + key);
    }

    private static Item makeRock(String key) {
        return ModItems.simply(new ItemDU("divergentunderground:items/rock_" + key), "rock_" + key);
    }

    public static Item makeExternalOre(String modid, String key) {
        return ModItems.externalSimply(new ItemDU("divergentunderground:items/ore_" + modid + "_" + key), "ore_" + modid + "_" + key, modid);
    }

    public static Item makeOre(String modid, String key) {
        return ModItems.simply(new ItemDU("divergentunderground:items/integration/" + modid + "/ore_" + modid + "_" + key), "ore_" + modid + "_" + key);
    }

    private static Item makeOre(String key) {
        return ModItems.simply(new ItemDU("divergentunderground:items/ore_" + key), "ore_" + key);
    }

    public static Item makeExternalGem(String itemsDir, String modid, String key) {
        return ModItems.externalSimply(new ItemDU(itemsDir + "gem_raw_" + modid + "_" + key), "gem_raw_" + modid + "_" + key, modid);
    }

    public static Item makeGem(String modid, String key) {
        return ModItems.simply(new ItemDU("divergentunderground:items/integration/" + modid + "/gem_raw_" + modid + "_" + key), "gem_raw_" + modid + "_" + key);
    }

    private static Item makeGem(String key) {
        return ModItems.simply(new ItemDU("divergentunderground:items/gem_raw_" + key), "gem_raw_" + key);
    }

    private static Item simply(Item item, String name) {
        return ((Item)item.setRegistryName("divergentunderground", name)).func_77655_b("divergentunderground." + name).func_77637_a(DivergentUnderground.Tab);
    }

    private static Item externalSimply(Item item, String name, String modid) {
        return ((Item)item.setRegistryName(modid, name)).func_77655_b(modid + "." + name).func_77637_a(DivergentUnderground.Tab);
    }

    @SubscribeEvent
    public static void register(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)ROCK_STONE);
        registry.register((IForgeRegistryEntry)ROCK_ANDESITE);
        registry.register((IForgeRegistryEntry)ROCK_DIORITE);
        registry.register((IForgeRegistryEntry)ROCK_GRANITE);
        registry.register((IForgeRegistryEntry)ROCK_SANDSTONE);
        registry.register((IForgeRegistryEntry)ROCK_RED_SANDSTONE);
        registry.register((IForgeRegistryEntry)ROCK_NETHERRACK);
        registry.register((IForgeRegistryEntry)ROCK_ENDSTONE);
        registry.register((IForgeRegistryEntry)ORE_GOLD);
        registry.register((IForgeRegistryEntry)ORE_IRON);
        registry.register((IForgeRegistryEntry)UNCUT_EMERALD);
        registry.register((IForgeRegistryEntry)UNCUT_DIAMOND);
        registry.register((IForgeRegistryEntry)CHISEL);
        ModItems.registerItemBlock((IForgeRegistry<Item>)registry, ModBlocks.HARD_STONE);
        ModItems.registerItemBlock((IForgeRegistry<Item>)registry, ModBlocks.HARD_GRANITE);
        ModItems.registerItemBlock((IForgeRegistry<Item>)registry, ModBlocks.HARD_ANDESITE);
        ModItems.registerItemBlock((IForgeRegistry<Item>)registry, ModBlocks.HARD_DIORITE);
        ModItems.registerItemBlock((IForgeRegistry<Item>)registry, ModBlocks.HARD_IRON);
        ModItems.registerItemBlock((IForgeRegistry<Item>)registry, ModBlocks.HARD_GOLD);
        ModItems.registerItemBlock((IForgeRegistry<Item>)registry, ModBlocks.HARD_COAL);
        ModItems.registerItemBlock((IForgeRegistry<Item>)registry, ModBlocks.HARD_DIAMOND);
        ModItems.registerItemBlock((IForgeRegistry<Item>)registry, ModBlocks.HARD_EMERALD);
        ModItems.registerItemBlock((IForgeRegistry<Item>)registry, ModBlocks.HARD_LAPIS);
        ModItems.registerItemBlock((IForgeRegistry<Item>)registry, ModBlocks.HARD_REDSTONE);
        ModItems.registerItemBlock((IForgeRegistry<Item>)registry, ModBlocks.ANDESITE_COBBLE);
        ModItems.registerItemBlock((IForgeRegistry<Item>)registry, ModBlocks.DIORITE_COBBLE);
        ModItems.registerItemBlock((IForgeRegistry<Item>)registry, ModBlocks.GRANITE_COBBLE);
        ModItems.registerItemBlock((IForgeRegistry<Item>)registry, ModBlocks.FOSSIL);
        ModItems.registerItemBlock((IForgeRegistry<Item>)registry, ModBlocks.BOULDER);
    }

    public static void registerItemBlock(IForgeRegistry<Item> registry, Block block) {
        registry.register(new ItemBlock(block).setRegistryName(block.getRegistryName()));
    }
}

