/*
 * Decompiled with CFR 0.152.
 */
package panda.divergentunderground.init;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStone;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import panda.divergentunderground.DivergentUnderground;
import panda.divergentunderground.common.blocks.BlockBoulder;
import panda.divergentunderground.common.blocks.BlockFossil;
import panda.divergentunderground.common.blocks.BlockHardStone;

@Mod.EventBusSubscriber
public final class ModBlocks {
    public static List<BlockHardStone> hardStones = new ArrayList<BlockHardStone>();
    public static final Block HARD_STONE = ModBlocks.simply(new BlockHardStone(Blocks.field_150348_b.func_176223_P(), 0, "blocks/stone"), "hard_stone");
    public static final Block HARD_GRANITE = ModBlocks.simply(new BlockHardStone(Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.GRANITE), 0, "blocks/stone_granite"), "hard_granite");
    public static final Block HARD_DIORITE = ModBlocks.simply(new BlockHardStone(Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.DIORITE), 0, "blocks/stone_diorite"), "hard_diorite");
    public static final Block HARD_ANDESITE = ModBlocks.simply(new BlockHardStone(Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.ANDESITE), 0, "blocks/stone_andesite"), "hard_andesite");
    public static final Block HARD_IRON = ModBlocks.simply(new BlockHardStone(Blocks.field_150366_p.func_176223_P(), 1, "blocks/iron_ore"), "hard_iron_ore");
    public static final Block HARD_GOLD = ModBlocks.simply(new BlockHardStone(Blocks.field_150352_o.func_176223_P(), 1, "blocks/gold_ore"), "hard_gold_ore");
    public static final Block HARD_COAL = ModBlocks.simply(new BlockHardStone(Blocks.field_150365_q.func_176223_P(), 1, "blocks/coal_ore"), "hard_coal_ore");
    public static final Block HARD_DIAMOND = ModBlocks.simply(new BlockHardStone(Blocks.field_150482_ag.func_176223_P(), 2, "blocks/diamond_ore"), "hard_diamond_ore");
    public static final Block HARD_EMERALD = ModBlocks.simply(new BlockHardStone(Blocks.field_150412_bA.func_176223_P(), 2, "blocks/emerald_ore"), "hard_emerald_ore");
    public static final Block HARD_LAPIS = ModBlocks.simply(new BlockHardStone(Blocks.field_150369_x.func_176223_P(), 1, "blocks/lapis_ore"), "hard_lapis_ore");
    public static final Block HARD_REDSTONE = ModBlocks.simply(new BlockHardStone(Blocks.field_150450_ax.func_176223_P(), 1, "blocks/redstone_ore"), "hard_redstone_ore");
    public static final Block GRANITE_COBBLE = ModBlocks.simplynormal(new Block(Material.field_151576_e).func_149752_b(10.0f).func_149711_c(1.5f), "granite_cobblestone");
    public static final Block ANDESITE_COBBLE = ModBlocks.simplynormal(new Block(Material.field_151576_e).func_149752_b(10.0f).func_149711_c(1.5f), "andesite_cobblestone");
    public static final Block DIORITE_COBBLE = ModBlocks.simplynormal(new Block(Material.field_151576_e).func_149752_b(10.0f).func_149711_c(1.5f), "diorite_cobblestone");
    public static final Block FOSSIL = ModBlocks.simply(new BlockFossil(), "fossil");
    public static final Block BOULDER = ModBlocks.simplynormal((Block)new BlockBoulder(), "boulder");

    private ModBlocks() {
        DivergentUnderground.logger.info("Registering Blocks");
    }

    public static Block simplynormal(Block block, String name) {
        return ((Block)block.setRegistryName("divergentunderground", name)).func_149663_c("divergentunderground." + name).func_149647_a(DivergentUnderground.Tab);
    }

    public static Block simply(BlockHardStone block, String name) {
        hardStones.add(block);
        return ((Block)block.setRegistryName("divergentunderground", name)).func_149663_c("divergentunderground." + name).func_149647_a(DivergentUnderground.Tab);
    }

    public static Block makeHardBlock(IBlockState replacement, int type, String texture, String modid, String name) {
        String end = "_rock";
        if (type > 0) {
            end = "_ore";
        }
        return ModBlocks.simply(new BlockHardStone(replacement, type, texture), modid + "_hard_" + name + end);
    }

    @SubscribeEvent
    public static void register(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)HARD_STONE);
        registry.register((IForgeRegistryEntry)HARD_GRANITE);
        registry.register((IForgeRegistryEntry)HARD_DIORITE);
        registry.register((IForgeRegistryEntry)HARD_ANDESITE);
        registry.register((IForgeRegistryEntry)HARD_IRON);
        registry.register((IForgeRegistryEntry)HARD_GOLD);
        registry.register((IForgeRegistryEntry)HARD_COAL);
        registry.register((IForgeRegistryEntry)HARD_DIAMOND);
        registry.register((IForgeRegistryEntry)HARD_EMERALD);
        registry.register((IForgeRegistryEntry)HARD_LAPIS);
        registry.register((IForgeRegistryEntry)HARD_REDSTONE);
        registry.register((IForgeRegistryEntry)GRANITE_COBBLE);
        registry.register((IForgeRegistryEntry)ANDESITE_COBBLE);
        registry.register((IForgeRegistryEntry)DIORITE_COBBLE);
        registry.register((IForgeRegistryEntry)FOSSIL);
        registry.register((IForgeRegistryEntry)BOULDER);
    }
}

