/*
 * Decompiled with CFR 0.152.
 */
package panda.divergentunderground.common.eventhandler;

import akka.japi.Pair;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.OreDictionary;
import panda.divergentunderground.ConfigDivergentUnderground;
import panda.divergentunderground.common.blocks.BlockHardStone;
import panda.divergentunderground.common.items.ItemDU;
import panda.divergentunderground.init.ModBlocks;
import panda.divergentunderground.registries.GemRegistry;
import panda.divergentunderground.registries.OreRegistry;
import panda.divergentunderground.registries.RockRegistry;

public class EventsHandler {
    protected int updateLCG = new Random().nextInt();

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onHarvestDropsEvent(BlockEvent.HarvestDropsEvent event) {
        Block block = event.getState().func_177230_c();
        ItemStack blockstack = block.func_185473_a(event.getWorld(), event.getPos(), event.getState());
        if (block instanceof BlockHardStone) {
            return;
        }
        if (!event.isSilkTouching()) {
            int count;
            Random rand;
            if (RockRegistry.hasRocks(new Pair((Object)block, (Object)blockstack.func_77960_j()))) {
                this.replaceDrops(event, blockstack);
                event.setDropChance(1.0f);
            }
            if (OreRegistry.hasOres(new Pair((Object)block, (Object)blockstack.func_77960_j()))) {
                rand = event.getWorld().field_73012_v;
                count = rand.nextInt(event.getFortuneLevel() + 2) - 1;
                ItemStack ore = OreRegistry.getOres(new Pair((Object)block, (Object)blockstack.func_77960_j()));
                if (count < 0) {
                    count = 0;
                }
                ore.func_190920_e(count + 1);
                Block.func_180635_a((World)event.getWorld(), (BlockPos)event.getPos(), (ItemStack)ore);
                event.setDropChance(1.0f);
            }
            if (GemRegistry.hasGems(new Pair((Object)block, (Object)blockstack.func_77960_j())) && ConfigDivergentUnderground.doGemDrops) {
                rand = event.getWorld().field_73012_v;
                count = rand.nextInt(event.getFortuneLevel() + 2) - 1;
                ItemStack gem = GemRegistry.getGems(new Pair((Object)block, (Object)blockstack.func_77960_j()));
                if (count < 0) {
                    count = 0;
                }
                gem.func_190920_e(count + 1);
                List drops = event.getDrops();
                for (int i = 0; i < drops.size(); ++i) {
                    ItemStack stack = (ItemStack)drops.get(i);
                    if (!ItemStack.func_185132_d((ItemStack)stack, (ItemStack)blockstack) && Block.func_149634_a((Item)event.getState().func_177230_c().func_180660_a(event.getState(), event.getWorld().field_73012_v, event.getFortuneLevel())) != Blocks.field_150350_a) continue;
                    drops.set(i, gem);
                }
                event.setDropChance(1.0f);
            }
        }
    }

    private void replaceDrops(BlockEvent.HarvestDropsEvent e, ItemStack blockstack) {
        List drops = e.getDrops();
        boolean flag = true;
        int count = 2 + e.getWorld().field_73012_v.nextInt(2);
        if (e.getFortuneLevel() > 0) {
            count = 4;
        }
        ItemStack rock = RockRegistry.getRocks(new Pair((Object)e.getState().func_177230_c(), (Object)blockstack.func_77960_j()));
        rock.func_190920_e(count);
        for (int i = 0; i < drops.size(); ++i) {
            ItemStack stack = (ItemStack)drops.get(i);
            if (!ItemStack.func_185132_d((ItemStack)stack, (ItemStack)blockstack) && Block.func_149634_a((Item)e.getState().func_177230_c().func_180660_a(e.getState(), e.getWorld().field_73012_v, e.getFortuneLevel())) == Blocks.field_150350_a) continue;
            flag = false;
            drops.set(i, rock);
        }
        if (flag) {
            Block.func_180635_a((World)e.getWorld(), (BlockPos)e.getPos(), (ItemStack)rock);
        }
    }

    @SubscribeEvent
    public void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (!(event.getState().func_177230_c() instanceof BlockHardStone) || !ConfigDivergentUnderground.doHardnessSlowdown) {
            return;
        }
        ItemStack heldItemStack = event.getEntityPlayer().func_184614_ca();
        if (heldItemStack.func_190926_b() || !(heldItemStack.func_77973_b() instanceof ItemPickaxe)) {
            return;
        }
        float slowdown = 1.0f;
        switch (event.getState().func_177230_c().func_176201_c(event.getState())) {
            case 1: {
                slowdown += ConfigDivergentUnderground.hardnessOneSD;
                break;
            }
            case 2: {
                slowdown += ConfigDivergentUnderground.hardnessTwoSD;
                break;
            }
            case 3: {
                slowdown += ConfigDivergentUnderground.hardnessThreeSD;
                break;
            }
            default: {
                slowdown += ConfigDivergentUnderground.hardnessZeroSD;
            }
        }
        event.setNewSpeed(event.getOriginalSpeed() / slowdown);
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START || event.side == Side.CLIENT || !ConfigDivergentUnderground.doCompression) {
            return;
        }
        int i = event.world.func_82736_K().func_180263_c("randomTickSpeed");
        if (i > 0) {
            Iterator chunkIterator = ((WorldServer)event.world).func_184164_w().func_187300_b();
            Iterator iterator = ForgeChunkManager.getPersistentChunksIterableFor((World)event.world, (Iterator)chunkIterator);
            while (iterator.hasNext()) {
                Chunk chunk = (Chunk)iterator.next();
                int j = chunk.field_76635_g * 16;
                int k = chunk.field_76647_h * 16;
                for (ExtendedBlockStorage extendedblockstorage : chunk.func_76587_i()) {
                    if (extendedblockstorage == Chunk.field_186036_a || extendedblockstorage.func_76663_a()) continue;
                    for (int i1 = 0; i1 < i; ++i1) {
                        Block newBlock;
                        BlockPos pos;
                        boolean shouldBeHard;
                        boolean hard;
                        this.updateLCG = this.updateLCG * 3 + 1013904223;
                        int j1 = this.updateLCG >> 2;
                        int k1 = j1 & 0xF;
                        int i2 = j1 >> 16 & 0xF;
                        int l1 = j1 >> 8 & 0xF;
                        IBlockState iblockstate = extendedblockstorage.func_177485_a(k1, i2, l1);
                        Block block = iblockstate.func_177230_c();
                        if (block != Blocks.field_150348_b && block != ModBlocks.HARD_STONE || (hard = block == ModBlocks.HARD_STONE) == (shouldBeHard = BlockHardStone.isSurroundedByCompressingBlocks(event.world, pos = new BlockPos(k1 + j, i2 + extendedblockstorage.func_76662_d(), l1 + k), false))) continue;
                        Block block2 = newBlock = shouldBeHard ? ModBlocks.HARD_STONE : Blocks.field_150348_b;
                        if (newBlock == ModBlocks.HARD_STONE) {
                            int y = event.world.func_175672_r(pos).func_177956_o();
                            event.world.func_180501_a(pos, ((BlockHardStone)newBlock).getStateFromDepth(y, i2, shouldBeHard), 6);
                        } else {
                            event.world.func_180501_a(pos, newBlock.func_176203_a(0), 6);
                        }
                        if (shouldBeHard || !ConfigDivergentUnderground.doUpdateSound) continue;
                        event.world.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187540_ab, SoundCategory.BLOCKS, 0.2f, 1.0f);
                    }
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onCraft(PlayerEvent.ItemCraftedEvent event) {
        World world = event.player.field_70170_p;
        ItemStack itemstack = event.crafting;
        if (world.field_72995_K && ConfigDivergentUnderground.doChiselXP) {
            return;
        }
        boolean hasUncutGem = false;
        for (String name : OreDictionary.getOreNames()) {
            if (!name.startsWith("gem")) continue;
            for (int j = 0; j < event.craftMatrix.func_70302_i_(); ++j) {
                if (!(event.craftMatrix.func_70301_a(j).func_77973_b() instanceof ItemDU)) continue;
                hasUncutGem = true;
                break;
            }
            for (ItemStack orestack : OreDictionary.getOres((String)name)) {
                int i;
                if (!hasUncutGem || orestack.func_77973_b() != itemstack.func_77973_b()) continue;
                for (int amount = world.field_73012_v.nextInt(2) + 1; amount > 0; amount -= i) {
                    i = EntityXPOrb.func_70527_a((int)amount);
                    world.func_72838_d((Entity)new EntityXPOrb(world, event.player.field_70165_t, event.player.field_70163_u + 1.0, event.player.field_70161_v, i));
                }
                return;
            }
        }
    }
}

