/*
 * Decompiled with CFR 0.152.
 */
package panda.divergentunderground.common.crafting;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RecipeShapelessTool
implements IRecipeFactory {
    public IRecipe parse(JsonContext context, JsonObject json) {
        NonNullList ings = NonNullList.func_191196_a();
        for (JsonElement ele : JsonUtils.func_151214_t((JsonObject)json, (String)"ingredients")) {
            ings.add((Object)CraftingHelper.getIngredient((JsonElement)ele, (JsonContext)context));
        }
        if (ings.isEmpty()) {
            throw new JsonParseException("No ingredients for shapeless recipe");
        }
        ItemStack itemstack = CraftingHelper.getItemStack((JsonObject)JsonUtils.func_152754_s((JsonObject)json, (String)"result"), (JsonContext)context);
        return new ShapelessToolRecipe(itemstack, (NonNullList<Ingredient>)ings);
    }

    public static class ShapelessToolRecipe
    extends IForgeRegistryEntry.Impl<IRecipe>
    implements IRecipe {
        private final ItemStack recipeOutput;
        public final NonNullList<Ingredient> recipeItems;
        private final String group;

        public ShapelessToolRecipe(ItemStack output, NonNullList<Ingredient> nonNullList) {
            this.group = "divergentunderground";
            this.recipeOutput = output;
            this.recipeItems = nonNullList;
        }

        public String func_193358_e() {
            return this.group;
        }

        public ItemStack func_77571_b() {
            return this.recipeOutput;
        }

        public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
            NonNullList nonnulllist = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
            for (int i = 0; i < nonnulllist.size(); ++i) {
                ItemStack itemstack = inv.func_70301_a(i);
                if (!itemstack.func_190926_b()) {
                    for (String name : OreDictionary.getOreNames()) {
                        if (!name.startsWith("tool")) continue;
                        for (ItemStack orestack : OreDictionary.getOres((String)name)) {
                            if (orestack.func_77973_b() != itemstack.func_77973_b()) continue;
                            ItemStack toolcopy = itemstack.func_77946_l();
                            nonnulllist.set(i, (Object)toolcopy.func_77973_b().getContainerItem(itemstack));
                        }
                    }
                    continue;
                }
                nonnulllist.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)itemstack));
            }
            return nonnulllist;
        }

        public NonNullList<Ingredient> func_192400_c() {
            return this.recipeItems;
        }

        public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
            ArrayList list = Lists.newArrayList(this.recipeItems);
            for (int i = 0; i < inv.func_174923_h(); ++i) {
                for (int j = 0; j < inv.func_174922_i(); ++j) {
                    ItemStack itemstack = inv.func_70463_b(j, i);
                    if (itemstack.func_190926_b()) continue;
                    boolean flag = false;
                    for (Ingredient ingredient : list) {
                        if (!ingredient.apply(itemstack)) continue;
                        flag = true;
                        list.remove(ingredient);
                        break;
                    }
                    if (flag) continue;
                    return false;
                }
            }
            return list.isEmpty();
        }

        public ItemStack func_77572_b(InventoryCrafting inv) {
            return this.recipeOutput.func_77946_l();
        }

        public static ShapelessRecipes deserialize(JsonObject json) {
            String s = JsonUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            NonNullList<Ingredient> nonnulllist = ShapelessToolRecipe.deserializeIngredients(JsonUtils.func_151214_t((JsonObject)json, (String)"ingredients"));
            if (nonnulllist.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            if (nonnulllist.size() > 9) {
                throw new JsonParseException("Too many ingredients for shapeless recipe");
            }
            ItemStack itemstack = ShapedRecipes.func_192405_a((JsonObject)JsonUtils.func_152754_s((JsonObject)json, (String)"result"), (boolean)true);
            return new ShapelessRecipes(s, itemstack, nonnulllist);
        }

        private static NonNullList<Ingredient> deserializeIngredients(JsonArray array) {
            NonNullList nonnulllist = NonNullList.func_191196_a();
            for (int i = 0; i < array.size(); ++i) {
                Ingredient ingredient = ShapedRecipes.func_193361_a((JsonElement)array.get(i));
                if (ingredient == Ingredient.field_193370_a) continue;
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        public boolean func_194133_a(int width, int height) {
            return width * height >= this.recipeItems.size();
        }
    }
}

