/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.generator.surface;

import com.pg85.otg.LocalMaterialData;
import com.pg85.otg.OTG;
import com.pg85.otg.configuration.BiomeConfig;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.generator.ChunkBuffer;
import com.pg85.otg.generator.GeneratingChunk;
import com.pg85.otg.generator.surface.SimpleSurfaceGenerator;
import com.pg85.otg.util.helpers.StringHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MultipleLayersSurfaceGenerator
extends SimpleSurfaceGenerator {
    private List<LayerChoice> layerChoices;

    public MultipleLayersSurfaceGenerator(String[] args) throws InvalidConfigException {
        if (args.length < 2) {
            throw new InvalidConfigException("Needs at least two arguments");
        }
        this.layerChoices = new ArrayList<LayerChoice>();
        for (int i = 0; i < args.length - 2; i += 3) {
            LocalMaterialData surfaceBlock = OTG.readMaterial(args[i]);
            LocalMaterialData groundBlock = OTG.readMaterial(args[i + 1]);
            float maxNoise = (float)StringHelper.readDouble(args[i + 2], -20.0, 20.0);
            this.layerChoices.add(new LayerChoice(surfaceBlock, groundBlock, maxNoise));
        }
        Collections.sort(this.layerChoices);
    }

    @Override
    public void spawn(GeneratingChunk generatingChunkInfo, ChunkBuffer chunkBuffer, BiomeConfig config, int xInWorld, int zInWorld) {
        int x = xInWorld & 0xF;
        int z = zInWorld & 0xF;
        double noise = generatingChunkInfo.getNoise(x, z);
        for (LayerChoice layer : this.layerChoices) {
            if (!(noise <= (double)layer.maxNoise)) continue;
            this.spawnColumn(layer.surfaceBlock, layer.groundBlock, generatingChunkInfo, chunkBuffer, config, x, z);
            return;
        }
        this.spawnColumn(config.surfaceBlock, config.groundBlock, generatingChunkInfo, chunkBuffer, config, x, z);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (LayerChoice groundLayer : this.layerChoices) {
            stringBuilder.append(groundLayer.surfaceBlock);
            stringBuilder.append(',').append(' ');
            stringBuilder.append(groundLayer.groundBlock);
            stringBuilder.append(',').append(' ');
            stringBuilder.append(groundLayer.maxNoise);
            stringBuilder.append(',').append(' ');
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 2);
        return stringBuilder.toString();
    }

    public static class LayerChoice
    implements Comparable<LayerChoice> {
        public final LocalMaterialData surfaceBlock;
        public final LocalMaterialData groundBlock;
        public final float maxNoise;

        public LayerChoice(LocalMaterialData surfaceBlock, LocalMaterialData groundBlock, float maxNoise) {
            this.surfaceBlock = surfaceBlock;
            this.groundBlock = groundBlock;
            this.maxNoise = maxNoise;
        }

        @Override
        public int compareTo(LayerChoice that) {
            float delta = this.maxNoise - that.maxNoise;
            return (int)(delta * 65565.0f);
        }
    }
}

