/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.generator.resource;

import com.pg85.otg.LocalMaterialData;
import com.pg85.otg.LocalWorld;
import com.pg85.otg.configuration.BiomeConfig;
import com.pg85.otg.configuration.ConfigFunction;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.generator.noise.NoiseGeneratorOldOctaves;
import com.pg85.otg.generator.resource.Resource;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.MaterialSet;
import java.util.List;
import java.util.Random;

public class SurfacePatchGen
extends Resource {
    protected LocalMaterialData decorationAboveReplacements;
    private final int maxAltitude;
    private final int minAltitude;
    private final NoiseGeneratorOldOctaves noiseGen;
    private final Random random;
    private final MaterialSet sourceBlocks;

    public SurfacePatchGen(BiomeConfig biomeConfig, List<String> args) throws InvalidConfigException {
        super(biomeConfig);
        this.assureSize(4, args);
        this.material = this.readMaterial(args.get(0));
        this.decorationAboveReplacements = this.readMaterial(args.get(1));
        this.minAltitude = this.readInt(args.get(2), 0, 256);
        this.maxAltitude = this.readInt(args.get(3), this.minAltitude, 256);
        this.sourceBlocks = this.readMaterials(args, 4);
        this.random = new Random(2345L);
        this.noiseGen = new NoiseGeneratorOldOctaves(this.random, 1);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SurfacePatchGen other = (SurfacePatchGen)obj;
        if (!this.decorationAboveReplacements.equals(other.decorationAboveReplacements)) {
            return false;
        }
        if (this.maxAltitude != other.maxAltitude) {
            return false;
        }
        if (this.minAltitude != other.minAltitude) {
            return false;
        }
        return this.sourceBlocks.equals(other.sourceBlocks);
    }

    @Override
    public int getPriority() {
        return -10;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.decorationAboveReplacements == null ? 0 : this.decorationAboveReplacements.hashCode());
        result = 31 * result + this.maxAltitude;
        result = 31 * result + this.minAltitude;
        result = 31 * result + (this.sourceBlocks == null ? 0 : this.sourceBlocks.hashCode());
        return result;
    }

    @Override
    public boolean isAnalogousTo(ConfigFunction<BiomeConfig> other) {
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        SurfacePatchGen resource = (SurfacePatchGen)other;
        return resource.material.equals(this.material) && resource.decorationAboveReplacements.equals(this.decorationAboveReplacements);
    }

    @Override
    public String toString() {
        return "SurfacePatch(" + this.material + "," + this.decorationAboveReplacements + "," + this.minAltitude + "," + this.maxAltitude + "," + this.sourceBlocks + ")";
    }

    @Override
    public void spawn(LocalWorld world, Random rand, boolean villageInChunk, int x, int z) {
        LocalMaterialData materialAtLocation;
        int y = world.getHighestBlockYAt(x, z) - 1;
        if (y < this.minAltitude || y > this.maxAltitude) {
            return;
        }
        double yNoise = this.noiseGen.getYNoise((double)x * 0.25, (double)z * 0.25);
        if (yNoise > 0.0 && this.sourceBlocks.contains(materialAtLocation = world.getMaterial(x, y, z, false))) {
            world.setBlock(x, y, z, this.material, null, false);
            if (yNoise < 0.12) {
                world.setBlock(x, y + 1, z, this.decorationAboveReplacements, null, false);
            }
        }
    }

    @Override
    protected void spawnInChunk(LocalWorld world, Random random, boolean villageInChunk, ChunkCoordinate chunkCoord) {
        int chunkX = chunkCoord.getBlockXCenter();
        int chunkZ = chunkCoord.getBlockZCenter();
        for (int z0 = 0; z0 < 16; ++z0) {
            for (int x0 = 0; x0 < 16; ++x0) {
                int x = chunkX + x0;
                int z = chunkZ + z0;
                this.spawn(world, random, false, x, z);
            }
        }
    }
}

