/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.generator;

import com.google.common.collect.Lists;
import com.pg85.otg.OTG;
import com.pg85.otg.forge.ForgeBiome;
import com.pg85.otg.forge.ForgeWorld;
import com.pg85.otg.generator.biome.BiomeGenerator;
import com.pg85.otg.generator.biome.OutputType;
import com.pg85.otg.util.minecraftTypes.DefaultBiome;
import java.util.List;
import java.util.Random;
import net.minecraft.init.Biomes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.structure.MapGenVillage;

public class OTGBiomeProvider
extends BiomeProvider {
    private final BiomeGenerator biomeGenerator;
    private final ForgeWorld localWorld;
    private static List<Biome> forbiddenBiomes = Lists.newArrayList((Object[])new Biome[]{Biomes.field_76778_j, Biomes.field_76779_k, Biomes.field_185440_P});

    public OTGBiomeProvider(ForgeWorld world, BiomeGenerator biomeGenerator) {
        this.localWorld = world;
        this.biomeGenerator = biomeGenerator;
    }

    public Biome func_180631_a(BlockPos blockPos) {
        return OTG.isForge ? ((ForgeBiome)OTG.getBiomeAllWorlds(this.biomeGenerator.getBiome(blockPos.func_177958_n(), blockPos.func_177952_p()))).getHandle() : this.localWorld.getBiomeById(this.biomeGenerator.getBiome(blockPos.func_177958_n(), blockPos.func_177952_p())).getHandle();
    }

    public Biome func_180300_a(BlockPos pos, Biome defaultOption) {
        ForgeBiome biome;
        ForgeBiome forgeBiome = biome = OTG.isForge ? (ForgeBiome)OTG.getBiomeAllWorlds(this.biomeGenerator.getBiome(pos.func_177958_n(), pos.func_177952_p())) : this.localWorld.getBiomeByIdOrNull(this.biomeGenerator.getBiome(pos.func_177958_n(), pos.func_177952_p()));
        if (biome != null) {
            return biome.getHandle();
        }
        return defaultOption;
    }

    public Biome[] func_76937_a(Biome[] paramArrayOfBiomeBase, int x, int z, int width, int height) {
        if (paramArrayOfBiomeBase == null || paramArrayOfBiomeBase.length < width * height) {
            paramArrayOfBiomeBase = new Biome[width * height];
        }
        int[] arrayOfInt = this.biomeGenerator.getBiomesUnZoomed(null, x, z, width, height, OutputType.DEFAULT_FOR_WORLD);
        for (int i = 0; i < width * height; ++i) {
            paramArrayOfBiomeBase[i] = OTG.isForge ? ((ForgeBiome)OTG.getBiomeAllWorlds(arrayOfInt[i])).getHandle() : this.localWorld.getBiomeById(arrayOfInt[i]).getHandle();
        }
        return paramArrayOfBiomeBase;
    }

    public Biome[] func_76931_a(Biome[] listToReuse, int x, int z, int width, int length, boolean cacheFlag) {
        if (listToReuse == null || listToReuse.length < width * length) {
            listToReuse = new Biome[width * length];
        }
        int[] arrayOfInt = this.biomeGenerator.getBiomes(null, x, z, width, length, OutputType.DEFAULT_FOR_WORLD);
        for (int i = 0; i < width * length; ++i) {
            listToReuse[i] = OTG.isForge ? ((ForgeBiome)OTG.getBiomeAllWorlds(arrayOfInt[i])).getHandle() : this.localWorld.getBiomeById(arrayOfInt[i]).getHandle();
        }
        return listToReuse;
    }

    public boolean func_76940_a(int x, int z, int radius, List<Biome> allowed) {
        if (allowed == MapGenVillage.field_75055_e && this.localWorld.villageGen != null) {
            allowed = this.localWorld.villageGen.villageSpawnBiomes;
        }
        int i = x - radius >> 2;
        int j = z - radius >> 2;
        int k = x + radius >> 2;
        int m = z + radius >> 2;
        int n = k - i + 1;
        int i1 = m - j + 1;
        Biome[] arrayOfInt = this.func_76937_a(null, i, j, n, i1);
        for (int i2 = 0; i2 < n * i1; ++i2) {
            Biome localBiomeBase = arrayOfInt[i2];
            if (allowed.contains(localBiomeBase)) continue;
            return false;
        }
        return true;
    }

    public BlockPos func_180630_a(int x, int z, int range, List<Biome> biomes, Random random) {
        int i = x - range >> 2;
        int j = z - range >> 2;
        int k = x + range >> 2;
        int m = z + range >> 2;
        int n = k - i + 1;
        int i1 = m - j + 1;
        int[] arrayOfInt = this.biomeGenerator.getBiomesUnZoomed(null, i, j, n, i1, OutputType.DEFAULT_FOR_WORLD);
        BlockPos blockPos = null;
        int i2 = 0;
        for (int i3 = 0; i3 < arrayOfInt.length; ++i3) {
            if (arrayOfInt[i3] >= DefaultBiome.values().length) continue;
            int i4 = i + i3 % n << 2;
            int i5 = j + i3 / n << 2;
            Biome localBiomeBase = Biome.func_150568_d((int)arrayOfInt[i3]);
            if (forbiddenBiomes.contains(localBiomeBase) || blockPos != null && random.nextInt(i2 + 1) != 0) continue;
            blockPos = new BlockPos(i4, 0, i5);
            ++i2;
        }
        return blockPos;
    }

    public void func_76938_b() {
        this.biomeGenerator.cleanupCache();
    }
}

