/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.dimensions;

import com.pg85.otg.OTG;
import com.pg85.otg.configuration.ServerConfigProvider;
import com.pg85.otg.configuration.WorldConfig;
import com.pg85.otg.forge.ForgeEngine;
import com.pg85.otg.forge.ForgeWorld;
import com.pg85.otg.forge.OTGWorldServerMulti;
import com.pg85.otg.forge.dimensions.DimensionData;
import com.pg85.otg.forge.dimensions.OTGDimensionInfo;
import com.pg85.otg.forge.dimensions.WorldProviderOTG;
import com.pg85.otg.forge.generator.Cartographer;
import com.pg85.otg.logging.LogMarker;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.DimensionType;
import net.minecraft.world.GameType;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.ServerWorldEventHandler;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.apache.commons.io.FileUtils;

public class OTGDimensionManager {
    static HashMap<Integer, Integer> dimensionsOrder;
    private static Hashtable<Integer, Object> oldDims;

    public static boolean isDimensionNameRegistered(String dimensionName) {
        if (dimensionName.equals("overworld")) {
            return true;
        }
        for (int i = -1000; i < 1024; ++i) {
            DimensionType dimensionType;
            if (!DimensionManager.isDimensionRegistered((int)i) || (dimensionType = DimensionManager.getProviderType((int)i)).func_186067_c() == null || !dimensionType.func_186067_c().equals("OTG") || !dimensionType.func_186065_b().equals(dimensionName)) continue;
            return true;
        }
        return false;
    }

    public static void registerDimension(int id, DimensionType type) {
        DimensionManager.registerDimension((int)id, (DimensionType)type);
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("dimensionID", id);
        ArrayList<String> types = new ArrayList<String>();
        types.add("OPEN_TERRAIN_GENERATOR");
        OTGDimensionManager.writeNBTStrings("types", types, compound);
        FMLInterModComms.sendMessage((String)"openterraingenerator", (String)"registerDimension", (NBTTagCompound)compound);
    }

    public static void unregisterDimension(int dimensionId) {
        if (dimensionId == 0) {
            return;
        }
        DimensionManager.unregisterDimension((int)dimensionId);
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("dimensionID", dimensionId);
        ArrayList<String> types = new ArrayList<String>();
        types.add("OPEN_TERRAIN_GENERATOR");
        OTGDimensionManager.writeNBTStrings("types", types, compound);
        FMLInterModComms.sendMessage((String)"openterraingenerator", (String)"unregisterDimension", (NBTTagCompound)compound);
    }

    public static void writeNBTStrings(String id, Collection<String> strings, NBTTagCompound compound) {
        if (strings != null) {
            NBTTagList nbtTagList = new NBTTagList();
            for (String s : strings) {
                nbtTagList.func_74742_a((NBTBase)new NBTTagString(s));
            }
            compound.func_74782_a(id, (NBTBase)nbtTagList);
        }
    }

    public static int createDimension(String dimensionName, boolean keepLoaded, boolean initDimension, boolean saveDimensionData) {
        int newDimId = DimensionManager.getNextFreeDimId();
        OTGDimensionManager.registerDimension(newDimId, DimensionType.register((String)dimensionName, (String)"OTG", (int)newDimId, WorldProviderOTG.class, (boolean)keepLoaded));
        if (initDimension) {
            OTGDimensionManager.initDimension(newDimId, dimensionName);
        }
        int maxOrder = -1;
        for (Integer dimOrder : dimensionsOrder.values()) {
            if (dimOrder <= maxOrder) continue;
            maxOrder = dimOrder;
        }
        dimensionsOrder.put(newDimId, maxOrder + 1);
        if (saveDimensionData) {
            OTGDimensionManager.SaveDimensionData();
        }
        return newDimId;
    }

    public static void DeleteDimension(int dimToRemove, ForgeWorld world, MinecraftServer server, boolean saveDimensionData) {
        if (DimensionManager.getWorld((int)dimToRemove) != null) {
            DimensionManager.setWorld((int)dimToRemove, null, (MinecraftServer)server);
        }
        if (DimensionManager.isDimensionRegistered((int)dimToRemove)) {
            OTGDimensionManager.unregisterDimension(dimToRemove);
        }
        world.unRegisterBiomes();
        ((ForgeEngine)OTG.getEngine()).getWorldLoader().RemoveUnloadedWorld(world.getName());
        ((ForgeEngine)OTG.getEngine()).getWorldLoader().RemoveLoadedWorld(world.getName());
        OTGDimensionManager.UnloadCustomDimensionData(dimToRemove);
        world.DeleteWorldSessionData();
        BitSet dimensionMap = null;
        try {
            Field[] fields;
            for (Field field : fields = DimensionManager.class.getDeclaredFields()) {
                Class<?> fieldClass = field.getType();
                if (!fieldClass.equals(BitSet.class)) continue;
                field.setAccessible(true);
                dimensionMap = (BitSet)field.get(new DimensionManager());
                break;
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        dimensionMap.clear(dimToRemove);
        if (saveDimensionData) {
            File dimensionSaveDir = new File(world.getWorld().func_72860_G().func_75765_b() + "/DIM" + dimToRemove);
            if (dimensionSaveDir.exists() && dimensionSaveDir.isDirectory()) {
                OTG.log(LogMarker.INFO, "Deleting world save data for dimension " + dimToRemove, new Object[0]);
                try {
                    FileUtils.deleteDirectory((File)dimensionSaveDir);
                }
                catch (IOException e) {
                    OTG.log(LogMarker.ERROR, "Could not delete directory: " + e.toString(), new Object[0]);
                    e.printStackTrace();
                }
            }
            OTGDimensionManager.SaveDimensionData();
        }
    }

    private static void initDimension(int dim, String dimensionName) {
        WorldServer overworld = DimensionManager.getWorld((int)0);
        if (overworld == null) {
            throw new RuntimeException("Cannot Hotload Dim: Overworld is not Loaded!");
        }
        try {
            DimensionManager.getProviderType((int)dim);
        }
        catch (Exception e) {
            System.err.println("Cannot Hotload Dim: " + e.getMessage());
            return;
        }
        MinecraftServer mcServer = overworld.func_73046_m();
        ISaveHandler savehandler = overworld.func_72860_G();
        long seedIn = (long)Math.floor(Math.random() * 9.223372036854776E18);
        GameType gameType = mcServer.func_71265_f();
        boolean enableMapFeatures = overworld.func_72912_H().func_76089_r();
        boolean hardcoreMode = overworld.func_72912_H().func_76093_s();
        WorldType worldTypeIn = overworld.func_175624_G();
        WorldSettings settings = new WorldSettings(seedIn, gameType, enableMapFeatures, hardcoreMode, worldTypeIn);
        settings.func_82750_a("OpenTerrainGenerator");
        WorldInfo worldInfo = new WorldInfo(settings, overworld.func_72912_H().func_76065_j());
        WorldServer world = (WorldServer)new OTGWorldServerMulti(mcServer, savehandler, dim, overworld, mcServer.field_71304_b, worldInfo).func_175643_b();
        ForgeWorld forgeWorld = (ForgeWorld)OTG.getWorld(dimensionName);
        if (forgeWorld == null) {
            forgeWorld = (ForgeWorld)OTG.getUnloadedWorld(dimensionName);
        }
        if (forgeWorld != null) {
            ((ServerConfigProvider)forgeWorld.getConfigs()).getWorldConfig().worldSeed = "" + seedIn;
            ((ServerConfigProvider)forgeWorld.getConfigs()).saveWorldConfig();
            WorldConfig worldConfig = ((ServerConfigProvider)forgeWorld.getConfigs()).getWorldConfig();
            world.func_82736_K().func_82764_b("commandBlockOutput", worldConfig.commandBlockOutput);
            world.func_82736_K().func_82764_b("disableElytraMovementCheck", worldConfig.disableElytraMovementCheck);
            world.func_82736_K().func_82764_b("doDaylightCycle", worldConfig.doDaylightCycle);
            world.func_82736_K().func_82764_b("doEntityDrops", worldConfig.doEntityDrops);
            world.func_82736_K().func_82764_b("doFireTick", worldConfig.doFireTick);
            world.func_82736_K().func_82764_b("doMobLoot", worldConfig.doMobLoot);
            world.func_82736_K().func_82764_b("doMobSpawning", worldConfig.doMobSpawning);
            world.func_82736_K().func_82764_b("doTileDrops", worldConfig.doTileDrops);
            world.func_82736_K().func_82764_b("doWeatherCycle", worldConfig.doWeatherCycle);
            world.func_82736_K().func_82764_b("keepInventory", worldConfig.keepInventory);
            world.func_82736_K().func_82764_b("logAdminCommands", worldConfig.logAdminCommands);
            world.func_82736_K().func_82764_b("maxEntityCramming", worldConfig.maxEntityCramming);
            world.func_82736_K().func_82764_b("mobGriefing", worldConfig.mobGriefing);
            world.func_82736_K().func_82764_b("naturalRegeneration", worldConfig.naturalRegeneration);
            world.func_82736_K().func_82764_b("randomTickSpeed", worldConfig.randomTickSpeed);
            world.func_82736_K().func_82764_b("reducedDebugInfo", worldConfig.reducedDebugInfo);
            world.func_82736_K().func_82764_b("sendCommandFeedback", worldConfig.sendCommandFeedback);
            world.func_82736_K().func_82764_b("showDeathMessages", worldConfig.showDeathMessages);
            world.func_82736_K().func_82764_b("spawnRadius", worldConfig.spawnRadius);
            world.func_82736_K().func_82764_b("spectatorsGenerateChunks", worldConfig.spectatorsGenerateChunks);
        }
        world.func_72954_a((IWorldEventListener)new ServerWorldEventHandler(mcServer, world));
        MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Load((World)world));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void SaveDimensionData() {
        WorldServer world = DimensionManager.getWorld((int)0);
        File dimensionDataFile = new File(world.func_72860_G().func_75765_b() + "/OpenTerrainGenerator/Dimensions.txt");
        if (dimensionDataFile.exists()) {
            dimensionDataFile.delete();
        }
        StringBuilder stringbuilder = new StringBuilder();
        for (int i = 0; i < 1024; ++i) {
            DimensionType dimType;
            if (i == 1 || !DimensionManager.isDimensionRegistered((int)i) || (dimType = DimensionManager.getProviderType((int)i)) == null) continue;
            ForgeWorld forgeWorld = (ForgeWorld)OTG.getWorld(dimType.func_186065_b());
            if (forgeWorld == null) {
                forgeWorld = (ForgeWorld)OTG.getUnloadedWorld(dimType.func_186065_b());
            }
            if (forgeWorld == null || forgeWorld == null) continue;
            stringbuilder.append((stringbuilder.length() == 0 ? "" : ",") + i + "," + dimType.func_186065_b() + "," + dimType.shouldLoadSpawn() + "," + forgeWorld.getSeed() + "," + dimensionsOrder.get(i));
        }
        BufferedWriter writer = null;
        try {
            dimensionDataFile.getParentFile().mkdirs();
            writer = new BufferedWriter(new FileWriter(dimensionDataFile));
            writer.write(stringbuilder.toString());
            OTG.log(LogMarker.TRACE, "Custom dimension data saved", new Object[0]);
        }
        catch (IOException e) {
            OTG.log(LogMarker.ERROR, "Could not save custom dimension data.", new Object[0]);
            e.printStackTrace();
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void UnloadAllCustomDimensionData() {
        dimensionsOrder = new HashMap();
        dimensionsOrder.put(0, 0);
        BitSet dimensionMap = null;
        try {
            Field[] fields;
            for (Field field : fields = DimensionManager.class.getDeclaredFields()) {
                Class<?> fieldClass = field.getType();
                if (!fieldClass.equals(BitSet.class)) continue;
                field.setAccessible(true);
                dimensionMap = (BitSet)field.get(new DimensionManager());
                break;
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        for (int i = 2; i < 1024; ++i) {
            DimensionType dimType;
            if (!DimensionManager.isDimensionRegistered((int)i) || (dimType = DimensionManager.getProviderType((int)i)) == null || dimType.func_186067_c() == null || !dimType.func_186067_c().equals("OTG")) continue;
            OTGDimensionManager.unregisterDimension(i);
            dimensionMap.clear(i);
        }
    }

    public static void UnloadCustomDimensionData(int dimId) {
        DimensionType dimType;
        if (dimId == 0) {
            return;
        }
        dimensionsOrder.remove(dimId);
        BitSet dimensionMap = null;
        try {
            Field[] fields;
            for (Field field : fields = DimensionManager.class.getDeclaredFields()) {
                Class<?> fieldClass = field.getType();
                if (!fieldClass.equals(BitSet.class)) continue;
                field.setAccessible(true);
                dimensionMap = (BitSet)field.get(new DimensionManager());
                break;
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        if (DimensionManager.isDimensionRegistered((int)dimId) && (dimType = DimensionManager.getProviderType((int)dimId)) != null && dimType.func_186067_c() != null && dimType.func_186067_c().equals("OTG")) {
            OTGDimensionManager.unregisterDimension(dimId);
            dimensionMap.clear(dimId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OTGDimensionInfo GetOrderedDimensionData() {
        WorldServer world = DimensionManager.getWorld((int)0);
        File dimensionDataFile = new File(world.func_72860_G().func_75765_b() + "/OpenTerrainGenerator/Dimensions.txt");
        String[] dimensionDataFileValues = new String[]{};
        if (dimensionDataFile.exists()) {
            try {
                StringBuilder stringbuilder = new StringBuilder();
                try (BufferedReader reader = new BufferedReader(new FileReader(dimensionDataFile));){
                    String line = reader.readLine();
                    while (line != null) {
                        stringbuilder.append(line);
                        line = reader.readLine();
                    }
                    if (stringbuilder.length() > 0) {
                        dimensionDataFileValues = stringbuilder.toString().split(",");
                    }
                    OTG.log(LogMarker.TRACE, "Custom dimension data loaded", new Object[0]);
                }
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        ArrayList<DimensionData> dimensionData = new ArrayList<DimensionData>();
        if (dimensionDataFileValues.length > 0) {
            for (int i = 0; i < dimensionDataFileValues.length; i += 5) {
                DimensionData dimData = new DimensionData();
                dimData.dimensionId = Integer.parseInt(dimensionDataFileValues[i]);
                dimData.dimensionName = dimensionDataFileValues[i + 1];
                dimData.keepLoaded = Boolean.parseBoolean(dimensionDataFileValues[i + 2]);
                dimData.seed = Long.parseLong(dimensionDataFileValues[i + 3]);
                dimData.dimensionOrder = Integer.parseInt(dimensionDataFileValues[i + 4]);
                dimensionData.add(dimData);
            }
        }
        dimensionsOrder = new HashMap();
        dimensionsOrder.put(0, 0);
        HashMap<Integer, DimensionData> orderedDimensions = new HashMap<Integer, DimensionData>();
        int highestOrder = 0;
        for (DimensionData dimData : dimensionData) {
            dimensionsOrder.put(dimData.dimensionId, dimData.dimensionOrder);
            orderedDimensions.put(dimData.dimensionOrder, dimData);
            if (dimData.dimensionOrder <= highestOrder) continue;
            highestOrder = dimData.dimensionOrder;
        }
        return new OTGDimensionInfo(highestOrder, orderedDimensions);
    }

    public static void LoadCustomDimensionData() {
        OTGDimensionInfo otgDimData = OTGDimensionManager.GetOrderedDimensionData();
        for (int i = 0; i <= otgDimData.highestOrder; ++i) {
            if (!otgDimData.orderedDimensions.containsKey(i)) continue;
            DimensionData dimData = otgDimData.orderedDimensions.get(i);
            if (DimensionManager.isDimensionRegistered((int)dimData.dimensionId)) continue;
            OTGDimensionManager.registerDimension(dimData.dimensionId, DimensionType.register((String)dimData.dimensionName, (String)"OTG", (int)dimData.dimensionId, WorldProviderOTG.class, (boolean)dimData.keepLoaded));
            if (dimData.dimensionName.equals("DIM-Cartographer")) {
                Cartographer.CartographerDimension = dimData.dimensionId;
            }
            DimensionManager.initDimension((int)dimData.dimensionId);
        }
    }

    public static void RemoveOTGDims() {
        Hashtable dimensions = null;
        try {
            Field[] fields;
            for (Field field : fields = DimensionManager.class.getDeclaredFields()) {
                Object value;
                Class<?> fieldClass = field.getType();
                if (!fieldClass.equals(Hashtable.class)) continue;
                field.setAccessible(true);
                Hashtable fieldAsHashTable = (Hashtable)field.get(new DimensionManager());
                if (fieldAsHashTable.values().size() <= 0 || !((value = fieldAsHashTable.values().toArray()[0]) instanceof DimensionType) && value instanceof WorldServer) continue;
                dimensions = fieldAsHashTable;
                break;
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        oldDims = new Hashtable();
        for (int i = 2; i < 1024; ++i) {
            DimensionType type;
            if (!DimensionManager.isDimensionRegistered((int)i) || (type = DimensionManager.getProviderType((int)i)).func_186067_c() == null || !type.func_186067_c().equals("OTG")) continue;
            oldDims.put(i, dimensions.get(i));
            dimensions.remove(i);
        }
    }

    public static HashMap<Integer, String> GetAllOTGDimensions() {
        HashMap<Integer, String> otgDims = new HashMap<Integer, String>();
        for (int i = 0; i < 1024; ++i) {
            DimensionType type;
            if (i == 1 || !DimensionManager.isDimensionRegistered((int)i) || (type = DimensionManager.getProviderType((int)i)).func_186067_c() == null || !type.func_186067_c().equals("OTG")) continue;
            otgDims.put(new Integer(type.func_186068_a()), type.func_186065_b());
        }
        return otgDims;
    }

    public static void ReAddOTGDims() {
        Hashtable dimensions = null;
        try {
            Field[] fields;
            for (Field field : fields = DimensionManager.class.getDeclaredFields()) {
                Object value;
                Class<?> fieldClass = field.getType();
                if (!fieldClass.equals(Hashtable.class)) continue;
                field.setAccessible(true);
                Hashtable fieldAsHashTable = (Hashtable)field.get(new DimensionManager());
                if (fieldAsHashTable.values().size() <= 0 || !((value = fieldAsHashTable.values().toArray()[0]) instanceof DimensionType) && value instanceof WorldServer) continue;
                dimensions = fieldAsHashTable;
                break;
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        for (Map.Entry<Integer, Object> oldDim : oldDims.entrySet()) {
            dimensions.put(oldDim.getKey(), oldDim.getValue());
        }
        oldDims = new Hashtable();
    }
}

