/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge;

import com.pg85.otg.BiomeIds;
import com.pg85.otg.LocalBiome;
import com.pg85.otg.LocalMaterialData;
import com.pg85.otg.LocalWorld;
import com.pg85.otg.OTG;
import com.pg85.otg.WorldSession;
import com.pg85.otg.configuration.BiomeConfig;
import com.pg85.otg.configuration.BiomeConfigFinder;
import com.pg85.otg.configuration.BiomeLoadInstruction;
import com.pg85.otg.configuration.ClientConfigProvider;
import com.pg85.otg.configuration.ConfigProvider;
import com.pg85.otg.configuration.ServerConfigProvider;
import com.pg85.otg.configuration.WorldConfig;
import com.pg85.otg.configuration.standard.MojangSettings;
import com.pg85.otg.customobjects.CustomObjectStructureCache;
import com.pg85.otg.customobjects.bo3.BlockFunction;
import com.pg85.otg.customobjects.bo3.EntityFunction;
import com.pg85.otg.exception.BiomeNotFoundException;
import com.pg85.otg.forge.ForgeBiome;
import com.pg85.otg.forge.ForgeEngine;
import com.pg85.otg.forge.ForgeMaterialData;
import com.pg85.otg.forge.ForgeMojangSettings;
import com.pg85.otg.forge.ForgeWorldSession;
import com.pg85.otg.forge.OTGWorldServerMulti;
import com.pg85.otg.forge.dimensions.OTGDimensionManager;
import com.pg85.otg.forge.generator.OTGBiome;
import com.pg85.otg.forge.generator.OTGChunkGenerator;
import com.pg85.otg.forge.generator.structure.MojangStructurePart;
import com.pg85.otg.forge.generator.structure.OTGMineshaftGen;
import com.pg85.otg.forge.generator.structure.OTGNetherFortressGen;
import com.pg85.otg.forge.generator.structure.OTGOceanMonumentGen;
import com.pg85.otg.forge.generator.structure.OTGRareBuildingGen;
import com.pg85.otg.forge.generator.structure.OTGStrongholdGen;
import com.pg85.otg.forge.generator.structure.OTGVillageGen;
import com.pg85.otg.forge.generator.structure.OTGWoodLandMansionGen;
import com.pg85.otg.forge.util.IOHelper;
import com.pg85.otg.forge.util.MobSpawnGroupHelper;
import com.pg85.otg.forge.util.NBTHelper;
import com.pg85.otg.generator.ObjectSpawner;
import com.pg85.otg.generator.SpawnableObject;
import com.pg85.otg.generator.biome.BiomeGenerator;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.NamedBinaryTag;
import com.pg85.otg.util.helpers.StringHelper;
import com.pg85.otg.util.minecraftTypes.DefaultBiome;
import com.pg85.otg.util.minecraftTypes.TreeType;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.DataFixesManager;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenBigMushroom;
import net.minecraft.world.gen.feature.WorldGenBigTree;
import net.minecraft.world.gen.feature.WorldGenBirchTree;
import net.minecraft.world.gen.feature.WorldGenCanopyTree;
import net.minecraft.world.gen.feature.WorldGenDungeons;
import net.minecraft.world.gen.feature.WorldGenFossils;
import net.minecraft.world.gen.feature.WorldGenMegaJungle;
import net.minecraft.world.gen.feature.WorldGenMegaPineTree;
import net.minecraft.world.gen.feature.WorldGenSavannaTree;
import net.minecraft.world.gen.feature.WorldGenShrub;
import net.minecraft.world.gen.feature.WorldGenSwamp;
import net.minecraft.world.gen.feature.WorldGenTaiga1;
import net.minecraft.world.gen.feature.WorldGenTaiga2;
import net.minecraft.world.gen.feature.WorldGenTrees;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraft.world.storage.DerivedWorldInfo;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ForgeWorld
implements LocalWorld {
    public int clientDimensionId = 0;
    private OTGChunkGenerator generator;
    public World world;
    private ConfigProvider settings;
    private CustomObjectStructureCache structureCache;
    private String name;
    public long seed;
    private BiomeGenerator biomeGenerator;
    private DataFixer dataFixer;
    private static final int MAX_BIOMES_COUNT = 1024;
    private static final int MAX_SAVED_BIOMES_COUNT = 255;
    private static final int STANDARD_WORLD_HEIGHT = 128;
    public HashMap<String, LocalBiome> biomeNames = new HashMap();
    public OTGStrongholdGen strongholdGen;
    public OTGVillageGen villageGen;
    public OTGMineshaftGen mineshaftGen;
    public OTGRareBuildingGen rareBuildingGen;
    public OTGNetherFortressGen netherFortressGen;
    public OTGOceanMonumentGen oceanMonumentGen;
    public OTGWoodLandMansionGen woodLandMansionGen;
    private WorldGenDungeons dungeonGen;
    private WorldGenFossils fossilGen;
    private WorldGenTrees tree;
    private WorldGenSavannaTree acaciaTree;
    private WorldGenBigTree bigTree;
    private WorldGenBirchTree birchTree;
    private WorldGenTrees cocoaTree;
    private WorldGenCanopyTree darkOakTree;
    private WorldGenShrub groundBush;
    private WorldGenBigMushroom hugeRedMushroom;
    private WorldGenBigMushroom hugeBrownMushroom;
    private WorldGenMegaPineTree hugeTaigaTree1;
    private WorldGenMegaPineTree hugeTaigaTree2;
    private WorldGenMegaJungle jungleTree;
    private WorldGenBirchTree longBirchTree;
    private WorldGenSwamp swampTree;
    private WorldGenTaiga1 taigaTree1;
    private WorldGenTaiga2 taigaTree2;
    public static HashMap<Integer, ResourceLocation> vanillaResouceLocations = new HashMap();
    public static Biome[] vanillaBiomes = new Biome[1024];
    public static boolean vanillaBiomesCached = false;
    public boolean isMainWorld = false;
    boolean allowSpawningOutsideBounds = false;
    public Map<ChunkCoordinate, Chunk> chunkCacheOTGPlus = new HashMap<ChunkCoordinate, Chunk>();
    public Chunk lastUsedChunk;
    public int lastUsedChunkX;
    public int lastUsedChunkZ;
    ForgeWorldSession WorldSession;

    public ForgeWorld() {
    }

    public ForgeWorld(String _name, boolean isMainWorld) {
        OTG.log(LogMarker.INFO, "Creating world \"" + _name + "\"", new Object[0]);
        this.name = _name;
        this.isMainWorld = isMainWorld;
        this.cacheVanillaBiomes();
        if (isMainWorld) {
            OTGDimensionManager.UnloadAllCustomDimensionData();
            ((ForgeEngine)OTG.getEngine()).worldLoader.unloadAllWorlds();
            ((ForgeEngine)OTG.getEngine()).worldLoader.clearBiomeDictionary(null);
            ((ForgeEngine)OTG.getEngine()).worldLoader.unRegisterDefaultBiomes();
            ((ForgeEngine)OTG.getEngine()).worldLoader.unRegisterTCBiomes();
            OTGDimensionManager.RemoveOTGDims();
        }
    }

    @Override
    public LocalBiome createBiomeFor(BiomeConfig biomeConfig, BiomeIds biomeIds, ConfigProvider configProvider) {
        ForgeBiome forgeBiome;
        LocalBiome existingBiome;
        if (!this.isMainWorld && (existingBiome = OTG.getBiomeAllWorlds(biomeConfig.getName())) != null && existingBiome.getBiomeConfig() != null) {
            biomeConfig = existingBiome.getBiomeConfig();
        }
        if (biomeConfig.getName().equals("Hell")) {
            forgeBiome = new ForgeBiome(Biomes.field_76778_j, biomeConfig, new BiomeIds(8, 8));
            this.biomeNames.put("Hell", forgeBiome);
            return forgeBiome;
        }
        if (biomeConfig.getName().equals("Sky")) {
            forgeBiome = new ForgeBiome(Biomes.field_76779_k, biomeConfig, new BiomeIds(9, 9));
            this.biomeNames.put("Sky", forgeBiome);
            return forgeBiome;
        }
        if (biomeConfig.getName().equals("The Void")) {
            forgeBiome = new ForgeBiome(Biomes.field_185440_P, biomeConfig, new BiomeIds(127, 127));
            this.biomeNames.put("The Void", forgeBiome);
            return forgeBiome;
        }
        forgeBiome = (ForgeBiome)OTG.getBiomeAllWorlds(biomeConfig.getName());
        Biome biome = OTGBiome.getOrCreateBiome(biomeConfig, biomeIds, this.isMainWorld);
        if (forgeBiome == null) {
            Biome existingBiome2 = Biome.func_150568_d((int)biomeIds.getSavedId());
            if (biomeIds.getSavedId() >= 256 || biomeIds.getSavedId() < 0) {
                throw new RuntimeException("Could not allocate the requested id " + biomeIds.getGenerationId() + " for biome " + biomeConfig.getName() + ". All available id's under 256 have been allocated\n. To proceed, adjust your WorldConfig or use the ReplaceToBiomeName feature to make the biome virtual.");
            }
            forgeBiome = new ForgeBiome(biome, biomeConfig, biomeIds);
            this.registerBiomeInBiomeDictionary(biome, existingBiome2, biomeConfig, configProvider);
        }
        this.biomeNames.put(biome.field_76791_y, forgeBiome);
        return forgeBiome;
    }

    private void registerBiomeInBiomeDictionary(Biome biome, Biome sourceBiome, BiomeConfig biomeConfig, ConfigProvider configProvider) {
        ArrayList<Object> types = new ArrayList();
        if (biomeConfig.replaceToBiomeName != null && biomeConfig.replaceToBiomeName.length() > 0) {
            LocalBiome replaceToBiome = configProvider.getBiomeByIdOrNull(((ForgeEngine)OTG.getEngine()).getBiomeRegistryId(sourceBiome != null ? sourceBiome : biome));
            if (replaceToBiome == null) {
                int replaceToBiomeId = ((ForgeEngine)OTG.getEngine()).getBiomeRegistryId(sourceBiome != null ? sourceBiome : biome);
                replaceToBiome = OTG.getBiomeAllWorlds(replaceToBiomeId);
            }
            if (replaceToBiome != null && replaceToBiome.getBiomeConfig().biomeDictId != null) {
                types = this.getTypesList(replaceToBiome.getBiomeConfig().biomeDictId.split(","));
            }
        } else if (biomeConfig.biomeDictId != null && biomeConfig.biomeDictId.trim().length() > 0) {
            types = this.getTypesList(biomeConfig.biomeDictId.split(","));
        }
        BiomeDictionary.Type[] typeArr = new BiomeDictionary.Type[types.size()];
        types.toArray(typeArr);
        if (!ForgeRegistries.BIOMES.containsValue((IForgeRegistryEntry)biome)) {
            OTG.log(LogMarker.WARN, "Biome " + biome.field_76791_y + " could not be found in the registry. This could be because it is a virtual biome (id > 255) but does not have a ReplaceToBiomeName configured.", new Object[0]);
        }
        BiomeDictionary.addTypes((Biome)biome, (BiomeDictionary.Type[])typeArr);
    }

    private ArrayList<BiomeDictionary.Type> getTypesList(String[] typearr) {
        ArrayList<BiomeDictionary.Type> types = new ArrayList<BiomeDictionary.Type>();
        for (String typeString : typearr) {
            if (typeString == null || typeString.trim().length() <= 0) continue;
            BiomeDictionary.Type type = null;
            typeString = typeString.trim();
            try {
                type = BiomeDictionary.Type.getType((String)typeString, null);
            }
            catch (Exception ex) {
                OTG.log(LogMarker.WARN, "Can't find BiomeDictId: \"" + typeString + "\".", new Object[0]);
            }
            if (type == null) continue;
            types.add(type);
        }
        return types;
    }

    @Override
    public int getMaxBiomesCount() {
        return 1024;
    }

    @Override
    public int getMaxSavedBiomesCount() {
        return 255;
    }

    @Override
    public int getFreeBiomeId() {
        throw new RuntimeException("Whatever it is you're trying to do, we didn't write any code for it (sorry). Please contact Team OTG about this crash.");
    }

    @Override
    public ArrayList<LocalBiome> getAllBiomes() {
        ArrayList<LocalBiome> biomes = new ArrayList<LocalBiome>();
        for (LocalBiome biome : this.settings.getBiomeArray()) {
            biomes.add(biome);
        }
        return biomes;
    }

    @Override
    public ForgeBiome getBiomeById(int id) throws BiomeNotFoundException {
        throw new RuntimeException("Whatever it is you're trying to do, we didn't write any code for it (sorry). Please contact Team OTG about this crash.");
    }

    @Override
    public ForgeBiome getBiomeByIdOrNull(int id) {
        return (ForgeBiome)this.settings.getBiomeByIdOrNull(id);
    }

    @Override
    public LocalBiome getBiomeByNameOrNull(String name) {
        return this.biomeNames.get(name);
    }

    public Collection<BiomeLoadInstruction> getDefaultBiomes() {
        ArrayList<BiomeLoadInstruction> standardBiomes = new ArrayList<BiomeLoadInstruction>();
        for (DefaultBiome defaultBiome : DefaultBiome.values()) {
            int id = defaultBiome.Id;
            BiomeLoadInstruction instruction = defaultBiome.getLoadInstructions(ForgeMojangSettings.fromId(id), 128);
            standardBiomes.add(instruction);
        }
        return standardBiomes;
    }

    @Override
    public void prepareDefaultStructures(int chunkX, int chunkZ, boolean dry) {
        WorldConfig worldConfig = this.settings.getWorldConfig();
        if (worldConfig.strongholdsEnabled) {
            this.strongholdGen.func_186125_a(this.world, chunkX, chunkZ, null);
        }
        if (worldConfig.mineshaftsEnabled) {
            this.mineshaftGen.func_186125_a(this.world, chunkX, chunkZ, null);
        }
        if (worldConfig.villagesEnabled && dry) {
            this.villageGen.func_186125_a(this.world, chunkX, chunkZ, null);
        }
        if (worldConfig.rareBuildingsEnabled) {
            this.rareBuildingGen.func_186125_a(this.world, chunkX, chunkZ, null);
        }
        if (worldConfig.netherFortressesEnabled) {
            this.netherFortressGen.func_186125_a(this.world, chunkX, chunkZ, null);
        }
        if (worldConfig.oceanMonumentsEnabled) {
            this.oceanMonumentGen.func_186125_a(this.world, chunkX, chunkZ, null);
        }
        if (worldConfig.woodLandMansionsEnabled) {
            this.woodLandMansionGen.func_186125_a(this.world, chunkX, chunkZ, null);
        }
    }

    @Override
    public boolean placeDungeon(Random rand, int x, int y, int z) {
        return this.dungeonGen.func_180709_b(this.world, rand, new BlockPos(x, y, z));
    }

    @Override
    public boolean placeFossil(Random rand, ChunkCoordinate chunkCoord) {
        return this.fossilGen.func_180709_b(this.world, rand, new BlockPos(chunkCoord.getBlockX(), 0, chunkCoord.getBlockZ()));
    }

    @Override
    public boolean placeTree(TreeType type, Random rand, int x, int y, int z) {
        BlockPos blockPos = new BlockPos(x, y, z);
        switch (type) {
            case Tree: {
                return this.tree.func_180709_b(this.world, rand, blockPos);
            }
            case BigTree: {
                return this.bigTree.func_180709_b(this.world, rand, blockPos);
            }
            case Forest: 
            case Birch: {
                return this.birchTree.func_180709_b(this.world, rand, blockPos);
            }
            case TallBirch: {
                return this.longBirchTree.func_180709_b(this.world, rand, blockPos);
            }
            case HugeMushroom: {
                if (rand.nextBoolean()) {
                    return this.hugeBrownMushroom.func_180709_b(this.world, rand, blockPos);
                }
                return this.hugeRedMushroom.func_180709_b(this.world, rand, blockPos);
            }
            case HugeRedMushroom: {
                return this.hugeRedMushroom.func_180709_b(this.world, rand, blockPos);
            }
            case HugeBrownMushroom: {
                return this.hugeBrownMushroom.func_180709_b(this.world, rand, blockPos);
            }
            case SwampTree: {
                return this.swampTree.func_180709_b(this.world, rand, blockPos);
            }
            case Taiga1: {
                return this.taigaTree1.func_180709_b(this.world, rand, blockPos);
            }
            case Taiga2: {
                return this.taigaTree2.func_180709_b(this.world, rand, blockPos);
            }
            case JungleTree: {
                return this.jungleTree.func_180709_b(this.world, rand, blockPos);
            }
            case GroundBush: {
                return this.groundBush.func_180709_b(this.world, rand, blockPos);
            }
            case CocoaTree: {
                return this.cocoaTree.func_180709_b(this.world, rand, blockPos);
            }
            case Acacia: {
                return this.acaciaTree.func_180709_b(this.world, rand, blockPos);
            }
            case DarkOak: {
                return this.darkOakTree.func_180709_b(this.world, rand, blockPos);
            }
            case HugeTaiga1: {
                return this.hugeTaigaTree1.func_180709_b(this.world, rand, blockPos);
            }
            case HugeTaiga2: {
                return this.hugeTaigaTree2.func_180709_b(this.world, rand, blockPos);
            }
        }
        throw new RuntimeException("Failed to handle tree of type " + type.toString());
    }

    @Override
    public boolean placeDefaultStructures(Random rand, ChunkCoordinate chunkCoord) {
        ChunkPos chunkCoordIntPair = new ChunkPos(chunkCoord.getChunkX(), chunkCoord.getChunkZ());
        WorldConfig worldConfig = this.settings.getWorldConfig();
        boolean isVillagePlaced = false;
        if (worldConfig.strongholdsEnabled) {
            this.strongholdGen.func_175794_a(this.world, rand, chunkCoordIntPair);
        }
        if (worldConfig.mineshaftsEnabled) {
            this.mineshaftGen.func_175794_a(this.world, rand, chunkCoordIntPair);
        }
        if (worldConfig.villagesEnabled) {
            isVillagePlaced = this.villageGen.func_175794_a(this.world, rand, chunkCoordIntPair);
        }
        if (worldConfig.rareBuildingsEnabled) {
            this.rareBuildingGen.func_175794_a(this.world, rand, chunkCoordIntPair);
        }
        if (worldConfig.netherFortressesEnabled) {
            this.netherFortressGen.func_175794_a(this.world, rand, chunkCoordIntPair);
        }
        if (worldConfig.oceanMonumentsEnabled) {
            this.oceanMonumentGen.func_175794_a(this.world, rand, chunkCoordIntPair);
        }
        if (worldConfig.woodLandMansionsEnabled) {
            this.woodLandMansionGen.func_175794_a(this.world, rand, chunkCoordIntPair);
        }
        return isVillagePlaced;
    }

    @Override
    public void replaceBlocks(ChunkCoordinate chunkCoord) {
        if (!this.settings.getWorldConfig().BiomeConfigsHaveReplacement) {
            return;
        }
        this.replaceBlocks(this.getChunk(chunkCoord.getBlockX() + 16, chunkCoord.getBlockZ() + 16, false), 0, 0, 16);
        this.replaceBlocks(this.getChunk(chunkCoord.getBlockX(), chunkCoord.getBlockZ() + 16, false), 0, 0, 16);
        this.replaceBlocks(this.getChunk(chunkCoord.getBlockX() + 16, chunkCoord.getBlockZ(), false), 0, 0, 16);
        this.replaceBlocks(this.getChunk(chunkCoord.getBlockX(), chunkCoord.getBlockZ(), false), 0, 0, 16);
    }

    private void replaceBlocks(Chunk rawChunk, int startXInChunk, int startZInChunk, int size) {
        ExtendedBlockStorage[] sectionsArray;
        int endXInChunk = startXInChunk + size;
        int endZInChunk = startZInChunk + size;
        int worldStartX = rawChunk.field_76635_g * 16;
        int worldStartZ = rawChunk.field_76647_h * 16;
        for (ExtendedBlockStorage section : sectionsArray = rawChunk.func_76587_i()) {
            if (section == null) continue;
            for (int sectionX = startXInChunk; sectionX < endXInChunk; ++sectionX) {
                block2: for (int sectionZ = startZInChunk; sectionZ < endZInChunk; ++sectionZ) {
                    LocalBiome biome = this.getBiome(worldStartX + sectionX, worldStartZ + sectionZ);
                    if (biome == null || !biome.getBiomeConfig().replacedBlocks.hasReplaceSettings()) continue;
                    LocalMaterialData[][] replaceArray = biome.getBiomeConfig().replacedBlocks.compiledInstructions;
                    for (int sectionY = 0; sectionY < 16; ++sectionY) {
                        IBlockState block = section.func_186049_g().func_186016_a(sectionX, sectionY, sectionZ);
                        int blockId = Block.func_149682_b((Block)block.func_177230_c());
                        if (replaceArray[blockId] == null) continue;
                        int y = section.func_76662_d() + sectionY;
                        if (y >= replaceArray[blockId].length) continue block2;
                        ForgeMaterialData replaceTo = (ForgeMaterialData)replaceArray[blockId][y];
                        if (replaceTo == null || replaceTo.getBlockId() == blockId) continue;
                        section.func_177484_a(sectionX, sectionY, sectionZ, replaceTo.internalBlock());
                    }
                }
            }
        }
    }

    @Override
    public void placePopulationMobs(LocalBiome biome, Random random, ChunkCoordinate chunkCoord) {
        if (TerrainGen.populate((IChunkGenerator)this.getChunkGenerator(), (World)this.world, (Random)random, (int)chunkCoord.getChunkX(), (int)chunkCoord.getChunkZ(), (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ANIMALS)) {
            WorldEntitySpawner.func_77191_a((World)this.getWorld(), (Biome)((ForgeBiome)biome).getHandle(), (int)chunkCoord.getBlockXCenter(), (int)chunkCoord.getBlockZCenter(), (int)16, (int)16, (Random)random);
        }
    }

    @Override
    public void setAllowSpawningOutsideBounds(boolean allowSpawningOutsideBounds) {
        this.allowSpawningOutsideBounds = allowSpawningOutsideBounds;
    }

    public boolean getAllowSpawningOutsideBounds() {
        return this.allowSpawningOutsideBounds;
    }

    public Chunk getChunk(int x, int z, boolean isOTGPlus) {
        boolean outsidePopulatingArea;
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        if (this.lastUsedChunk != null && this.lastUsedChunkX == chunkX && this.lastUsedChunkZ == chunkZ) {
            return this.lastUsedChunk;
        }
        Chunk chunk = this.chunkCacheOTGPlus.get(ChunkCoordinate.fromChunkCoords(chunkX, chunkZ));
        if (chunk != null) {
            this.lastUsedChunk = chunk;
            this.lastUsedChunkX = chunkX;
            this.lastUsedChunkZ = chunkZ;
            return chunk;
        }
        boolean bl = outsidePopulatingArea = chunkX != this.getObjectSpawner().populatingX && chunkX != this.getObjectSpawner().populatingX + 1 || chunkZ != this.getObjectSpawner().populatingZ && chunkZ != this.getObjectSpawner().populatingZ + 1;
        if (outsidePopulatingArea && !isOTGPlus || this.allowSpawningOutsideBounds) {
            if (!isOTGPlus) {
                if (this.getConfigs().getWorldConfig().populationBoundsCheck) {
                    return null;
                }
                Chunk loadedChunk = this.getLoadedChunkWithoutMarkingActive(chunkX, chunkZ);
                if (loadedChunk != null) {
                    this.lastUsedChunk = loadedChunk;
                    this.lastUsedChunkX = chunkX;
                    this.lastUsedChunkZ = chunkZ;
                    this.chunkCacheOTGPlus.put(ChunkCoordinate.fromChunkCoords(chunkX, chunkZ), loadedChunk);
                }
                if (!this.allowSpawningOutsideBounds || loadedChunk != null) {
                    return loadedChunk;
                }
            }
            if (this.allowSpawningOutsideBounds) {
                Chunk spawnedChunk = this.world.func_72964_e(chunkX, chunkZ);
                if (spawnedChunk == null) {
                    OTG.log(LogMarker.INFO, "Chunk request failed X" + chunkX + " Z" + chunkZ, new Object[0]);
                    throw new RuntimeException();
                }
                this.chunkCacheOTGPlus.put(ChunkCoordinate.fromChunkCoords(chunkX, chunkZ), spawnedChunk);
                this.lastUsedChunk = spawnedChunk;
                this.lastUsedChunkX = chunkX;
                this.lastUsedChunkZ = chunkZ;
                return spawnedChunk;
            }
        }
        boolean outsideBorder = false;
        if (!this.IsInsideWorldBorder(ChunkCoordinate.fromChunkCoords(chunkX, chunkZ), true)) {
            outsideBorder = true;
        }
        if (!outsideBorder && outsidePopulatingArea && !((WorldServer)this.getWorld()).func_175667_e(new BlockPos(chunkX * 16, 1, chunkZ * 16))) {
            return null;
        }
        Chunk spawnedChunk = this.world.func_72964_e(chunkX, chunkZ);
        if (spawnedChunk == null) {
            OTG.log(LogMarker.INFO, "Chunk request failed X" + chunkX + " Z" + chunkZ, new Object[0]);
            throw new RuntimeException();
        }
        this.chunkCacheOTGPlus.put(ChunkCoordinate.fromChunkCoords(chunkX, chunkZ), spawnedChunk);
        this.lastUsedChunk = spawnedChunk;
        this.lastUsedChunkX = chunkX;
        this.lastUsedChunkZ = chunkZ;
        return spawnedChunk;
    }

    public void ClearChunkCache() {
        this.chunkCacheOTGPlus.clear();
        this.lastUsedChunk = null;
    }

    public Chunk getLoadedChunkWithoutMarkingActive(int chunkX, int chunkZ) {
        ChunkProviderServer chunkProviderServer = (ChunkProviderServer)this.world.func_72863_F();
        long i = ChunkPos.func_77272_a((int)chunkX, (int)chunkZ);
        return (Chunk)chunkProviderServer.field_73244_f.get(i);
    }

    @Override
    public int getLiquidHeight(int x, int z) {
        int highestY = this.getHighestBlockYAt(x, z, false, true, false, false);
        highestY = highestY > 0 ? ++highestY : -1;
        return highestY;
    }

    @Override
    public int getSolidHeight(int x, int z) {
        int highestY = this.getHighestBlockYAt(x, z, true, false, true, true);
        highestY = highestY > 0 ? ++highestY : -1;
        return highestY;
    }

    @Override
    public boolean isNullOrAir(int x, int y, int z, boolean isOTGPlus) {
        if (y >= 256 || y < 0) {
            return true;
        }
        Chunk chunk = this.getChunk(x, z, isOTGPlus);
        if (chunk == null) {
            return true;
        }
        return chunk.func_186032_a(x & 0xF, y, z & 0xF).func_185904_a().equals(Material.field_151579_a);
    }

    @Override
    public BlockFunction[] getBlockColumn(int x, int z) {
        return this.generator.getBlockColumnInUnloadedChunk(x, z);
    }

    @Override
    public LocalMaterialData getMaterial(int x, int y, int z, boolean IsOTGPlus) {
        if (y >= 256 || y < 0) {
            return ForgeMaterialData.ofMinecraftBlock(Blocks.field_150350_a);
        }
        Chunk chunk = this.getChunk(x, z, IsOTGPlus);
        if (chunk == null && !IsOTGPlus) {
            return ForgeMaterialData.ofMinecraftBlock(Blocks.field_150350_a);
        }
        if (chunk == null) {
            return this.generator.getMaterialInUnloadedChunk(x, y, z);
        }
        ForgeMaterialData material = ForgeMaterialData.ofMinecraftBlockState(chunk.func_186032_a(x &= 0xF, y, z &= 0xF));
        return material;
    }

    @Override
    public void setBlock(int x, int y, int z, LocalMaterialData material, NamedBinaryTag metaDataTag, boolean isOTGPlus) {
        if (y < 0 || y >= 256) {
            return;
        }
        IBlockState newState = ((ForgeMaterialData)material).internalBlock();
        BlockPos pos = new BlockPos(x, y, z);
        Chunk chunk = this.getChunk(x, z, isOTGPlus);
        if (chunk == null) {
            throw new RuntimeException("Whatever it is you're trying to do, we didn't write any code for it (sorry). Please contact Team OTG about this crash.");
        }
        IBlockState iblockstate = this.setBlockState(chunk, pos, newState);
        if (iblockstate == null) {
            return;
        }
        if (metaDataTag != null) {
            this.attachMetadata(x, y, z, metaDataTag, isOTGPlus);
        }
        this.world.markAndNotifyBlock(pos, chunk, iblockstate, newState, 18);
    }

    public IBlockState setBlockState(Chunk _this, BlockPos pos, IBlockState state) {
        TileEntity te;
        int k;
        int l;
        int i = pos.func_177958_n() & 0xF;
        int j = pos.func_177956_o();
        if (j >= _this.field_76638_b[l = (k = pos.func_177952_p() & 0xF) << 4 | i] - 1) {
            _this.field_76638_b[l] = -999;
        }
        int i1 = _this.func_177445_q()[l];
        IBlockState iblockstate = _this.func_177435_g(pos);
        if (iblockstate == state) {
            return null;
        }
        Block block = state.func_177230_c();
        Block block1 = iblockstate.func_177230_c();
        int k1 = iblockstate.getLightOpacity((IBlockAccess)_this.func_177412_p(), pos);
        ExtendedBlockStorage extendedblockstorage = _this.func_76587_i()[j >> 4];
        boolean flag = false;
        if (extendedblockstorage == Chunk.field_186036_a) {
            if (block == Blocks.field_150350_a) {
                return null;
            }
            _this.func_76587_i()[j >> 4] = extendedblockstorage = new ExtendedBlockStorage(j >> 4 << 4, _this.func_177412_p().field_73011_w.func_191066_m());
            flag = j >= i1;
        }
        extendedblockstorage.func_177484_a(i, j & 0xF, k, state);
        if (!_this.func_177412_p().field_72995_K) {
            if (block1 != block) {
                block1.func_180663_b(_this.func_177412_p(), pos, iblockstate);
            }
            if ((te = _this.func_177424_a(pos, Chunk.EnumCreateEntityType.CHECK)) != null && te.shouldRefresh(_this.func_177412_p(), pos, iblockstate, state)) {
                _this.func_177412_p().func_175713_t(pos);
            }
        } else if (block1.hasTileEntity(iblockstate) && (te = _this.func_177424_a(pos, Chunk.EnumCreateEntityType.CHECK)) != null && te.shouldRefresh(_this.func_177412_p(), pos, iblockstate, state)) {
            _this.func_177412_p().func_175713_t(pos);
        }
        if (extendedblockstorage.func_177485_a(i, j & 0xF, k).func_177230_c() != block) {
            return null;
        }
        if (flag) {
            _this.func_76603_b();
        } else {
            int j1 = state.getLightOpacity((IBlockAccess)_this.func_177412_p(), pos);
            if (j1 > 0) {
                if (j >= i1) {
                    _this.func_76615_h(i, j + 1, k);
                }
            } else if (j == i1 - 1) {
                _this.func_76615_h(i, j, k);
            }
            if (j1 != k1 && (j1 < k1 || _this.func_177413_a(EnumSkyBlock.SKY, pos) > 0 || _this.func_177413_a(EnumSkyBlock.BLOCK, pos) > 0)) {
                _this.func_76595_e(i, k);
            }
        }
        if (block.hasTileEntity(state)) {
            TileEntity tileentity1 = _this.func_177424_a(pos, Chunk.EnumCreateEntityType.CHECK);
            if (tileentity1 == null) {
                tileentity1 = block.createTileEntity(_this.func_177412_p(), state);
                _this.func_177412_p().func_175690_a(pos, tileentity1);
            }
            if (tileentity1 != null) {
                tileentity1.func_145836_u();
            }
        }
        _this.func_76630_e();
        return iblockstate;
    }

    @Override
    public int getHighestBlockYAt(int x, int z) {
        int y;
        Chunk chunk = this.getChunk(x, z, false);
        if (chunk == null) {
            return -1;
        }
        boolean incorrectHeightMap = false;
        for (y = chunk.func_76611_b(x & 0xF, z & 0xF); y < this.getHeightCap() && chunk.func_186032_a(x, y, z).func_185904_a().func_76228_b(); ++y) {
            incorrectHeightMap = true;
        }
        if (incorrectHeightMap) {
            this.world.func_175664_x(new BlockPos(x, y, z));
        }
        return y;
    }

    @Override
    public int getHighestBlockYAt(int x, int z, boolean findSolid, boolean findLiquid, boolean ignoreLiquid, boolean ignoreSnow) {
        Chunk chunk = this.getChunk(x, z, true);
        if (chunk == null) {
            int y = this.generator.getHighestBlockYInUnloadedChunk(x, z, findSolid, findLiquid, ignoreLiquid, ignoreSnow);
            return y;
        }
        z &= 0xF;
        x &= 0xF;
        for (int i = 255; i > -1; --i) {
            boolean isSolid;
            ForgeMaterialData material = ForgeMaterialData.ofMinecraftBlockState(chunk.func_186032_a(x, i, z));
            if (material == null) {
                throw new RuntimeException();
            }
            boolean isLiquid = material.isLiquid();
            boolean bl = isSolid = material.isSolid() && !material.equals(Material.field_151584_j) || !ignoreSnow && material.equals(Material.field_151597_y);
            if (isLiquid && ignoreLiquid) continue;
            if (findSolid && isSolid || findLiquid && isLiquid) {
                return i;
            }
            if ((!findSolid || !isLiquid) && (!findLiquid || !isSolid)) continue;
            return -1;
        }
        return -1;
    }

    @Override
    public void startPopulation(ChunkCoordinate chunkCoord) {
    }

    @Override
    public void endPopulation() {
    }

    @Override
    public int getLightLevel(int x, int y, int z) {
        return this.world.func_175699_k(new BlockPos(x, y, z));
    }

    @Override
    public boolean isLoaded(int x, int y, int z) {
        return this.getChunk(x, z, false) != null;
    }

    @Override
    public ConfigProvider getConfigs() {
        return this.settings;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getWorldSettingsName() {
        return this.getWorld().func_72912_H().func_76065_j();
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    @Override
    public int getHeightCap() {
        return this.settings.getWorldConfig().worldHeightCap;
    }

    @Override
    public int getHeightScale() {
        return this.settings.getWorldConfig().worldHeightScale;
    }

    public OTGChunkGenerator getChunkGenerator() {
        return this.generator;
    }

    @SideOnly(value=Side.CLIENT)
    public void provideClientConfigsBukkit(WorldClient world, ClientConfigProvider config) {
        this.settings = config;
        this.world = world;
        this.seed = world.func_72905_C();
    }

    @SideOnly(value=Side.CLIENT)
    public void provideClientConfigs(ClientConfigProvider config) {
        this.settings = config;
    }

    @SideOnly(value=Side.CLIENT)
    public void provideClientWorld(World world) {
        this.world = world;
        this.seed = world.func_72905_C();
    }

    public void provideConfigs(ServerConfigProvider configs) {
        this.settings = configs;
    }

    public void provideWorldInstance(WorldServer world) {
        ServerConfigProvider configs = (ServerConfigProvider)this.settings;
        if (!this.isMainWorld && !(world instanceof OTGWorldServerMulti)) {
            long seedIn = (long)Math.floor(Math.random() * 9.223372036854776E18);
            if (configs.getWorldConfig().worldSeed != null && configs.getWorldConfig().worldSeed.trim().length() > 0) {
                try {
                    seedIn = configs.getWorldConfig().worldSeed == null || configs.getWorldConfig().worldSeed.trim().length() == 0 ? (long)Math.floor(Math.random() * 9.223372036854776E18) : Long.parseLong(configs.getWorldConfig().worldSeed);
                }
                catch (NumberFormatException ex) {
                    OTG.log(LogMarker.ERROR, "WorldConfig for world \"" + world.func_72912_H().func_76065_j() + "\" has value \"" + configs.getWorldConfig().worldSeed + "\" for worldSeed which cannot be parsed as a number. Using a random seed instead.", new Object[0]);
                }
            }
            GameType gameType = world.func_72912_H().func_76077_q();
            boolean enableMapFeatures = world.func_72912_H().func_76089_r();
            boolean hardcoreMode = world.func_72912_H().func_76093_s();
            WorldType worldTypeIn = world.func_175624_G();
            String generatorOptions = world.func_72912_H() instanceof DerivedWorldInfo ? ((DerivedWorldInfo)world.func_72912_H()).field_76115_a.func_82571_y() : world.func_72912_H().func_82571_y();
            boolean enableCommands = world.func_72912_H().func_76086_u();
            WorldSettings settings = new WorldSettings(seedIn, gameType, enableMapFeatures, hardcoreMode, worldTypeIn);
            settings.func_82750_a(generatorOptions);
            if (enableCommands) {
                settings.func_77166_b();
            }
            WorldInfo worldInfo = new WorldInfo(settings, world.func_72912_H().func_76065_j());
            try {
                Field[] fields;
                for (Field field : fields = World.class.getDeclaredFields()) {
                    Class<?> fieldClass = field.getType();
                    if (!fieldClass.equals(WorldInfo.class)) continue;
                    field.setAccessible(true);
                    field.set(world, worldInfo);
                    break;
                }
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        this.world = world;
        this.seed = world.func_72912_H().func_76063_b();
        world.func_181544_b(configs.getWorldConfig().waterLevelMax);
        this.dataFixer = DataFixesManager.func_188279_a();
        this.dungeonGen = new WorldGenDungeons();
        this.fossilGen = new WorldGenFossils();
        this.strongholdGen = new OTGStrongholdGen(configs, world);
        this.villageGen = new OTGVillageGen(configs);
        this.mineshaftGen = new OTGMineshaftGen();
        this.rareBuildingGen = new OTGRareBuildingGen(configs);
        this.netherFortressGen = new OTGNetherFortressGen();
        this.oceanMonumentGen = new OTGOceanMonumentGen(configs);
        this.woodLandMansionGen = new OTGWoodLandMansionGen(configs);
        IBlockState jungleLog = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.JUNGLE);
        IBlockState jungleLeaves = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.JUNGLE).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
        this.tree = new WorldGenTrees(false);
        this.acaciaTree = new WorldGenSavannaTree(false);
        this.cocoaTree = new WorldGenTrees(false, 5, jungleLog, jungleLeaves, true);
        this.bigTree = new WorldGenBigTree(false);
        this.birchTree = new WorldGenBirchTree(false, false);
        this.darkOakTree = new WorldGenCanopyTree(false);
        this.longBirchTree = new WorldGenBirchTree(false, true);
        this.swampTree = new WorldGenSwamp();
        this.taigaTree1 = new WorldGenTaiga1();
        this.taigaTree2 = new WorldGenTaiga2(false);
        this.hugeRedMushroom = new WorldGenBigMushroom(Blocks.field_150419_aX);
        this.hugeBrownMushroom = new WorldGenBigMushroom(Blocks.field_150420_aW);
        this.hugeTaigaTree1 = new WorldGenMegaPineTree(false, false);
        this.hugeTaigaTree2 = new WorldGenMegaPineTree(false, true);
        this.jungleTree = new WorldGenMegaJungle(false, 10, 20, jungleLog, jungleLeaves);
        this.groundBush = new WorldGenShrub(jungleLog, jungleLeaves);
        this.WorldSession = new ForgeWorldSession(this);
        this.generator = new OTGChunkGenerator(this);
        this.structureCache = new CustomObjectStructureCache(this);
    }

    public void setBiomeGenerator(BiomeGenerator generator) {
        this.biomeGenerator = generator;
    }

    public World getWorld() {
        return this.world;
    }

    @Override
    public LocalBiome getCalculatedBiome(int x, int z) {
        return OTG.isForge ? OTG.getBiomeAllWorlds(this.biomeGenerator.getBiome(x, z)) : this.getBiomeById(this.biomeGenerator.getBiome(x, z));
    }

    @Override
    public LocalBiome getBiome(int x, int z) {
        if (this.settings.getWorldConfig().populateUsingSavedBiomes) {
            return this.getSavedBiome(x, z);
        }
        return this.getCalculatedBiome(x, z);
    }

    @Override
    public LocalBiome getSavedBiome(int x, int z) throws BiomeNotFoundException {
        BlockPos pos = new BlockPos(x, 0, z);
        Biome biome = this.world.func_180494_b(pos);
        int biomeId = biome instanceof OTGBiome ? ((OTGBiome)biome).generationId : ((ForgeEngine)OTG.getEngine()).getBiomeRegistryId(biome);
        ForgeBiome forgeBiome = (ForgeBiome)OTG.getBiomeAllWorlds(biomeId);
        return forgeBiome;
    }

    void attachMetadata(int x, int y, int z, NamedBinaryTag tag, boolean allowOutsidePopulatingArea) {
        NBTTagCompound nmsTag = NBTHelper.getNMSFromNBTTagCompound(tag);
        nmsTag.func_74768_a("x", x);
        nmsTag.func_74768_a("y", y);
        nmsTag.func_74768_a("z", z);
        nmsTag = this.dataFixer.func_188257_a((IFixType)FixTypes.BLOCK_ENTITY, nmsTag);
        TileEntity tileEntity = this.world.func_175625_s(new BlockPos(x, y, z));
        if (tileEntity != null) {
            tileEntity.func_145839_a(nmsTag);
        } else {
            OTG.log(LogMarker.DEBUG, "Skipping tile entity with id {}, cannot be placed at {},{},{} on id {}", nmsTag.func_74779_i("id"), x, y, z, this.getMaterial(x, y, z, allowOutsidePopulatingArea));
        }
    }

    @Override
    public NamedBinaryTag getMetadata(int x, int y, int z) {
        TileEntity tileEntity = this.world.func_175625_s(new BlockPos(x, y, z));
        if (tileEntity == null) {
            return null;
        }
        NBTTagCompound nmsTag = new NBTTagCompound();
        tileEntity.func_189515_b(nmsTag);
        nmsTag.func_82580_o("x");
        nmsTag.func_82580_o("y");
        nmsTag.func_82580_o("z");
        return NBTHelper.getNBTFromNMSTagCompound(null, nmsTag);
    }

    @Override
    public CustomObjectStructureCache getStructureCache() {
        return this.structureCache;
    }

    @Override
    public ObjectSpawner getObjectSpawner() {
        return this.generator.spawner;
    }

    @Override
    public BiomeGenerator getBiomeGenerator() {
        return this.biomeGenerator;
    }

    @Override
    public SpawnableObject getMojangStructurePart(String name) {
        ResourceLocation resourceLocation = new ResourceLocation(name);
        TemplateManager mojangStructureParts = this.world.func_72860_G().func_186340_h();
        Template mojangStructurePart = mojangStructureParts.func_186237_a(this.world.func_73046_m(), resourceLocation);
        if (mojangStructurePart == null) {
            return null;
        }
        return new MojangStructurePart(name, mojangStructurePart);
    }

    private void cacheVanillaBiomes() {
        if (!vanillaBiomesCached) {
            block0: for (DefaultBiome defaultBiome : DefaultBiome.values()) {
                Biome oldBiome;
                int biomeId = defaultBiome.Id;
                ForgeWorld.vanillaBiomes[biomeId] = oldBiome = Biome.func_150568_d((int)biomeId);
                for (ResourceLocation ob : ForgeRegistries.BIOMES.getKeys()) {
                    int vanillaBiomeId = ((ForgeEngine)OTG.getEngine()).getBiomeRegistryId(ob);
                    if (vanillaBiomeId == -1) {
                        throw new RuntimeException();
                    }
                    if (biomeId != vanillaBiomeId) continue;
                    vanillaResouceLocations.put(vanillaBiomeId, ob);
                    continue block0;
                }
            }
            vanillaBiomesCached = true;
        }
    }

    @Override
    public void mergeVanillaBiomeMobSpawnSettings(BiomeConfigFinder.BiomeConfigStub biomeConfigStub) {
        Biome biome = null;
        String biomeName = biomeConfigStub.getBiomeName();
        for (Biome vanillaBiome : vanillaBiomes) {
            if (vanillaBiome == null || !vanillaBiome.field_76791_y.equals(biomeName) || vanillaBiome instanceof OTGBiome) continue;
            biome = vanillaBiome;
            break;
        }
        if (biome != null) {
            biomeConfigStub.spawnMonstersMerged = biomeConfigStub.mergeMobs(biomeConfigStub.spawnMonstersMerged, MobSpawnGroupHelper.getListFromMinecraftBiome(biome, MojangSettings.EntityCategory.MONSTER));
            biomeConfigStub.spawnCreaturesMerged = biomeConfigStub.mergeMobs(biomeConfigStub.spawnCreaturesMerged, MobSpawnGroupHelper.getListFromMinecraftBiome(biome, MojangSettings.EntityCategory.CREATURE));
            biomeConfigStub.spawnAmbientCreaturesMerged = biomeConfigStub.mergeMobs(biomeConfigStub.spawnAmbientCreaturesMerged, MobSpawnGroupHelper.getListFromMinecraftBiome(biome, MojangSettings.EntityCategory.AMBIENT_CREATURE));
            biomeConfigStub.spawnWaterCreaturesMerged = biomeConfigStub.mergeMobs(biomeConfigStub.spawnWaterCreaturesMerged, MobSpawnGroupHelper.getListFromMinecraftBiome(biome, MojangSettings.EntityCategory.WATER_CREATURE));
        }
    }

    public void unRegisterBiomes() {
        for (LocalBiome localBiome : this.biomeNames.values()) {
            if (localBiome.getName().equals("The Void") || localBiome.getName().equals("The End") || localBiome.getName().equals("Hell") || localBiome.getName().equals("Sky") || !((ForgeEngine)OTG.getEngine()).worldLoader.isConfigUnique(localBiome.getBiomeConfig().getName())) continue;
            String biomeNameForRegistry = StringHelper.toComputerFriendlyName(localBiome.getName());
            String resourceDomain = "OpenTerrainGenerator".toLowerCase();
            ResourceLocation registryKey = new ResourceLocation(resourceDomain, biomeNameForRegistry);
            ((ForgeEngine)OTG.getEngine()).unRegisterForgeBiome(registryKey);
        }
        ((ForgeEngine)OTG.getEngine()).worldLoader.clearBiomeDictionary(this);
    }

    @Override
    public void SpawnEntity(EntityFunction entityData) {
        block30: {
            if (OTG.getPluginConfig().SpawnLog) {
                OTG.log(LogMarker.DEBUG, "Attempting to spawn BO3 Entity() " + entityData.groupSize + " x " + entityData.mobName + " at " + entityData.x + " " + entityData.y + " " + entityData.z, new Object[0]);
            }
            Random rand = new Random();
            String mobTypeName = entityData.mobName;
            int groupSize = entityData.groupSize;
            String nameTag = entityData.nameTagOrNBTFileName;
            ResourceLocation entityResourceLocation = null;
            Class entityClass = null;
            for (ResourceLocation entry : EntityList.func_180124_b()) {
                if (!entry.func_110623_a().toLowerCase().trim().replace("entity", "").replace("_", "").equals(mobTypeName.toLowerCase().replace("entity", "").replace("_", ""))) continue;
                entityResourceLocation = entry;
                entityClass = EntityList.getClass((ResourceLocation)entry);
                break;
            }
            if (entityClass == null) {
                OTG.log(LogMarker.WARN, "Could not find entity: " + mobTypeName, new Object[0]);
                return;
            }
            Entity entityliving = null;
            if (entityData.nameTagOrNBTFileName != null && (entityData.nameTagOrNBTFileName.toLowerCase().trim().endsWith(".txt") || entityData.nameTagOrNBTFileName.toLowerCase().trim().endsWith(".nbt"))) {
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                try {
                    NBTTagCompound nbtbase = JsonToNBT.func_180713_a((String)entityData.getMetaData());
                    if (!(nbtbase instanceof NBTTagCompound)) {
                        OTG.log(LogMarker.WARN, "Invalid NBT tag for mob in EntityFunction: " + entityData.getMetaData() + ". Skipping mob.", new Object[0]);
                        return;
                    }
                    nbttagcompound = nbtbase;
                }
                catch (NBTException nbtexception) {
                    OTG.log(LogMarker.WARN, "Invalid NBT tag for mob in EntityFunction: " + entityData.getMetaData() + ". Skipping mob.", new Object[0]);
                    return;
                }
                nbttagcompound.func_74778_a("id", entityResourceLocation.func_110623_a());
                entityliving = EntityList.func_75615_a((NBTTagCompound)nbttagcompound, (World)this.world);
            } else {
                try {
                    entityliving = (Entity)entityClass.getConstructor(World.class).newInstance(this.world);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return;
                }
            }
            if (entityliving == null) break block30;
            EnumCreatureType creatureType = EnumCreatureType.MONSTER;
            if (!(entityliving.isCreatureType(creatureType, false) || entityliving.isCreatureType(creatureType = EnumCreatureType.CREATURE, false) || entityliving.isCreatureType(creatureType = EnumCreatureType.AMBIENT, false) || entityliving.isCreatureType(creatureType = EnumCreatureType.WATER_CREATURE, false))) {
                creatureType = EnumCreatureType.CREATURE;
            }
            int j1 = entityData.x;
            int k1 = entityData.y;
            int l1 = entityData.z;
            boolean isWaterMob = entityliving instanceof EntityGuardian;
            Material material = this.world.func_180495_p(new BlockPos(j1, k1, l1)).func_185904_a();
            if (!this.world.func_175677_d(new BlockPos(j1, k1, l1), false) && ((creatureType == EnumCreatureType.WATER_CREATURE || isWaterMob) && material == Material.field_151586_h || material == Material.field_151579_a)) {
                float f = (float)j1 + 0.5f;
                float f1 = k1;
                float f2 = (float)l1 + 0.5f;
                entityliving.func_70012_b((double)f, (double)f1, (double)f2, rand.nextFloat() * 360.0f, 0.0f);
                if (entityliving instanceof EntityLiving) {
                    for (int r = 0; r < groupSize; ++r) {
                        if (r != 0) {
                            if (entityData.nameTagOrNBTFileName != null && (entityData.nameTagOrNBTFileName.toLowerCase().trim().endsWith(".txt") || entityData.nameTagOrNBTFileName.toLowerCase().trim().endsWith(".nbt"))) {
                                NBTTagCompound nbttagcompound = new NBTTagCompound();
                                try {
                                    NBTTagCompound nbtbase = JsonToNBT.func_180713_a((String)entityData.getMetaData());
                                    if (!(nbtbase instanceof NBTTagCompound)) {
                                        OTG.log(LogMarker.WARN, "Invalid NBT tag for mob in EntityFunction: " + entityData.getMetaData() + ". Skipping mob.", new Object[0]);
                                        return;
                                    }
                                    nbttagcompound = nbtbase;
                                }
                                catch (NBTException nbtexception) {
                                    OTG.log(LogMarker.WARN, "Invalid NBT tag for mob in EntityFunction: " + entityData.getMetaData() + ". Skipping mob.", new Object[0]);
                                    return;
                                }
                                nbttagcompound.func_74778_a("id", entityResourceLocation.func_110623_a());
                                entityliving = EntityList.func_75615_a((NBTTagCompound)nbttagcompound, (World)this.world);
                            } else {
                                try {
                                    entityliving = (Entity)entityClass.getConstructor(World.class).newInstance(this.world);
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                    return;
                                }
                            }
                            entityliving.func_70012_b((double)f, (double)f1, (double)f2, rand.nextFloat() * 360.0f, 0.0f);
                        }
                        if (entityData.nameTagOrNBTFileName != null && !entityData.nameTagOrNBTFileName.toLowerCase().trim().endsWith(".txt") && !entityData.nameTagOrNBTFileName.toLowerCase().trim().endsWith(".nbt") && nameTag != null && nameTag.length() > 0) {
                            ((EntityLiving)entityliving).func_96094_a(nameTag);
                        }
                        ((EntityLiving)entityliving).func_110163_bv();
                        if (OTG.getPluginConfig().SpawnLog) {
                            OTG.log(LogMarker.DEBUG, "Spawned OK", new Object[0]);
                        }
                        this.world.func_72838_d(entityliving);
                    }
                } else {
                    for (int r = 0; r < groupSize; ++r) {
                        if (r != 0) {
                            try {
                                entityliving = (Entity)entityClass.getConstructor(World.class).newInstance(this.world);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                                return;
                            }
                            entityliving.func_70012_b((double)f, (double)f1, (double)f2, rand.nextFloat() * 360.0f, 0.0f);
                        }
                        if (OTG.getPluginConfig().SpawnLog) {
                            OTG.log(LogMarker.DEBUG, "Spawned OK", new Object[0]);
                        }
                        this.world.func_72838_d(entityliving);
                    }
                }
            }
        }
    }

    @Override
    public ChunkCoordinate getSpawnChunk() {
        BlockPos spawnPos = this.getSpawnPoint();
        return ChunkCoordinate.fromBlockCoords(spawnPos.func_177958_n(), spawnPos.func_177952_p());
    }

    public BlockPos getSpawnPoint() {
        BlockPos spawnPos = this.world.field_73011_w.getSpawnPoint();
        return new BlockPos(spawnPos.func_177958_n(), spawnPos.func_177956_o(), spawnPos.func_177952_p());
    }

    @Override
    public boolean IsInsidePregeneratedRegion(ChunkCoordinate chunk, boolean includeBorder) {
        return (this.GetWorldSession().getPregeneratedBorderLeft() != 0 || this.GetWorldSession().getPregeneratedBorderRight() != 0 || this.GetWorldSession().getPregeneratedBorderTop() != 0 || this.GetWorldSession().getPregeneratedBorderBottom() != 0) && this.GetWorldSession().getPregenerationRadius() > 0 && chunk.getChunkX() >= this.GetWorldSession().getPreGeneratorCenterPoint().getChunkX() - this.GetWorldSession().getPregeneratedBorderLeft() && chunk.getChunkX() <= this.GetWorldSession().getPreGeneratorCenterPoint().getChunkX() + this.GetWorldSession().getPregeneratedBorderRight() - (!includeBorder ? 1 : 0) && chunk.getChunkZ() >= this.GetWorldSession().getPreGeneratorCenterPoint().getChunkZ() - this.GetWorldSession().getPregeneratedBorderTop() && chunk.getChunkZ() <= this.GetWorldSession().getPreGeneratorCenterPoint().getChunkZ() + this.GetWorldSession().getPregeneratedBorderBottom() - (!includeBorder ? 1 : 0);
    }

    @Override
    public boolean IsInsideWorldBorder(ChunkCoordinate chunk, boolean spawningResources) {
        return this.GetWorldSession().getWorldBorderRadius() == 0 || chunk.getChunkX() >= this.GetWorldSession().getWorldBorderCenterPoint().getChunkX() - (this.GetWorldSession().getWorldBorderRadius() - 1) && chunk.getChunkX() <= this.GetWorldSession().getWorldBorderCenterPoint().getChunkX() + (this.GetWorldSession().getWorldBorderRadius() - 1) - (spawningResources ? 1 : 0) && chunk.getChunkZ() >= this.GetWorldSession().getWorldBorderCenterPoint().getChunkZ() - (this.GetWorldSession().getWorldBorderRadius() - 1) && chunk.getChunkZ() <= this.GetWorldSession().getWorldBorderCenterPoint().getChunkZ() + (this.GetWorldSession().getWorldBorderRadius() - 1) - (spawningResources ? 1 : 0);
    }

    @Override
    public WorldSession GetWorldSession() {
        return this.WorldSession;
    }

    @Override
    public File getWorldSaveDir() {
        return this.getWorld().func_72860_G().func_75765_b();
    }

    @Override
    public int getDimensionId() {
        return this.getWorld().field_73011_w.getDimension();
    }

    @Override
    public void DeleteWorldSessionData() {
        int dimensionId = this.getWorld().field_73011_w.getDimension();
        File worldDataDir = new File(this.getWorld().func_72860_G().func_75765_b() + "/OpenTerrainGenerator/" + (dimensionId != 0 ? "DIM-" + dimensionId + "/" : ""));
        if (worldDataDir.exists()) {
            IOHelper.deleteRecursive(worldDataDir);
        }
    }

    @Override
    public boolean chunkHasDefaultStructure(Random rand, ChunkCoordinate chunk) {
        WorldConfig worldConfig = this.settings.getWorldConfig();
        ChunkPos chunkPos = new ChunkPos(new BlockPos(chunk.getBlockXCenter(), 0, chunk.getBlockZCenter()));
        return worldConfig.villagesEnabled && this.villageGen.chunkHasStructure(this.world, rand, chunkPos) || worldConfig.rareBuildingsEnabled && this.rareBuildingGen.chunkHasStructure(this.world, rand, chunkPos) || worldConfig.netherFortressesEnabled && this.netherFortressGen.chunkHasStructure(this.world, rand, chunkPos) || worldConfig.oceanMonumentsEnabled && this.oceanMonumentGen.chunkHasStructure(this.world, rand, chunkPos) || worldConfig.woodLandMansionsEnabled && this.woodLandMansionGen.chunkHasStructure(this.world, rand, chunkPos);
    }
}

