/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge;

import com.google.common.collect.BiMap;
import com.pg85.otg.LocalMaterialData;
import com.pg85.otg.LocalWorld;
import com.pg85.otg.OTG;
import com.pg85.otg.OTGEngine;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.forge.ForgeLogger;
import com.pg85.otg.forge.ForgeMaterialData;
import com.pg85.otg.forge.ForgeWorld;
import com.pg85.otg.forge.ForgeWorldSession;
import com.pg85.otg.forge.WorldLoader;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.util.minecraftTypes.DefaultMaterial;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class ForgeEngine
extends OTGEngine {
    protected WorldLoader worldLoader;
    protected Map<ResourceLocation, Biome> biomeMap;
    BiMap<Integer, Biome> ids = null;
    BiMap<ResourceLocation, Biome> names = null;

    public void onSave(World world) {
        ForgeWorld forgeWorld = (ForgeWorld)this.getWorld(world);
        if (forgeWorld != null && forgeWorld.getObjectSpawner().saveRequired && !forgeWorld.GetWorldSession().getPreGeneratorIsRunning()) {
            forgeWorld.getStructureCache().SaveToDisk();
        }
    }

    public void ProcessPregeneratorTick() {
        for (LocalWorld world : this.getAllWorlds()) {
            ((ForgeWorldSession)world.GetWorldSession()).getPregenerator().ProcessTick();
        }
    }

    public ForgeEngine(WorldLoader worldLoader) {
        super(new ForgeLogger());
        this.worldLoader = worldLoader;
    }

    public Biome getRegisteredBiome(int id) {
        if (this.ids == null) {
            try {
                Field[] fields;
                for (Field field : fields = ForgeRegistries.BIOMES.getClass().getDeclaredFields()) {
                    Class<?> fieldClass = field.getType();
                    if (!fieldClass.equals(BiMap.class)) continue;
                    field.setAccessible(true);
                    this.ids = (BiMap)field.get(ForgeRegistries.BIOMES);
                    break;
                }
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        try {
            return (Biome)this.ids.get((Object)id);
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public int getBiomeRegistryId(Biome biome) {
        if (this.ids == null) {
            try {
                Field[] fields;
                for (Field field : fields = ForgeRegistries.BIOMES.getClass().getDeclaredFields()) {
                    Class<?> fieldClass = field.getType();
                    if (!fieldClass.equals(BiMap.class)) continue;
                    field.setAccessible(true);
                    this.ids = (BiMap)field.get(ForgeRegistries.BIOMES);
                    break;
                }
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        try {
            return biome == null ? -1 : (Integer)this.ids.inverse().get((Object)biome);
        }
        catch (NullPointerException ex) {
            return -1;
        }
    }

    public int getBiomeRegistryId(ResourceLocation resourceLocation) {
        Biome biome;
        Field[] fields;
        if (this.ids == null) {
            try {
                for (Field field : fields = ForgeRegistries.BIOMES.getClass().getDeclaredFields()) {
                    Class<?> fieldClass = field.getType();
                    if (!fieldClass.equals(BiMap.class)) continue;
                    field.setAccessible(true);
                    this.ids = (BiMap)field.get(ForgeRegistries.BIOMES);
                    break;
                }
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        if (this.names == null) {
            try {
                fields = ForgeRegistries.BIOMES.getClass().getDeclaredFields();
                boolean isFirst = true;
                for (Field field : fields) {
                    Class<?> fieldClass = field.getType();
                    if (!fieldClass.equals(BiMap.class)) continue;
                    if (isFirst) {
                        isFirst = false;
                        continue;
                    }
                    field.setAccessible(true);
                    this.names = (BiMap)field.get(ForgeRegistries.BIOMES);
                    break;
                }
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        if ((biome = (Biome)this.names.get((Object)resourceLocation)) != null) {
            return (Integer)this.ids.inverse().get((Object)biome);
        }
        throw new RuntimeException("This should not happen, please submit a bug report to the OTG git.");
    }

    public void registerForgeBiome(ResourceLocation resourceLocation, Biome biome) {
        OTG.log(LogMarker.TRACE, "Registering biome " + resourceLocation.toString(), new Object[0]);
        if (this.names == null) {
            try {
                Field[] fields = ForgeRegistries.BIOMES.getClass().getDeclaredFields();
                boolean isFirst = true;
                for (Field field : fields) {
                    Class<?> fieldClass = field.getType();
                    if (!fieldClass.equals(BiMap.class)) continue;
                    if (isFirst) {
                        isFirst = false;
                        continue;
                    }
                    field.setAccessible(true);
                    this.names = (BiMap)field.get(ForgeRegistries.BIOMES);
                    break;
                }
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        this.names.put((Object)resourceLocation, (Object)biome);
    }

    public int registerForgeBiome(int id, ResourceLocation resourceLocation, Biome biome) {
        Field[] fields;
        OTG.log(LogMarker.TRACE, "Registering biome " + resourceLocation.toString(), new Object[0]);
        if (this.ids == null) {
            try {
                for (Field field : fields = ForgeRegistries.BIOMES.getClass().getDeclaredFields()) {
                    Class<?> fieldClass = field.getType();
                    if (!fieldClass.equals(BiMap.class)) continue;
                    field.setAccessible(true);
                    this.ids = (BiMap)field.get(ForgeRegistries.BIOMES);
                    break;
                }
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        if (this.names == null) {
            try {
                fields = ForgeRegistries.BIOMES.getClass().getDeclaredFields();
                boolean isFirst = true;
                for (Field field : fields) {
                    Class<?> fieldClass = field.getType();
                    if (!fieldClass.equals(BiMap.class)) continue;
                    if (isFirst) {
                        isFirst = false;
                        continue;
                    }
                    field.setAccessible(true);
                    this.names = (BiMap)field.get(ForgeRegistries.BIOMES);
                    break;
                }
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        this.names.put((Object)resourceLocation, (Object)biome);
        if (this.ids.get((Object)id) != null) {
            for (int i = 0; i < 256; ++i) {
                if (this.ids.get((Object)i) != null) continue;
                this.ids.put((Object)i, (Object)biome);
                return i;
            }
        }
        this.ids.put((Object)id, (Object)biome);
        BitSet biomeRegistryAvailabiltyMap = this.getBiomeRegistryAvailabiltyMap();
        biomeRegistryAvailabiltyMap.set(id, true);
        return id;
    }

    public void unRegisterForgeBiome(ResourceLocation resourceLocation) {
        int biomeId;
        OTG.log(LogMarker.TRACE, "Unregistering biome " + resourceLocation.toString(), new Object[0]);
        Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(resourceLocation);
        BitSet biomeRegistryAvailabiltyMap = this.getBiomeRegistryAvailabiltyMap();
        try {
            biomeId = ((ForgeEngine)OTG.getEngine()).getBiomeRegistryId(biome);
            if (biomeId > -1 && ((ForgeEngine)OTG.getEngine()).getRegisteredBiome(biomeId) == biome) {
                biomeRegistryAvailabiltyMap.set(biomeId, false);
            }
        }
        catch (IndexOutOfBoundsException ex) {
            OTG.log(LogMarker.ERROR, "Could not unregister " + biome.field_76791_y, new Object[0]);
            throw new RuntimeException("Whatever it is you're trying to do, we didn't write any code for it (sorry). Please contact Team OTG about this crash.");
        }
        if (this.names == null) {
            try {
                Field[] fields = ForgeRegistries.BIOMES.getClass().getDeclaredFields();
                boolean isFirst = true;
                Field[] fieldArray = fields;
                int n = fieldArray.length;
                for (int i = 0; i < n; ++i) {
                    Field field = fieldArray[i];
                    Class<?> fieldClass = field.getType();
                    if (!fieldClass.equals(BiMap.class)) continue;
                    if (isFirst) {
                        isFirst = false;
                        continue;
                    }
                    field.setAccessible(true);
                    this.names = (BiMap)field.get(ForgeRegistries.BIOMES);
                    break;
                }
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        if (this.ids == null) {
            try {
                Field[] fields;
                for (Field field : fields = ForgeRegistries.BIOMES.getClass().getDeclaredFields()) {
                    Class<?> fieldClass = field.getType();
                    if (!fieldClass.equals(BiMap.class)) continue;
                    field.setAccessible(true);
                    this.ids = (BiMap)field.get(ForgeRegistries.BIOMES);
                    break;
                }
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        this.names.remove((Object)resourceLocation, (Object)biome);
        try {
            biomeId = (Integer)this.ids.inverse().get((Object)biome);
            this.ids.remove((Object)biomeId, (Object)biome);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public BitSet getBiomeRegistryAvailabiltyMap() {
        BitSet biomeRegistryAvailabiltyMap = null;
        try {
            Field[] fields;
            for (Field field : fields = ForgeRegistries.BIOMES.getClass().getDeclaredFields()) {
                Class<?> fieldClass = field.getType();
                if (!fieldClass.equals(BitSet.class)) continue;
                field.setAccessible(true);
                biomeRegistryAvailabiltyMap = (BitSet)field.get(ForgeRegistries.BIOMES);
                break;
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return biomeRegistryAvailabiltyMap;
    }

    public WorldLoader getWorldLoader() {
        return this.worldLoader;
    }

    public boolean getCartographerEnabled() {
        ForgeWorld world = this.getOverWorld();
        return world == null ? false : world.getConfigs().getWorldConfig().Cartographer;
    }

    public ForgeWorld getOverWorld() {
        ArrayList<LocalWorld> allWorlds = this.getAllWorlds();
        for (LocalWorld world : allWorlds) {
            if (((ForgeWorld)world).getWorld() == null || ((ForgeWorld)world).getWorld().field_73011_w == null || ((ForgeWorld)world).getWorld().field_73011_w.getDimension() != 0) continue;
            return (ForgeWorld)world;
        }
        return null;
    }

    public ForgeWorld getWorldByDimId(int dimensionId) {
        ForgeWorld forgeWorld;
        if (dimensionId == 0) {
            forgeWorld = ((ForgeEngine)OTG.getEngine()).getOverWorld();
        } else {
            DimensionType dimType = DimensionManager.getProviderType((int)dimensionId);
            forgeWorld = (ForgeWorld)OTG.getWorld(dimType.func_186065_b());
        }
        return forgeWorld;
    }

    public LocalWorld getWorld(World world) {
        if (world.field_73011_w.getDimension() == 0) {
            return ((ForgeEngine)OTG.getEngine()).getOverWorld();
        }
        if (world.field_73011_w.getDimension() > 1 && world.field_73011_w.func_186058_p().func_186067_c() != null && world.field_73011_w.func_186058_p().func_186067_c().equals("OTG")) {
            ForgeWorld localWorld = this.worldLoader.getWorld(world.field_73011_w.func_186058_p().func_186065_b());
            if (localWorld == null) {
                return this.worldLoader.getUnloadedWorld(world.field_73011_w.func_186058_p().func_186065_b());
            }
            return this.worldLoader.getWorld(world.field_73011_w.func_186058_p().func_186065_b());
        }
        ForgeWorld localWorld = this.worldLoader.getWorld(world.func_72912_H().func_76065_j());
        if (localWorld == null) {
            return this.worldLoader.getUnloadedWorld(world.func_72912_H().func_76065_j());
        }
        return localWorld;
    }

    @Override
    public LocalWorld getWorld(String name) {
        return this.worldLoader.getWorld(name);
    }

    @Override
    public LocalWorld getUnloadedWorld(String name) {
        return this.worldLoader.getUnloadedWorld(name);
    }

    public ArrayList<ForgeWorld> getUnloadedWorlds() {
        return this.worldLoader.getUnloadedWorlds();
    }

    @Override
    public ArrayList<LocalWorld> getAllWorlds() {
        return this.worldLoader.getAllWorlds();
    }

    @Override
    public File getTCDataFolder() {
        return this.worldLoader.getConfigsFolder();
    }

    @Override
    public File getGlobalObjectsDirectory() {
        return new File(this.getTCDataFolder(), "GlobalObjects");
    }

    @Override
    public LocalMaterialData readMaterial(String input) throws InvalidConfigException {
        return ForgeMaterialData.ofString(input);
    }

    @Override
    public LocalMaterialData toLocalMaterialData(DefaultMaterial defaultMaterial, int blockData) {
        return ForgeMaterialData.ofDefaultMaterial(defaultMaterial, blockData);
    }
}

