/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobjects.bo3;

import com.pg85.otg.LocalMaterialData;
import com.pg85.otg.LocalWorld;
import com.pg85.otg.configuration.CustomObjectConfigFunction;
import com.pg85.otg.customobjects.CustomObjectCoordinate;
import com.pg85.otg.customobjects.bo3.BO3Config;
import com.pg85.otg.customobjects.bo3.BO3Function;
import com.pg85.otg.customobjects.bo3.BO3Loader;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.util.NamedBinaryTag;
import com.pg85.otg.util.Rotation;
import java.util.List;
import java.util.Random;

public class BlockFunction
extends BO3Function {
    public LocalMaterialData material;
    public int x;
    public int y;
    public int z;
    public NamedBinaryTag metaDataTag;
    public String metaDataName;

    @Override
    public void load(List<String> args) throws InvalidConfigException {
        this.assureSize(4, args);
        this.x = this.readInt(args.get(0), -100, 100);
        this.y = this.readInt(args.get(1), -1000, 1000);
        this.z = this.readInt(args.get(2), -100, 100);
        String materialName = args.get(3);
        this.material = this.readMaterial(materialName);
        if (args.size() == 5) {
            this.metaDataTag = BO3Loader.loadMetadata(args.get(4), ((BO3Config)this.getHolder()).getFile());
            if (this.metaDataTag != null) {
                this.metaDataName = args.get(4);
            }
        }
    }

    @Override
    public String makeString() {
        String start = "Block(" + this.x + ',' + this.y + ',' + this.z + ',' + this.material;
        if (this.metaDataTag != null) {
            start = start + ',' + this.metaDataName;
        }
        return start + ')';
    }

    @Override
    public BlockFunction rotate() {
        BlockFunction rotatedBlock = new BlockFunction();
        rotatedBlock.x = this.z;
        rotatedBlock.y = this.y;
        rotatedBlock.z = -this.x;
        rotatedBlock.material = this.material.rotate();
        rotatedBlock.metaDataTag = this.metaDataTag;
        rotatedBlock.metaDataName = this.metaDataName;
        return rotatedBlock;
    }

    public BlockFunction rotate(Rotation rotation) {
        BlockFunction rotatedBlock = new BlockFunction();
        rotatedBlock.material = this.material;
        CustomObjectCoordinate rotatedCoords = CustomObjectCoordinate.getRotatedBO3CoordsJustified(this.x, this.y, this.z, rotation);
        rotatedBlock.x = rotatedCoords.getX();
        rotatedBlock.y = rotatedCoords.getY();
        rotatedBlock.z = rotatedCoords.getZ();
        if (rotation.getRotationId() == 3) {
            rotatedBlock.material = rotatedBlock.material.rotate();
        }
        if (rotation.getRotationId() == 2) {
            rotatedBlock.material = rotatedBlock.material.rotate();
            rotatedBlock.material = rotatedBlock.material.rotate();
        }
        if (rotation.getRotationId() == 1) {
            rotatedBlock.material = rotatedBlock.material.rotate();
            rotatedBlock.material = rotatedBlock.material.rotate();
            rotatedBlock.material = rotatedBlock.material.rotate();
        }
        rotatedBlock.metaDataTag = this.metaDataTag;
        rotatedBlock.metaDataName = this.metaDataName;
        return rotatedBlock;
    }

    public void spawn(LocalWorld world, Random random, int x, int y, int z, boolean isOTGPlus) {
        world.setBlock(x, y, z, this.material, this.metaDataTag, isOTGPlus);
    }

    @Override
    public boolean isAnalogousTo(CustomObjectConfigFunction<BO3Config> other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        BlockFunction block = (BlockFunction)other;
        return block.x == this.x && block.y == this.y && block.z == this.z;
    }
}

