/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobjects;

import com.pg85.otg.customobjects.CustomObject;
import com.pg85.otg.customobjects.CustomObjectCollection;
import com.pg85.otg.customobjects.CustomObjectLoader;
import com.pg85.otg.customobjects.TreeObject;
import com.pg85.otg.customobjects.bo2.BO2Loader;
import com.pg85.otg.customobjects.bo3.BO3Loader;
import com.pg85.otg.util.minecraftTypes.TreeType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class CustomObjectManager {
    public final Map<String, CustomObjectLoader> loaders = new HashMap<String, CustomObjectLoader>();
    private final CustomObjectCollection globalCustomObjects;

    public CustomObjectManager() {
        this.registerCustomObjectLoader("bo2", new BO2Loader());
        this.registerCustomObjectLoader("bo3", new BO3Loader());
        this.globalCustomObjects = new CustomObjectCollection();
        for (TreeType type : TreeType.values()) {
            this.registerGlobalObject(new TreeObject(type));
        }
    }

    public void ReloadCustomObjectFiles() {
        this.globalCustomObjects.ReloadCustomObjectFiles();
    }

    public void registerCustomObjectLoader(String extension, CustomObjectLoader loader) {
        this.loaders.put(extension.toLowerCase(), loader);
    }

    public void registerGlobalObject(CustomObject object) {
        this.globalCustomObjects.addLoadedGlobalObject(object);
    }

    public CustomObjectCollection getGlobalObjects() {
        return this.globalCustomObjects;
    }

    public Map<String, CustomObjectLoader> getObjectLoaders() {
        return Collections.unmodifiableMap(this.loaders);
    }

    public void shutdown() {
        for (CustomObjectLoader loader : this.loaders.values()) {
            loader.onShutdown();
        }
        this.loaders.clear();
    }
}

