/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobjects;

import com.pg85.otg.OTG;
import com.pg85.otg.customobjects.CustomObject;
import com.pg85.otg.customobjects.CustomObjectLoader;
import com.pg85.otg.customobjects.TreeObject;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.util.minecraftTypes.TreeType;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;

public class CustomObjectCollection {
    private ArrayList<CustomObject> objectsGlobalObjects = new ArrayList();
    private HashMap<String, CustomObject> objectsByNameGlobalObjects = new HashMap();
    private ArrayList<String> objectsNotFoundGlobalObjects = new ArrayList();
    private HashMap<String, ArrayList<CustomObject>> objectsPerWorld = new HashMap();
    private HashMap<String, HashMap<String, CustomObject>> objectsByNamePerWorld = new HashMap();
    private HashMap<String, ArrayList<String>> objectsNotFoundPerWorld = new HashMap();
    HashMap<String, File> CustomObjectFilesGlobalObjects = null;
    HashMap<String, HashMap<String, File>> CustomObjectFilesPerWorld = new HashMap();

    public CustomObject loadObject(File file, String worldName) {
        CustomObject object = null;
        if (file.isFile()) {
            String fileName = file.getName();
            int index = fileName.lastIndexOf(46);
            if (index != -1) {
                String objectType = fileName.substring(index + 1, fileName.length());
                String objectName = fileName.substring(0, index);
                CustomObjectLoader loader = OTG.getCustomObjectManager().getObjectLoaders().get(objectType.toLowerCase());
                if (loader != null) {
                    object = loader.loadFromFile(objectName, file);
                    if (worldName != null) {
                        ArrayList<CustomObject> worldObjects = this.objectsPerWorld.get(worldName);
                        if (worldObjects == null) {
                            worldObjects = new ArrayList();
                            this.objectsPerWorld.put(worldName, worldObjects);
                        }
                        worldObjects.add(object);
                    } else {
                        this.objectsGlobalObjects.add(object);
                    }
                    object.onEnable(null);
                }
            }
        } else {
            OTG.log(LogMarker.INFO, "Given path does not exist: " + file.getAbsolutePath(), new Object[0]);
            throw new RuntimeException();
        }
        return object;
    }

    public void addLoadedGlobalObject(CustomObject object) {
        String lowerCaseName = object.getName().toLowerCase();
        if (!this.objectsByNameGlobalObjects.containsKey(lowerCaseName)) {
            this.objectsByNameGlobalObjects.put(lowerCaseName, object);
            this.objectsGlobalObjects.add(object);
        }
    }

    public void ReloadCustomObjectFiles() {
        this.objectsGlobalObjects.clear();
        this.objectsByNameGlobalObjects.clear();
        this.objectsNotFoundGlobalObjects.clear();
        this.objectsPerWorld.clear();
        this.objectsByNamePerWorld.clear();
        this.objectsNotFoundPerWorld.clear();
        this.CustomObjectFilesGlobalObjects = null;
        this.CustomObjectFilesPerWorld.clear();
    }

    public CustomObject getObjectByName(String name, String worldName) {
        HashMap<Object, Object> worldCustomObjectFiles;
        ArrayList<String> worldObjectsNotFoundByName;
        HashMap<String, CustomObject> worldObjectsByName;
        CustomObject object = null;
        if (worldName != null && (worldObjectsByName = this.objectsByNamePerWorld.get(worldName)) != null) {
            object = worldObjectsByName.get(name.toLowerCase());
        }
        boolean bSearchedWorldObjects = false;
        if (object == null && worldName != null && (worldObjectsNotFoundByName = this.objectsNotFoundPerWorld.get(worldName)) != null && worldObjectsNotFoundByName.contains(name.toLowerCase())) {
            bSearchedWorldObjects = true;
        }
        if (object == null && (worldName == null || bSearchedWorldObjects)) {
            object = this.objectsByNameGlobalObjects.get(name.toLowerCase());
        }
        if (object != null) {
            return object;
        }
        if (name.equalsIgnoreCase("UseWorld") || name.equalsIgnoreCase("UseWorldAll")) {
            return null;
        }
        if (name.equalsIgnoreCase("UseBiome") || name.equalsIgnoreCase("UseBiomeAll")) {
            return null;
        }
        boolean bSearchedGlobalObjects = false;
        if (this.objectsNotFoundGlobalObjects != null && this.objectsNotFoundGlobalObjects.contains(name.toLowerCase())) {
            bSearchedGlobalObjects = true;
        }
        if (bSearchedGlobalObjects && (worldName == null || bSearchedWorldObjects)) {
            return null;
        }
        if (this.CustomObjectFilesGlobalObjects == null) {
            this.CustomObjectFilesGlobalObjects = new HashMap();
            if (new File(OTG.getEngine().getTCDataFolder() + File.separator + "GlobalObjects").exists()) {
                this.indexAllCustomObjectFilesInDir(new File(OTG.getEngine().getTCDataFolder() + File.separator + "GlobalObjects"), this.CustomObjectFilesGlobalObjects);
            }
            for (TreeType type : TreeType.values()) {
                this.addLoadedGlobalObject(new TreeObject(type));
            }
        }
        if (!this.CustomObjectFilesPerWorld.containsKey(worldName)) {
            worldCustomObjectFiles = new HashMap();
            this.CustomObjectFilesPerWorld.put(worldName, worldCustomObjectFiles);
            if (worldName != null && new File(OTG.getEngine().getTCDataFolder() + File.separator + "worlds" + File.separator + worldName + File.separator + "WorldObjects").exists()) {
                this.indexAllCustomObjectFilesInDir(new File(OTG.getEngine().getTCDataFolder() + File.separator + "worlds" + File.separator + worldName + File.separator + "WorldObjects"), worldCustomObjectFiles);
            }
        }
        if (worldName != null && !bSearchedWorldObjects) {
            File searchForFile;
            worldCustomObjectFiles = this.CustomObjectFilesPerWorld.get(worldName);
            if (worldCustomObjectFiles != null && (searchForFile = (File)worldCustomObjectFiles.get(name.toLowerCase())) != null) {
                object = this.loadObject(searchForFile, worldName);
                if (object != null) {
                    HashMap<String, CustomObject> worldObjectsByName2 = this.objectsByNamePerWorld.get(worldName);
                    if (worldObjectsByName2 == null) {
                        worldObjectsByName2 = new HashMap();
                        this.objectsByNamePerWorld.put(worldName, worldObjectsByName2);
                    }
                    worldObjectsByName2.put(name.toLowerCase(), object);
                    return object;
                }
                OTG.log(LogMarker.ERROR, "Could not load BO2/BO3, it probably contains errors: " + searchForFile, new Object[0]);
                return null;
            }
            ArrayList<String> worldObjectsNotFound = this.objectsNotFoundPerWorld.get(worldName);
            if (worldObjectsNotFound == null) {
                worldObjectsNotFound = new ArrayList();
                this.objectsNotFoundPerWorld.put(worldName, worldObjectsNotFound);
            }
            worldObjectsNotFound.add(name.toLowerCase());
        }
        if (!bSearchedGlobalObjects) {
            object = this.objectsByNameGlobalObjects.get(name.toLowerCase());
            if (object != null) {
                return object;
            }
            File searchForFile = this.CustomObjectFilesGlobalObjects.get(name.toLowerCase());
            if (searchForFile != null) {
                object = this.loadObject(searchForFile, worldName);
                if (object != null) {
                    this.objectsByNameGlobalObjects.put(name.toLowerCase(), object);
                    return object;
                }
                OTG.log(LogMarker.ERROR, "Could not load BO2/BO3, it probably contains errors: " + searchForFile, new Object[0]);
                return null;
            }
            this.objectsNotFoundGlobalObjects.add(name.toLowerCase());
        }
        OTG.log(LogMarker.ERROR, "Could not find BO2/BO3 " + name + " in GlobalObjects " + (worldName != null ? "and WorldObjects" : "") + " directory " + (worldName != null ? "for world " + worldName : "") + ".", new Object[0]);
        return null;
    }

    private void indexAllCustomObjectFilesInDir(File searchDir, HashMap<String, File> customObjectFiles) {
        if (searchDir.exists()) {
            if (searchDir.isDirectory()) {
                for (File fileInDir : searchDir.listFiles()) {
                    if (fileInDir.isDirectory()) {
                        this.indexAllCustomObjectFilesInDir(fileInDir, customObjectFiles);
                        continue;
                    }
                    if (!fileInDir.getName().toLowerCase().endsWith(".bo3") && !fileInDir.getName().toLowerCase().endsWith(".bo2")) continue;
                    if (!customObjectFiles.containsKey(fileInDir.getName().toLowerCase().replace(".bo3", "").replace(".bo2", ""))) {
                        customObjectFiles.put(fileInDir.getName().toLowerCase().replace(".bo3", "").replace(".bo2", ""), fileInDir);
                        continue;
                    }
                    if (!OTG.getPluginConfig().SpawnLog) continue;
                    OTG.log(LogMarker.WARN, "Duplicate file found: " + fileInDir.getName() + ".", new Object[0]);
                }
            } else if (searchDir.getName().toLowerCase().endsWith(".bo3") || searchDir.getName().toLowerCase().endsWith(".bo2")) {
                if (!customObjectFiles.containsKey(searchDir.getName().toLowerCase().replace(".bo3", "").replace(".bo2", ""))) {
                    customObjectFiles.put(searchDir.getName().toLowerCase().replace(".bo3", "").replace(".bo2", ""), searchDir);
                } else if (OTG.getPluginConfig().SpawnLog) {
                    OTG.log(LogMarker.WARN, "Duplicate file found: " + searchDir.getName() + ".", new Object[0]);
                }
            }
        }
    }
}

