/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.configuration;

import com.pg85.otg.LocalMaterialData;
import com.pg85.otg.OTG;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.util.MaterialSet;
import com.pg85.otg.util.helpers.StringHelper;
import java.util.ArrayList;
import java.util.List;

public abstract class CustomObjectConfigFunction<T> {
    protected String error;
    protected List<String> inputArgs;
    protected String inputName;
    protected boolean valid = true;
    protected T holder;

    public static final <T> CustomObjectConfigFunction<T> create(T holder, Class<? extends CustomObjectConfigFunction<T>> clazz, Object ... args) {
        CustomObjectConfigFunction<T> configFunction;
        ArrayList<String> stringArgs = new ArrayList<String>(args.length);
        for (Object arg : args) {
            stringArgs.add("" + arg);
        }
        try {
            configFunction = clazz.newInstance();
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        configFunction.setHolder(holder);
        try {
            configFunction.load(stringArgs);
        }
        catch (InvalidConfigException e) {
            OTG.log(LogMarker.FATAL, "Invalid default config function! Please report! {}: {}", clazz.getName(), e.getMessage());
            OTG.printStackTrace(LogMarker.FATAL, e);
        }
        return configFunction;
    }

    protected final void assureSize(int size, List<String> args) throws InvalidConfigException {
        if (args.size() < size) {
            throw new InvalidConfigException("Too few arguments supplied");
        }
    }

    public final String getError() throws IllegalStateException {
        if (this.isValid()) {
            throw new IllegalStateException("Function is valid, so no error");
        }
        return this.error;
    }

    public final T getHolder() {
        return this.holder;
    }

    public abstract Class<T> getHolderType();

    public final void init(T holder, List<String> args) throws InvalidConfigException {
        this.holder = holder;
        this.load(args);
    }

    public final void invalidate(String name, List<String> args, String error) {
        this.valid = false;
        this.inputName = name;
        this.inputArgs = args;
        this.error = error;
    }

    public abstract boolean isAnalogousTo(CustomObjectConfigFunction<T> var1);

    public final boolean isValid() {
        return this.valid;
    }

    protected abstract void load(List<String> var1) throws InvalidConfigException;

    protected final String makeMaterials(MaterialSet materials) {
        return "," + materials.toString();
    }

    public abstract String makeString();

    protected final double readDouble(String string, double minValue, double maxValue) throws InvalidConfigException {
        return StringHelper.readDouble(string, minValue, maxValue);
    }

    protected final int readInt(String string, int minValue, int maxValue) throws InvalidConfigException {
        return StringHelper.readInt(string, minValue, maxValue);
    }

    protected final boolean readBoolean(String string) {
        return Boolean.parseBoolean(string);
    }

    protected final LocalMaterialData readMaterial(String string) throws InvalidConfigException {
        return OTG.readMaterial(string);
    }

    protected final MaterialSet readMaterials(List<String> strings, int start) throws InvalidConfigException {
        MaterialSet materials = new MaterialSet();
        for (int i = start; i < strings.size(); ++i) {
            materials.parseAndAdd(strings.get(i));
        }
        return materials;
    }

    protected final double readRarity(String string) throws InvalidConfigException {
        return StringHelper.readDouble(string, 1.0E-6, 100.0);
    }

    public final void setHolder(T holder) {
        this.holder = holder;
    }

    @Deprecated
    public final void setValid(boolean valid) {
        if (!valid) {
            throw new UnsupportedOperationException("Use the invalidate method");
        }
        if (valid && !this.isValid()) {
            throw new UnsupportedOperationException("Revalidating objects is no longer supported");
        }
    }

    public final String write() {
        if (!this.valid) {
            return "## INVALID " + this.inputName.toUpperCase() + " - " + this.error + " ##" + System.getProperty("line.separator") + this.inputName + "(" + StringHelper.join(this.inputArgs, ",") + ")";
        }
        return this.makeString();
    }
}

