/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.configuration;

import com.pg85.otg.OTG;
import com.pg85.otg.configuration.WorldConfig;
import com.pg85.otg.configuration.io.FileSettingsWriterOTGPlus;
import com.pg85.otg.configuration.io.SettingsReaderOTGPlus;
import com.pg85.otg.configuration.io.SettingsWriterOTGPlus;
import com.pg85.otg.configuration.settingType.Setting;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.util.minecraftTypes.DefaultBiome;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public abstract class CustomObjectConfigFile {
    public SettingsReaderOTGPlus reader;
    public String name;
    public File file;
    protected final boolean isNewConfig;

    protected CustomObjectConfigFile(SettingsReaderOTGPlus reader) throws IllegalArgumentException {
        this.reader = reader;
        this.isNewConfig = reader.isNewConfig();
        this.file = reader.getFile();
        this.name = reader.getName();
    }

    protected <T> T readSettings(Setting<T> setting) {
        return this.readSettings(setting, setting.getDefaultValue());
    }

    protected <T> T readSettings(Setting<T> setting, T defaultValue) {
        return this.reader.getSetting(setting, defaultValue);
    }

    public void write(SettingsWriterOTGPlus writer, WorldConfig.ConfigMode configMode) throws IOException {
        if (configMode == WorldConfig.ConfigMode.WriteDisable) {
            throw new IOException("ConfigMode is " + (Object)((Object)WorldConfig.ConfigMode.WriteDisable));
        }
        writer.setConfigMode(configMode);
        try {
            writer.open();
            this.writeConfigSettings(writer);
        }
        finally {
            writer.close();
        }
    }

    @Deprecated
    public void writeSettingsFile(boolean comments) {
        FileSettingsWriterOTGPlus.writeToFile(this, comments ? WorldConfig.ConfigMode.WriteAll : WorldConfig.ConfigMode.WriteWithoutComments);
    }

    public void logIOError(IOException e) {
        OTG.log(LogMarker.ERROR, "Failed to write to file {}", this.file);
        OTG.printStackTrace(LogMarker.ERROR, e);
    }

    protected abstract void writeConfigSettings(SettingsWriterOTGPlus var1) throws IOException;

    protected abstract void readConfigSettings() throws InvalidConfigException;

    protected abstract void correctSettings();

    protected abstract void renameOldSettings();

    protected void renameOldSetting(String oldValue, Setting<?> newValue) {
        this.reader.renameOldSetting(oldValue, newValue);
    }

    protected int higherThan(int currentValue, int minimumValue) {
        if (currentValue <= minimumValue) {
            return minimumValue + 1;
        }
        return currentValue;
    }

    protected double higherThan(double currentValue, double minimumValue) {
        if (currentValue < minimumValue) {
            return minimumValue;
        }
        return currentValue;
    }

    protected int lowerThanOrEqualTo(int currentValue, int maximumValue) {
        if (currentValue > maximumValue) {
            return maximumValue;
        }
        return currentValue;
    }

    protected ArrayList<String> filterBiomes(List<String> biomes, Set<String> customBiomes) {
        ArrayList<String> output = new ArrayList<String>();
        for (String key : biomes) {
            if (customBiomes.contains(key = key.trim())) {
                output.add(key);
                continue;
            }
            if (!DefaultBiome.Contain(key)) continue;
            output.add(key);
        }
        return output;
    }

    protected static void writeStringToStream(DataOutputStream stream, String value) throws IOException {
        byte[] bytes = value.getBytes();
        stream.writeShort(bytes.length);
        stream.write(bytes);
    }

    public static String readStringFromStream(DataInputStream stream) throws IOException {
        byte[] chars = new byte[stream.readShort()];
        if (stream.read(chars, 0, chars.length) != chars.length) {
            throw new EOFException();
        }
        return new String(chars);
    }

    public String getName() {
        return this.name;
    }

    public File getFile() {
        return this.file;
    }
}

