/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.configuration;

import com.pg85.otg.BiomeIds;
import com.pg85.otg.LocalBiome;
import com.pg85.otg.LocalWorld;
import com.pg85.otg.configuration.BiomeConfig;
import com.pg85.otg.configuration.BiomeLoadInstruction;
import com.pg85.otg.configuration.ConfigFile;
import com.pg85.otg.configuration.ConfigProvider;
import com.pg85.otg.configuration.WorldConfig;
import com.pg85.otg.configuration.io.SimpleSettingsMap;
import com.pg85.otg.configuration.standard.BiomeStandardValues;
import com.pg85.otg.configuration.standard.StandardBiomeTemplate;
import com.pg85.otg.configuration.standard.WorldStandardValues;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;

public final class ClientConfigProvider
implements ConfigProvider {
    private WorldConfig worldConfig;
    private LocalBiome[] biomes;

    public ClientConfigProvider(DataInputStream stream, LocalWorld world, boolean isSinglePlayer) throws IOException {
        int id;
        SimpleSettingsMap worldSettingsReader = new SimpleSettingsMap(world.getName(), false);
        worldSettingsReader.putSetting(WorldStandardValues.WORLD_FOG, stream.readInt(), new String[0]);
        worldSettingsReader.putSetting(WorldStandardValues.WORLD_NIGHT_FOG, stream.readInt(), new String[0]);
        worldSettingsReader.putSetting(WorldStandardValues.WATER_LEVEL_MAX, stream.readInt(), new String[0]);
        worldSettingsReader.putSetting(WorldStandardValues.commandBlockOutput, Boolean.parseBoolean(ConfigFile.readStringFromStream(stream)), new String[0]);
        worldSettingsReader.putSetting(WorldStandardValues.disableElytraMovementCheck, Boolean.parseBoolean(ConfigFile.readStringFromStream(stream)), new String[0]);
        worldSettingsReader.putSetting(WorldStandardValues.doDaylightCycle, Boolean.parseBoolean(ConfigFile.readStringFromStream(stream)), new String[0]);
        worldSettingsReader.putSetting(WorldStandardValues.doEntityDrops, Boolean.parseBoolean(ConfigFile.readStringFromStream(stream)), new String[0]);
        worldSettingsReader.putSetting(WorldStandardValues.doFireTick, Boolean.parseBoolean(ConfigFile.readStringFromStream(stream)), new String[0]);
        worldSettingsReader.putSetting(WorldStandardValues.doMobLoot, Boolean.parseBoolean(ConfigFile.readStringFromStream(stream)), new String[0]);
        worldSettingsReader.putSetting(WorldStandardValues.doMobSpawning, Boolean.parseBoolean(ConfigFile.readStringFromStream(stream)), new String[0]);
        worldSettingsReader.putSetting(WorldStandardValues.doTileDrops, Boolean.parseBoolean(ConfigFile.readStringFromStream(stream)), new String[0]);
        worldSettingsReader.putSetting(WorldStandardValues.doWeatherCycle, Boolean.parseBoolean(ConfigFile.readStringFromStream(stream)), new String[0]);
        worldSettingsReader.putSetting(WorldStandardValues.keepInventory, Boolean.parseBoolean(ConfigFile.readStringFromStream(stream)), new String[0]);
        worldSettingsReader.putSetting(WorldStandardValues.logAdminCommands, Boolean.parseBoolean(ConfigFile.readStringFromStream(stream)), new String[0]);
        worldSettingsReader.putSetting(WorldStandardValues.maxEntityCramming, Integer.parseInt(ConfigFile.readStringFromStream(stream)), new String[0]);
        worldSettingsReader.putSetting(WorldStandardValues.mobGriefing, Boolean.parseBoolean(ConfigFile.readStringFromStream(stream)), new String[0]);
        worldSettingsReader.putSetting(WorldStandardValues.naturalRegeneration, Boolean.parseBoolean(ConfigFile.readStringFromStream(stream)), new String[0]);
        worldSettingsReader.putSetting(WorldStandardValues.randomTickSpeed, Integer.parseInt(ConfigFile.readStringFromStream(stream)), new String[0]);
        worldSettingsReader.putSetting(WorldStandardValues.reducedDebugInfo, Boolean.parseBoolean(ConfigFile.readStringFromStream(stream)), new String[0]);
        worldSettingsReader.putSetting(WorldStandardValues.sendCommandFeedback, Boolean.parseBoolean(ConfigFile.readStringFromStream(stream)), new String[0]);
        worldSettingsReader.putSetting(WorldStandardValues.showDeathMessages, Boolean.parseBoolean(ConfigFile.readStringFromStream(stream)), new String[0]);
        worldSettingsReader.putSetting(WorldStandardValues.spawnRadius, Integer.parseInt(ConfigFile.readStringFromStream(stream)), new String[0]);
        worldSettingsReader.putSetting(WorldStandardValues.spectatorsGenerateChunks, Boolean.parseBoolean(ConfigFile.readStringFromStream(stream)), new String[0]);
        worldSettingsReader.putSetting(WorldStandardValues.welcomeMessage, ConfigFile.readStringFromStream(stream), new String[0]);
        worldSettingsReader.putSetting(WorldStandardValues.departMessage, ConfigFile.readStringFromStream(stream), new String[0]);
        worldSettingsReader.putSetting(WorldStandardValues.hasSkyLight, stream.readBoolean(), new String[0]);
        worldSettingsReader.putSetting(WorldStandardValues.isSurfaceWorld, stream.readBoolean(), new String[0]);
        worldSettingsReader.putSetting(WorldStandardValues.canRespawnHere, stream.readBoolean(), new String[0]);
        worldSettingsReader.putSetting(WorldStandardValues.doesWaterVaporize, stream.readBoolean(), new String[0]);
        worldSettingsReader.putSetting(WorldStandardValues.doesXZShowFog, stream.readBoolean(), new String[0]);
        worldSettingsReader.putSetting(WorldStandardValues.useCustomFogColor, stream.readBoolean(), new String[0]);
        worldSettingsReader.putSetting(WorldStandardValues.fogColorRed, stream.readDouble(), new String[0]);
        worldSettingsReader.putSetting(WorldStandardValues.fogColorGreen, stream.readDouble(), new String[0]);
        worldSettingsReader.putSetting(WorldStandardValues.fogColorBlue, stream.readDouble(), new String[0]);
        worldSettingsReader.putSetting(WorldStandardValues.isSkyColored, stream.readBoolean(), new String[0]);
        worldSettingsReader.putSetting(WorldStandardValues.cloudHeight, stream.readInt(), new String[0]);
        worldSettingsReader.putSetting(WorldStandardValues.canDoLightning, stream.readBoolean(), new String[0]);
        worldSettingsReader.putSetting(WorldStandardValues.canDoRainSnowIce, stream.readBoolean(), new String[0]);
        worldSettingsReader.putSetting(WorldStandardValues.isNightWorld, stream.readBoolean(), new String[0]);
        worldSettingsReader.putSetting(WorldStandardValues.voidFogYFactor, stream.readDouble(), new String[0]);
        worldSettingsReader.putSetting(WorldStandardValues.gravityFactor, stream.readDouble(), new String[0]);
        worldSettingsReader.putSetting(WorldStandardValues.shouldMapSpin, stream.readBoolean(), new String[0]);
        worldSettingsReader.putSetting(WorldStandardValues.canDropChunk, stream.readBoolean(), new String[0]);
        worldSettingsReader.putSetting(WorldStandardValues.RESPAWN_DIMENSION, stream.readInt(), new String[0]);
        worldSettingsReader.putSetting(WorldStandardValues.MOVEMENT_FACTOR, stream.readInt(), new String[0]);
        worldSettingsReader.putSetting(WorldStandardValues.ITEMS_TO_ADD_ON_JOIN_DIMENSION, ConfigFile.readStringFromStream(stream), new String[0]);
        worldSettingsReader.putSetting(WorldStandardValues.ITEMS_TO_REMOVE_ON_JOIN_DIMENSION, ConfigFile.readStringFromStream(stream), new String[0]);
        worldSettingsReader.putSetting(WorldStandardValues.ITEMS_TO_ADD_ON_LEAVE_DIMENSION, ConfigFile.readStringFromStream(stream), new String[0]);
        worldSettingsReader.putSetting(WorldStandardValues.ITEMS_TO_REMOVE_ON_LEAVE_DIMENSION, ConfigFile.readStringFromStream(stream), new String[0]);
        worldSettingsReader.putSetting(WorldStandardValues.ITEMS_TO_ADD_ON_RESPAWN, ConfigFile.readStringFromStream(stream), new String[0]);
        worldSettingsReader.putSetting(WorldStandardValues.SPAWN_POINT_SET, stream.readBoolean(), new String[0]);
        worldSettingsReader.putSetting(WorldStandardValues.SPAWN_POINT_X, stream.readInt(), new String[0]);
        worldSettingsReader.putSetting(WorldStandardValues.SPAWN_POINT_Y, stream.readInt(), new String[0]);
        worldSettingsReader.putSetting(WorldStandardValues.SPAWN_POINT_Z, stream.readInt(), new String[0]);
        worldSettingsReader.putSetting(WorldStandardValues.PLAYERS_CAN_BREAK_BLOCKS, stream.readBoolean(), new String[0]);
        worldSettingsReader.putSetting(WorldStandardValues.EXPLOSIONS_CAN_BREAK_BLOCKS, stream.readBoolean(), new String[0]);
        worldSettingsReader.putSetting(WorldStandardValues.PLAYERS_CAN_PLACE_BLOCKS, stream.readBoolean(), new String[0]);
        this.worldConfig = new WorldConfig(new File("."), worldSettingsReader, world);
        int count = stream.readInt();
        while (count-- > 0) {
            String biomeName = ConfigFile.readStringFromStream(stream);
            id = stream.readInt();
            this.worldConfig.customBiomeGenerationIds.put(biomeName, id);
        }
        StandardBiomeTemplate defaultSettings = new StandardBiomeTemplate(this.worldConfig.worldHeightCap);
        this.biomes = new LocalBiome[world.getMaxBiomesCount()];
        count = stream.readInt();
        while (count-- > 0) {
            LocalBiome biome;
            id = stream.readInt();
            String biomeName = ConfigFile.readStringFromStream(stream);
            SimpleSettingsMap biomeReader = new SimpleSettingsMap(biomeName, false);
            biomeReader.putSetting(BiomeStandardValues.BIOME_TEMPERATURE, Float.valueOf(stream.readFloat()), new String[0]);
            biomeReader.putSetting(BiomeStandardValues.BIOME_WETNESS, Float.valueOf(stream.readFloat()), new String[0]);
            biomeReader.putSetting(BiomeStandardValues.SKY_COLOR, stream.readInt(), new String[0]);
            biomeReader.putSetting(BiomeStandardValues.WATER_COLOR, stream.readInt(), new String[0]);
            biomeReader.putSetting(BiomeStandardValues.GRASS_COLOR, stream.readInt(), new String[0]);
            biomeReader.putSetting(BiomeStandardValues.GRASS_COLOR_IS_MULTIPLIER, stream.readBoolean(), new String[0]);
            biomeReader.putSetting(BiomeStandardValues.FOLIAGE_COLOR, stream.readInt(), new String[0]);
            biomeReader.putSetting(BiomeStandardValues.FOLIAGE_COLOR_IS_MULTIPLIER, stream.readBoolean(), new String[0]);
            String biomeDictId = ConfigFile.readStringFromStream(stream);
            biomeReader.putSetting(BiomeStandardValues.BIOME_DICT_ID, biomeDictId, new String[0]);
            BiomeLoadInstruction instruction = new BiomeLoadInstruction(biomeName, id, defaultSettings);
            BiomeConfig config = new BiomeConfig(instruction, null, biomeReader, this.worldConfig);
            this.biomes[id] = biome = world.createBiomeFor(config, new BiomeIds(id), this);
        }
    }

    @Override
    public WorldConfig getWorldConfig() {
        return this.worldConfig;
    }

    @Override
    public LocalBiome getBiomeByIdOrNull(int id) {
        if (id < 0 || id > this.biomes.length) {
            return null;
        }
        return this.biomes[id];
    }

    @Override
    public void reload() {
    }

    @Override
    public LocalBiome[] getBiomeArray() {
        return this.biomes;
    }
}

