/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.configuration;

import com.pg85.otg.LocalBiome;
import com.pg85.otg.LocalWorld;
import com.pg85.otg.OTG;
import com.pg85.otg.configuration.BiomeGroup;
import com.pg85.otg.logging.LogMarker;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public final class BiomeGroupManager {
    public static final int MAX_BIOME_GROUP_COUNT = 127;
    private int cumulativeGroupRarity = 0;
    private Map<String, BiomeGroup> nameToGroup = new LinkedHashMap<String, BiomeGroup>(4);
    private Map<Integer, BiomeGroup> idToGroup = new LinkedHashMap<Integer, BiomeGroup>(4);

    public void registerGroup(BiomeGroup newGroup) {
        if (this.isRoomForMoreGroups()) {
            BiomeGroup existingWithSameName = this.nameToGroup.get(newGroup.getName());
            if (existingWithSameName != null) {
                OTG.log(LogMarker.WARN, "Two biome groups have the same name \"{}\". Removing the second one.", newGroup.getName());
                OTG.printStackTrace(LogMarker.WARN, new Exception());
            } else {
                int newGroupId = this.getNextGroupId();
                newGroup.setGroupId(newGroupId);
                this.nameToGroup.put(newGroup.getName(), newGroup);
                this.idToGroup.put(newGroupId, newGroup);
            }
        } else {
            OTG.log(LogMarker.WARN, "Biome group \"{}\" could not be added. Max biome group count reached.", newGroup.getName());
        }
    }

    private int getNextGroupId() {
        return this.getGroupCount() + 1;
    }

    private boolean isRoomForMoreGroups() {
        return this.getNextGroupId() < 127;
    }

    public BiomeGroup getGroupById(int groupId) {
        return this.idToGroup.get(groupId);
    }

    public BiomeGroup getGroupByName(String name) {
        return this.nameToGroup.get(name);
    }

    public Collection<BiomeGroup> getGroups() {
        return this.idToGroup.values();
    }

    public int getGroupCount() {
        return this.idToGroup.size();
    }

    public boolean hasNoGroups() {
        return this.idToGroup.isEmpty();
    }

    public SortedMap<Integer, BiomeGroup> getGroupDepthMap(int depth) {
        TreeMap<Integer, BiomeGroup> map = new TreeMap<Integer, BiomeGroup>();
        this.cumulativeGroupRarity = 0;
        for (BiomeGroup group : this.getGroups()) {
            if (group.getGenerationDepth() != depth) continue;
            this.cumulativeGroupRarity += group.getGroupRarity();
            map.put(this.cumulativeGroupRarity, group);
        }
        if (this.cumulativeGroupRarity < map.size() * 100) {
            map.put(map.size() * 100, null);
        }
        return map;
    }

    public boolean isGroupDepthMapEmpty(int depth) {
        for (BiomeGroup group : this.getGroups()) {
            if (group.getGenerationDepth() != depth) continue;
            return false;
        }
        return true;
    }

    public SortedMap<Integer, LocalBiome> getBiomeDepthMap(int groupId, int depth) {
        return this.getGroupById(groupId).getDepthMap(depth);
    }

    public boolean isBiomeDepthMapEmpty(int depth) {
        for (BiomeGroup group : this.getGroups()) {
            if (group.getDepthMap(depth).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static int getMaxRarityFromPossibles(Map<Integer, ?> map) {
        Integer[] totalRarity = map.keySet().toArray(new Integer[map.size()]);
        return totalRarity[totalRarity.length - 1];
    }

    public void processBiomeData(LocalWorld world) {
        for (BiomeGroup entry : this.idToGroup.values()) {
            entry.processBiomeData(world);
        }
    }

    public void filterBiomes(Set<String> customBiomeNames) {
        Iterator<BiomeGroup> it = this.idToGroup.values().iterator();
        while (it.hasNext()) {
            BiomeGroup group = it.next();
            group.filterBiomes(customBiomeNames);
            if (!group.hasNoBiomes()) continue;
            it.remove();
        }
    }
}

