/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.bukkit.generator.structures;

import com.pg85.otg.LocalBiome;
import com.pg85.otg.LocalWorld;
import com.pg85.otg.bukkit.BukkitBiome;
import com.pg85.otg.bukkit.util.WorldHelper;
import com.pg85.otg.configuration.BiomeConfig;
import com.pg85.otg.configuration.ServerConfigProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.server.v1_12_R1.BiomeBase;
import net.minecraft.server.v1_12_R1.BlockPosition;
import net.minecraft.server.v1_12_R1.EntityWitch;
import net.minecraft.server.v1_12_R1.StructureGenerator;
import net.minecraft.server.v1_12_R1.StructurePiece;
import net.minecraft.server.v1_12_R1.StructureStart;
import net.minecraft.server.v1_12_R1.World;
import net.minecraft.server.v1_12_R1.WorldGenRegistration;

public class OTGRareBuildingGen
extends StructureGenerator {
    private List<BiomeBase> biomeList;
    private List<BiomeBase.BiomeMeta> mobList = Arrays.asList(new BiomeBase.BiomeMeta(EntityWitch.class, 1, 1, 1));
    private int maxDistanceBetweenScatteredFeatures;
    private int minDistanceBetweenScatteredFeatures;

    public OTGRareBuildingGen(ServerConfigProvider configs) {
        this.biomeList = new ArrayList<BiomeBase>();
        for (LocalBiome biome : configs.getBiomeArray()) {
            if (biome == null || biome.getBiomeConfig().rareBuildingType == BiomeConfig.RareBuildingType.disabled) continue;
            this.biomeList.add(((BukkitBiome)biome).getHandle());
        }
        this.maxDistanceBetweenScatteredFeatures = configs.getWorldConfig().maximumDistanceBetweenRareBuildings;
        this.minDistanceBetweenScatteredFeatures = configs.getWorldConfig().minimumDistanceBetweenRareBuildings - 1;
    }

    public boolean isWitchHutAt(BlockPosition blockposition) {
        StructureStart structurestart = this.c(blockposition);
        if (structurestart != null && structurestart instanceof RareBuildingStart && !structurestart.c().isEmpty()) {
            StructurePiece structurepiece = (StructurePiece)structurestart.c().get(0);
            return structurepiece instanceof WorldGenRegistration.WorldGenWitchHut;
        }
        return false;
    }

    public List<BiomeBase.BiomeMeta> getWitchHutMobs() {
        return this.mobList;
    }

    public BlockPosition getNearestGeneratedFeature(World world, BlockPosition blockposition, boolean flag) {
        this.g = world;
        return OTGRareBuildingGen.a((World)world, (StructureGenerator)this, (BlockPosition)blockposition, (int)this.maxDistanceBetweenScatteredFeatures, (int)(this.minDistanceBetweenScatteredFeatures - 1), (int)14357617, (boolean)false, (int)100, (boolean)flag);
    }

    protected boolean a(int chunkX, int chunkZ) {
        int var3 = chunkX;
        int var4 = chunkZ;
        if (chunkX < 0) {
            chunkX -= this.maxDistanceBetweenScatteredFeatures - 1;
        }
        if (chunkZ < 0) {
            chunkZ -= this.maxDistanceBetweenScatteredFeatures - 1;
        }
        int var5 = chunkX / this.maxDistanceBetweenScatteredFeatures;
        int var6 = chunkZ / this.maxDistanceBetweenScatteredFeatures;
        Random random = this.g.a(var5, var6, 14357617);
        var5 *= this.maxDistanceBetweenScatteredFeatures;
        var6 *= this.maxDistanceBetweenScatteredFeatures;
        if (var3 == (var5 += random.nextInt(this.maxDistanceBetweenScatteredFeatures - this.minDistanceBetweenScatteredFeatures + 1)) && var4 == (var6 += random.nextInt(this.maxDistanceBetweenScatteredFeatures - this.minDistanceBetweenScatteredFeatures + 1))) {
            BiomeBase biomeAtPosition = this.g.getWorldChunkManager().getBiome(new BlockPosition(var3 * 16 + 8, 0, var4 * 16 + 8));
            for (BiomeBase biome : this.biomeList) {
                if (!biomeAtPosition.equals(biome)) continue;
                return true;
            }
        }
        return false;
    }

    protected StructureStart b(int chunkX, int chunkZ) {
        return new RareBuildingStart(this.g, this.f, chunkX, chunkZ);
    }

    public String a() {
        return "OTGTemple";
    }

    public static class RareBuildingStart
    extends StructureStart {
        public RareBuildingStart(World world, Random random, int chunkX, int chunkZ) {
            WorldGenRegistration.WorldGenPyramidPiece building;
            LocalWorld localWorld = WorldHelper.toLocalWorld(world);
            BiomeConfig biomeConfig = localWorld.getBiome(chunkX * 16 + 8, chunkZ * 16 + 8).getBiomeConfig();
            switch (biomeConfig.rareBuildingType) {
                case desertPyramid: {
                    building = new WorldGenRegistration.WorldGenPyramidPiece(random, chunkX * 16, chunkZ * 16);
                    break;
                }
                case jungleTemple: {
                    building = new WorldGenRegistration.WorldGenJungleTemple(random, chunkX * 16, chunkZ * 16);
                    break;
                }
                case swampHut: {
                    building = new WorldGenRegistration.WorldGenWitchHut(random, chunkX * 16, chunkZ * 16);
                    break;
                }
                case igloo: {
                    building = new WorldGenRegistration.b(random, chunkX * 16, chunkZ * 16);
                    break;
                }
                default: {
                    building = null;
                }
            }
            if (building != null) {
                this.a.add(building);
            }
            this.d();
        }

        public RareBuildingStart() {
        }
    }
}

