/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.bukkit.generator;

import com.pg85.otg.bukkit.BukkitWorld;
import com.pg85.otg.bukkit.OTGPlugin;
import com.pg85.otg.bukkit.generator.BukkitChunkBuffer;
import com.pg85.otg.bukkit.generator.OTGBlockPopulator;
import com.pg85.otg.configuration.WorldConfig;
import com.pg85.otg.generator.ChunkProviderOTG;
import com.pg85.otg.generator.ObjectSpawner;
import com.pg85.otg.util.ChunkCoordinate;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.ChunkGenerator;

public class OTGChunkGenerator
extends ChunkGenerator {
    private ChunkProviderOTG chunkProviderTC;
    private ArrayList<BlockPopulator> BlockPopulator = new ArrayList();
    private boolean NotGenerate = false;
    private OTGPlugin plugin;

    public OTGChunkGenerator(OTGPlugin _plugin) {
        this.plugin = _plugin;
    }

    private void makeSureWorldIsInitialized(World world) {
        if (this.chunkProviderTC == null) {
            this.plugin.onWorldInit(world);
        }
    }

    public void onInitialize(BukkitWorld _world) {
        this.chunkProviderTC = new ChunkProviderOTG(_world.getConfigs(), _world);
        WorldConfig.TerrainMode mode = _world.getConfigs().getWorldConfig().ModeTerrain;
        if (mode == WorldConfig.TerrainMode.Normal || mode == WorldConfig.TerrainMode.OldGenerator) {
            this.BlockPopulator.add(new OTGBlockPopulator(_world));
        }
        if (mode == WorldConfig.TerrainMode.NotGenerate) {
            this.NotGenerate = true;
        }
    }

    public ObjectSpawner getObjectSpawner() {
        if (this.chunkProviderTC == null) {
            throw new RuntimeException();
        }
        return ((OTGBlockPopulator)this.BlockPopulator.get(0)).getObjectSpawner();
    }

    public List<BlockPopulator> getDefaultPopulators(World world) {
        this.makeSureWorldIsInitialized(world);
        return this.BlockPopulator;
    }

    public boolean canSpawn(World world, int x, int z) {
        this.makeSureWorldIsInitialized(world);
        Material material = world.getHighestBlockAt(x, z).getType();
        return material.isSolid();
    }

    public ChunkGenerator.ChunkData generateChunkData(World world, Random random, int chunkX, int chunkZ, ChunkGenerator.BiomeGrid biome) {
        this.makeSureWorldIsInitialized(world);
        ChunkGenerator.ChunkData chunkData = this.createChunkData(world);
        if (this.NotGenerate) {
            return chunkData;
        }
        ChunkCoordinate chunkCoord = ChunkCoordinate.fromChunkCoords(chunkX, chunkZ);
        BukkitChunkBuffer chunkBuffer = new BukkitChunkBuffer(chunkCoord, chunkData);
        this.chunkProviderTC.generate(chunkBuffer);
        return chunkData;
    }
}

