/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg;

import com.pg85.otg.LocalWorld;
import com.pg85.otg.customobjects.CustomObjectStructure;
import com.pg85.otg.customobjects.bo3.BO3;
import com.pg85.otg.customobjects.bo3.ModDataFunction;
import com.pg85.otg.customobjects.bo3.ParticleFunction;
import com.pg85.otg.customobjects.bo3.SpawnerFunction;
import com.pg85.otg.util.ChunkCoordinate;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class WorldSession {
    protected LocalWorld world;

    public WorldSession(LocalWorld world) {
        this.world = world;
    }

    public abstract ArrayList<ParticleFunction> getParticleFunctions();

    public abstract int getWorldBorderRadius();

    public abstract ChunkCoordinate getWorldBorderCenterPoint();

    public abstract int getPregenerationRadius();

    public abstract int setPregenerationRadius(int var1);

    public abstract ChunkCoordinate getPreGeneratorCenterPoint();

    public abstract int getPregeneratedBorderLeft();

    public abstract int getPregeneratedBorderRight();

    public abstract int getPregeneratedBorderTop();

    public abstract int getPregeneratedBorderBottom();

    public abstract boolean getPreGeneratorIsRunning();

    public String GetStructureInfoAt(double x, double z) {
        CustomObjectStructure worldInfoChunk;
        String structureInfo = "";
        ChunkCoordinate playerChunk = ChunkCoordinate.fromBlockCoords((int)x, (int)z);
        if (this.world.getStructureCache().worldInfoChunks.containsKey(playerChunk) && (worldInfoChunk = this.world.getStructureCache().worldInfoChunks.get(playerChunk)) != null) {
            structureInfo = structureInfo + "-- BO3 Info -- \r\nName: " + ((BO3)worldInfoChunk.Start.getObject()).getSettings().getName().replace("Start", "") + "\r\nAuthor: " + ((BO3)worldInfoChunk.Start.getObject()).getSettings().author + "\r\nDescription: " + ((BO3)worldInfoChunk.Start.getObject()).getSettings().description;
            String branchesInChunk = worldInfoChunk.ObjectsToSpawnInfo.get(playerChunk);
            if (branchesInChunk != null && branchesInChunk.length() > 0) {
                structureInfo = structureInfo + "\r\n" + branchesInChunk;
            }
        }
        return structureInfo;
    }

    public HashMap<String, ArrayList<ModDataFunction>> GetModDataForChunk(ChunkCoordinate chunkCoord) {
        HashMap<String, ArrayList<ModDataFunction>> result = new HashMap<String, ArrayList<ModDataFunction>>();
        boolean bFound = false;
        if (this.world.IsInsideWorldBorder(chunkCoord, true)) {
            CustomObjectStructure worldInfoChunk;
            if (this.world.getStructureCache().worldInfoChunks.containsKey(chunkCoord) && (worldInfoChunk = this.world.getStructureCache().worldInfoChunks.get(chunkCoord)) != null) {
                for (ModDataFunction modData : worldInfoChunk.modData) {
                    if (!ChunkCoordinate.fromBlockCoords(modData.x, modData.z).equals(chunkCoord)) continue;
                    if (!result.containsKey(modData.modId)) {
                        result.put(modData.modId, new ArrayList());
                    }
                    result.get(modData.modId).add(modData);
                }
                bFound = true;
            }
            if (!(bFound || this.world.IsInsidePregeneratedRegion(chunkCoord, true) || this.world.getConfigs().getWorldConfig().IsOTGPlus && this.world.getStructureCache().structureCache.containsKey(chunkCoord))) {
                result = null;
            }
        }
        return result;
    }

    public ArrayList<SpawnerFunction> GetSpawnersForChunk(ChunkCoordinate chunkCoord) {
        ArrayList<SpawnerFunction> result = new ArrayList<SpawnerFunction>();
        boolean bFound = false;
        if (this.world.IsInsideWorldBorder(chunkCoord, true)) {
            if (this.world.getStructureCache().worldInfoChunks.containsKey(chunkCoord)) {
                CustomObjectStructure worldInfoChunk = this.world.getStructureCache().worldInfoChunks.get(chunkCoord);
                if (worldInfoChunk != null) {
                    for (SpawnerFunction spawnerData : worldInfoChunk.spawnerData) {
                        if (!ChunkCoordinate.fromBlockCoords(spawnerData.x, spawnerData.z).equals(chunkCoord)) continue;
                        result.add(spawnerData);
                    }
                }
                bFound = true;
            }
            if (!(bFound || this.world.IsInsidePregeneratedRegion(chunkCoord, true) || this.world.getConfigs().getWorldConfig().IsOTGPlus && this.world.getStructureCache().structureCache.containsKey(chunkCoord))) {
                result = null;
            }
        }
        return result;
    }

    public ArrayList<ParticleFunction> GetParticlesForChunk(ChunkCoordinate chunkCoord) {
        ArrayList<ParticleFunction> result = new ArrayList<ParticleFunction>();
        boolean bFound = false;
        if (this.world.IsInsideWorldBorder(chunkCoord, true)) {
            if (this.world.getStructureCache().worldInfoChunks.containsKey(chunkCoord)) {
                CustomObjectStructure worldInfoChunk = this.world.getStructureCache().worldInfoChunks.get(chunkCoord);
                if (worldInfoChunk != null) {
                    for (ParticleFunction particleData : worldInfoChunk.particleData) {
                        if (!ChunkCoordinate.fromBlockCoords(particleData.x, particleData.z).equals(chunkCoord)) continue;
                        result.add(particleData);
                    }
                }
                bFound = true;
            }
            if (!(bFound || this.world.IsInsidePregeneratedRegion(chunkCoord, true) || this.world.getConfigs().getWorldConfig().IsOTGPlus && this.world.getStructureCache().structureCache.containsKey(chunkCoord))) {
                result = null;
            }
        }
        return result;
    }

    public void RemoveParticles(ChunkCoordinate chunkCoord, ParticleFunction particle) {
        CustomObjectStructure customObject;
        if (this.world.IsInsideWorldBorder(chunkCoord, true) && (customObject = this.world.getStructureCache().worldInfoChunks.get(chunkCoord)) != null && customObject.particleData.contains(particle)) {
            customObject.particleData.remove(particle);
        }
    }
}

