/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg;

import com.pg85.otg.LocalBiome;
import com.pg85.otg.LocalMaterialData;
import com.pg85.otg.LocalWorld;
import com.pg85.otg.OTGEngine;
import com.pg85.otg.configuration.ConfigFunctionsManager;
import com.pg85.otg.configuration.CustomObjectConfigFunctionsManager;
import com.pg85.otg.configuration.PluginConfig;
import com.pg85.otg.customobjects.CustomObject;
import com.pg85.otg.customobjects.CustomObjectManager;
import com.pg85.otg.events.EventHandler;
import com.pg85.otg.events.EventPriority;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.generator.biome.BiomeModeManager;
import com.pg85.otg.generator.resource.Resource;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.minecraftTypes.DefaultMaterial;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;

public class OTG {
    public static boolean isForge = false;
    private static OTGEngine engine;
    public static final int SUPPORTED_BLOCK_IDS = 65535;
    public static final int WORLD_DEPTH = 0;
    public static final int WORLD_HEIGHT = 256;
    static HashMap<String, LocalMaterialData> cachedMaterials;

    public static boolean fireCanCustomObjectSpawnEvent(CustomObject object, LocalWorld world, int x, int y, int z) {
        return engine.fireCanCustomObjectSpawnEvent(object, world, x, y, z);
    }

    public static void firePopulationEndEvent(LocalWorld world, Random random, boolean villageInChunk, ChunkCoordinate chunkCoord) {
        engine.firePopulationEndEvent(world, random, villageInChunk, chunkCoord);
    }

    public static void firePopulationStartEvent(LocalWorld world, Random random, boolean villageInChunk, ChunkCoordinate chunkCoord) {
        engine.firePopulationStartEvent(world, random, villageInChunk, chunkCoord);
    }

    public static boolean fireResourceProcessEvent(Resource resource, LocalWorld world, Random random, boolean villageInChunk, int chunkX, int chunkZ) {
        return engine.fireResourceProcessEvent(resource, world, random, villageInChunk, chunkX, chunkZ);
    }

    public static BiomeModeManager getBiomeModeManager() {
        return engine.getBiomeModeManager();
    }

    public static ConfigFunctionsManager getConfigFunctionsManager() {
        return engine.getConfigFunctionsManager();
    }

    public static CustomObjectConfigFunctionsManager getCustomObjectConfigFunctionsManager() {
        return engine.getCustomObjectConfigFunctionsManager();
    }

    public static CustomObjectManager getCustomObjectManager() {
        return engine.getCustomObjectManager();
    }

    public static OTGEngine getEngine() {
        return engine;
    }

    public static LocalMaterialData readMaterial(String name) throws InvalidConfigException {
        LocalMaterialData material = cachedMaterials.get(name);
        if (material != null) {
            return material;
        }
        if (cachedMaterials.containsKey(material)) {
            throw new InvalidConfigException("Cannot read block: " + name);
        }
        if (name.toLowerCase().equals("snow")) {
            name = "SNOW_LAYER";
        }
        if (name.toLowerCase().equals("water")) {
            name = "FLOWING_WATER";
        }
        if (name.toLowerCase().equals("lava")) {
            name = "FLOWING_LAVA";
        }
        try {
            material = engine.readMaterial(name);
        }
        catch (InvalidConfigException ex) {
            cachedMaterials.put(name, null);
            throw ex;
        }
        cachedMaterials.put(name, material);
        return material;
    }

    public static LocalMaterialData toLocalMaterialData(DefaultMaterial defaultMaterial, int blockData) {
        return engine.toLocalMaterialData(defaultMaterial, blockData);
    }

    public static PluginConfig getPluginConfig() {
        return engine.getPluginConfig();
    }

    public static LocalWorld getWorld(String name) {
        return engine.getWorld(name);
    }

    public static LocalWorld getUnloadedWorld(String name) {
        return engine.getUnloadedWorld(name);
    }

    public static String getBiomeName(String worldName, int x, int z) {
        LocalWorld world = OTG.getWorld(worldName);
        if (world == null) {
            return null;
        }
        return world.getSavedBiome(x, z).getName();
    }

    public static LocalBiome getBiomeAllWorlds(int id) {
        ArrayList<LocalWorld> worlds = OTG.getAllWorlds();
        if (worlds != null) {
            for (LocalWorld world : worlds) {
                LocalBiome biome = world.getBiomeByIdOrNull(id);
                if (biome == null) continue;
                return biome;
            }
        }
        return null;
    }

    public static LocalBiome getBiomeAllWorlds(String name) {
        ArrayList<LocalWorld> worlds = OTG.getAllWorlds();
        if (worlds != null) {
            for (LocalWorld world : worlds) {
                LocalBiome biome = world.getBiomeByNameOrNull(name);
                if (biome == null) continue;
                return biome;
            }
        }
        return null;
    }

    public static ArrayList<LocalWorld> getAllWorlds() {
        return engine.getAllWorlds();
    }

    public static void log(LogMarker level, List<String> messages) {
        engine.getLogger().log(level, messages);
    }

    public static void log(LogMarker level, String message, Object ... params) {
        engine.getLogger().log(level, message, params);
    }

    public static void logIfLevel(LogMarker ifLevel, List<String> messages) {
        engine.getLogger().logIfLevel(ifLevel, messages);
    }

    public static void logIfLevel(LogMarker ifLevel, String message, Object ... params) {
        engine.getLogger().logIfLevel(ifLevel, message, params);
    }

    public static void logIfLevel(LogMarker min, LogMarker max, List<String> messages) {
        engine.getLogger().logIfLevel(min, max, messages);
    }

    public static void logIfLevel(LogMarker min, LogMarker max, String message, Object ... params) {
        engine.getLogger().logIfLevel(min, max, message, params);
    }

    public static void printStackTrace(LogMarker level, Throwable e) {
        OTG.printStackTrace(level, e, Integer.MAX_VALUE);
    }

    public static void printStackTrace(LogMarker level, Throwable e, int maxDepth) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        e.printStackTrace(printWriter);
        engine.getLogger().log(level, stringWriter.toString(), new Object[0]);
    }

    public static void registerEventHandler(EventHandler handler) {
        engine.registerEventHandler(handler);
    }

    public static void registerEventHandler(EventHandler handler, EventPriority priority) {
        engine.registerEventHandler(handler, priority);
    }

    public static void setEngine(OTGEngine engine) {
        if (OTG.engine != null) {
            throw new IllegalStateException("Engine is already set.");
        }
        OTG.engine = engine;
        engine.onStart();
    }

    public static void stopEngine() {
        engine.onShutdown();
        engine = null;
    }

    private OTG() {
    }

    static {
        cachedMaterials = new HashMap();
    }
}

