/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.rewardtype;

import chanceCubes.rewards.rewardparts.OffsetBlock;
import chanceCubes.rewards.rewardtype.IRewardType;
import chanceCubes.util.CustomSchematic;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import java.util.ArrayList;
import net.minecraft.block.BlockAir;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class SchematicRewardType
implements IRewardType {
    private CustomSchematic schematic;

    public SchematicRewardType(CustomSchematic schematic) {
        this.schematic = schematic;
    }

    @Override
    public void trigger(final World world, final int x, final int y, final int z, final EntityPlayer player) {
        final ArrayList<OffsetBlock> stack = new ArrayList<OffsetBlock>();
        for (OffsetBlock osb : this.schematic.getBlocks()) {
            if (!this.schematic.includeAirBlocks() && osb.getBlockState().func_177230_c().equals(Blocks.field_150350_a)) continue;
            stack.add(osb);
        }
        Scheduler.scheduleTask(new Task("Schematic_Spawn_Delay", this.schematic.getDelay()){

            @Override
            public void callback() {
                Scheduler.scheduleTask(new Task("Schematic_Reward_Block_Spawn", -1, SchematicRewardType.this.schematic.getSpacingDelay() < 1.0f ? 1 : (int)SchematicRewardType.this.schematic.getSpacingDelay()){

                    @Override
                    public void callback() {
                    }

                    @Override
                    public void update() {
                        float lessThan1 = 0.0f;
                        while (lessThan1 < 1.0f && !stack.isEmpty()) {
                            BlockPos pos;
                            OffsetBlock osb = (OffsetBlock)stack.remove(0);
                            if (SchematicRewardType.this.schematic.isRelativeToPlayer()) {
                                pos = new BlockPos((int)Math.floor(player.field_70165_t) + osb.xOff.getIntValue(), (int)Math.floor(player.field_70163_u) + osb.yOff.getIntValue(), (int)Math.floor(player.field_70161_v) + osb.zOff.getIntValue());
                                if (world.func_180495_p(pos).func_177230_c().isAir(world.func_180495_p(pos), (IBlockAccess)world, pos) && osb.getBlockState().func_177230_c() instanceof BlockAir) continue;
                                osb.spawnInWorld(world, (int)Math.floor(player.field_70165_t), (int)Math.floor(player.field_70163_u), (int)Math.floor(player.field_70161_v));
                            } else {
                                pos = new BlockPos(x + osb.xOff.getIntValue(), y + osb.yOff.getIntValue(), z + osb.zOff.getIntValue());
                                if (world.func_180495_p(pos).func_177230_c().isAir(world.func_180495_p(pos), (IBlockAccess)world, pos) && osb.getBlockState().func_177230_c() instanceof BlockAir) continue;
                                osb.spawnInWorld(world, x, y, z);
                            }
                            lessThan1 += SchematicRewardType.this.schematic.getSpacingDelay();
                            if (stack.size() != 0) continue;
                            lessThan1 = 1.0f;
                        }
                        if (stack.size() == 0) {
                            Scheduler.removeTask(this);
                        }
                    }
                });
            }
        });
    }
}

