/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.registry;

import chanceCubes.CCubesCore;
import chanceCubes.config.CCubesSettings;
import chanceCubes.config.ConfigLoader;
import chanceCubes.profiles.ProfileManager;
import chanceCubes.registry.IRewardRegistry;
import chanceCubes.rewards.IChanceCubeReward;
import chanceCubes.rewards.defaultRewards.BasicReward;
import chanceCubes.rewards.giantRewards.BeaconArenaReward;
import chanceCubes.rewards.giantRewards.BioDomeReward;
import chanceCubes.rewards.giantRewards.BlockInfectionReward;
import chanceCubes.rewards.giantRewards.BlockThrowerReward;
import chanceCubes.rewards.giantRewards.ChunkFlipReward;
import chanceCubes.rewards.giantRewards.ChunkReverserReward;
import chanceCubes.rewards.giantRewards.FireworkShowReward;
import chanceCubes.rewards.giantRewards.FloorIsLavaReward;
import chanceCubes.rewards.giantRewards.FluidSphereReward;
import chanceCubes.rewards.giantRewards.MixedFluidSphereReward;
import chanceCubes.rewards.giantRewards.OrePillarReward;
import chanceCubes.rewards.giantRewards.OreSphereReward;
import chanceCubes.rewards.giantRewards.PotionsReward;
import chanceCubes.rewards.giantRewards.RandomExplosionReward;
import chanceCubes.rewards.giantRewards.SphereSnakeReward;
import chanceCubes.rewards.giantRewards.TNTSlingReward;
import chanceCubes.rewards.giantRewards.ThrowablesReward;
import chanceCubes.rewards.rewardtype.SchematicRewardType;
import chanceCubes.util.RewardData;
import chanceCubes.util.SchematicUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;

public class GiantCubeRegistry
implements IRewardRegistry {
    public static GiantCubeRegistry INSTANCE = new GiantCubeRegistry();
    private Map<String, IChanceCubeReward> nameToReward = Maps.newHashMap();
    private List<IChanceCubeReward> sortedRewards = Lists.newArrayList();

    public static void loadDefaultRewards() {
        if (!CCubesSettings.enableHardCodedRewards) {
            return;
        }
        INSTANCE.registerReward(new BasicReward("chancecubes:Village", 0, new SchematicRewardType(SchematicUtil.loadCustomSchematic(RewardData.getVillageSchematic(), 0, -1, 0, 0.1f, false, false, false, true, 0))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Woodland_Mansion", 0, new SchematicRewardType(SchematicUtil.loadCustomSchematic(RewardData.getWoodlandMansionSchematic(), 0, -1, 0, 0.05f, false, false, true, true, 0))));
        INSTANCE.registerReward(new BioDomeReward());
        INSTANCE.registerReward(new TNTSlingReward());
        INSTANCE.registerReward(new ThrowablesReward());
        INSTANCE.registerReward(new OrePillarReward());
        INSTANCE.registerReward(new ChunkReverserReward());
        INSTANCE.registerReward(new FloorIsLavaReward());
        INSTANCE.registerReward(new ChunkFlipReward());
        INSTANCE.registerReward(new OreSphereReward());
        INSTANCE.registerReward(new PotionsReward());
        INSTANCE.registerReward(new FluidSphereReward());
        INSTANCE.registerReward(new MixedFluidSphereReward());
        INSTANCE.registerReward(new FireworkShowReward());
        INSTANCE.registerReward(new SphereSnakeReward());
        INSTANCE.registerReward(new RandomExplosionReward());
        INSTANCE.registerReward(new BeaconArenaReward());
        INSTANCE.registerReward(new BlockInfectionReward());
        INSTANCE.registerReward(new BlockThrowerReward());
    }

    @Override
    public void registerReward(IChanceCubeReward reward) {
        if (ConfigLoader.config.getBoolean(reward.getName(), "Giant Chance Cube Rewards", true, "") && !this.nameToReward.containsKey(reward.getName())) {
            this.nameToReward.put(reward.getName(), reward);
            this.redoSort(reward);
        }
    }

    @Override
    public boolean unregisterReward(String name) {
        IChanceCubeReward reward = this.nameToReward.remove(name);
        if (reward != null) {
            return this.sortedRewards.remove(reward);
        }
        return false;
    }

    @Override
    public IChanceCubeReward getRewardByName(String name) {
        return this.nameToReward.get(name);
    }

    @Override
    public void triggerRandomReward(World world, BlockPos pos, EntityPlayer player, int chance) {
        if (pos == null) {
            return;
        }
        if (this.sortedRewards.size() == 0) {
            CCubesCore.logger.log(Level.WARN, "There are no registered rewards with the Giant Chance Cubes and no reward was able to be given");
            return;
        }
        int pick = world.field_73012_v.nextInt(this.sortedRewards.size());
        CCubesCore.logger.log(Level.INFO, "Triggered the reward with the name of: " + this.sortedRewards.get(pick).getName());
        this.triggerReward(this.sortedRewards.get(pick), world, pos, player);
    }

    @Override
    public void triggerReward(IChanceCubeReward reward, World world, BlockPos pos, EntityPlayer player) {
        Map<String, Object> settings = ProfileManager.getRewardSpawnSettings(reward);
        reward.trigger(world, pos, player, settings);
    }

    private void redoSort(@Nullable IChanceCubeReward newReward) {
        if (newReward != null) {
            this.sortedRewards.add(newReward);
        }
        this.sortedRewards.sort((o1, o2) -> o1.getChanceValue() - o2.getChanceValue());
    }

    public void ClearRewards() {
        this.sortedRewards.clear();
        this.nameToReward.clear();
    }
}

