/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.files.loading;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import java.util.Arrays;
import org.apache.commons.io.FilenameUtils;

public class FileSuffixFilter
implements DirectoryStream.Filter<Path>,
FilenameFilter {
    private Iterable<String> acceptedSuffixes;

    public FileSuffixFilter(Iterable<String> acceptedSuffixes) {
        this.acceptedSuffixes = acceptedSuffixes;
    }

    public FileSuffixFilter(String ... acceptedSuffixes) {
        this(Arrays.asList(acceptedSuffixes));
    }

    @Override
    public boolean accept(Path entry) throws IOException {
        return this.accept(entry.getFileName().toString());
    }

    @Override
    public boolean accept(File dir, String name) {
        return this.accept(name);
    }

    @Override
    protected boolean accept(String name) {
        for (String s : this.acceptedSuffixes) {
            if (!FilenameUtils.isExtension((String)name, (String)s)) continue;
            return true;
        }
        return false;
    }
}

