/*
 * Decompiled with CFR 0.152.
 */
package com.gr8pefish.portablecrafting.util;

import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class NBTHelper {
    public static boolean hasUUID(ItemStack itemStack) {
        return NBTHelper.has_tag(itemStack, "MostSigUUID") && NBTHelper.has_tag(itemStack, "LeastSigUUID");
    }

    public static void setUUID(ItemStack itemStack) {
        NBTHelper.initNBTCompound(itemStack);
        if (!NBTHelper.hasUUID(itemStack)) {
            UUID itemUUID = UUID.randomUUID();
            NBTHelper.setLong(itemStack, "MostSigUUID", itemUUID.getMostSignificantBits());
            NBTHelper.setLong(itemStack, "LeastSigUUID", itemUUID.getLeastSignificantBits());
        }
    }

    public static UUID getUUID(ItemStack itemStack) {
        NBTHelper.initNBTCompound(itemStack);
        if (NBTHelper.hasUUID(itemStack)) {
            return new UUID(itemStack.func_77978_p().func_74763_f("MostSigUUID"), itemStack.func_77978_p().func_74763_f("LeastSigUUID"));
        }
        return null;
    }

    public static void initNBTCompound(ItemStack itemStack) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
    }

    public static boolean has_tag(ItemStack itemStack, String tag) {
        return itemStack != null && !itemStack.func_190926_b() && itemStack.func_77942_o() && itemStack.func_77978_p().func_74764_b(tag);
    }

    public static void setLong(ItemStack itemStack, String tag, Long value) {
        NBTHelper.initNBTCompound(itemStack);
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        tagCompound.func_74772_a(tag, value.longValue());
    }
}

