/*
 * Decompiled with CFR 0.152.
 */
package pegbeard.dungeontactics.items.books;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemWritableBook;
import net.minecraft.item.ItemWrittenBook;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSetSlot;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pegbeard.dungeontactics.DungeonTactics;
import pegbeard.dungeontactics.handlers.DTConfigHandler;
import pegbeard.dungeontactics.handlers.DTCreativeTab;

public class DTDungeonpediaBook7
extends ItemWrittenBook {
    public DTDungeonpediaBook7(String name) {
        this.setRegistryName("dungeontactics", name);
        this.func_77655_b(this.getRegistryName().toString());
        this.func_77637_a(DTCreativeTab.DT_TAB);
        ItemStack book = new ItemStack(Items.field_151099_bA);
        this.populatePages(book);
    }

    private void populatePages(ItemStack stack) {
        NBTTagCompound tag = new NBTTagCompound();
        stack.func_77982_d(tag);
        NBTTagList bookPages = new NBTTagList();
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("pages")) {
            stack.func_190919_e("pages");
        }
        tag.func_74782_a("pages", (NBTBase)bookPages);
        if (DTConfigHandler.configuration.get("1-Feature", "Seasonal Events", true).getBoolean(true) && DungeonTactics.fools) {
            tag.func_74778_a("author", "\u00ef\u00bf\u00bdkMoomin");
            tag.func_74778_a("title", "Super Useful Guidebook");
            bookPages.func_74742_a((NBTBase)new NBTTagString("\"\n\n\u00ef\u00bf\u00bdl     Book of All\n\n\u00ef\u00bf\u00bdl     Knowledge\n\n\u00ef\u00bf\u00bdl     Volume \u00ef\u00bf\u00bdk999\""));
            bookPages.func_74742_a((NBTBase)new NBTTagString("\"\nThis immense collection of books contains all knowledge of life, there-after, and the universe.\""));
            bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdkIf you can read this, you are cheating ;) Happy April Fools Day abcd efg hijk lmnop qrs tuv wxy and z 42\u00ef\u00bf\u00bdr.....\n\n*The ink has run and the words are completely illegible.*\""));
            return;
        }
        tag.func_74778_a("author", "Some probably-dead guy");
        tag.func_74778_a("title", "Engineering");
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\n\n\u00ef\u00bf\u00bdl   Dungeonpedia\n\n\u00ef\u00bf\u00bdl     Volume 7\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\nThis volume contains information on tools and traps to help you build your own defences and hinder those that may invade your own dungeon.\n\nSection 1 contains tools.\nSection 2 contains traps.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\n\n\u00ef\u00bf\u00bdl     Section 1\n\n\u00ef\u00bf\u00bdl       Tools\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdlEngineer's Clothes\n\nAn essential outfit for any dungeon engineer. These specially designed clothes, while not good protection in combat, will protect you from the effects of traps.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdlEngineer's Wrench\n\nA dungeon engineer's primary tool; the wrench can be used to rotate blocks, such as pistons and fans, and is excellent for picking up such blocks and rails\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl     Portable\n\u00ef\u00bf\u00bdl   Piston Device\nPistons are great, but not always convenient.\nPutting the pushing power of a piston in your hand, this device will let you quickly reposition those misplaced blocks before anyone notices.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl     Portable\n\u00ef\u00bf\u00bdl Tunnelling Device\nAlso known as the Boom Glove, this device is the result of too many broken picks and a surplus of gunpowder. Using this device will allow the wielder to blast their way through walls and rocks, while preserving most ores encountered.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\nThe '\u00ef\u00bf\u00bdlBigger Boom\u00ef\u00bf\u00bdr' enchantment will increse the power of the PTD's tunneling capabilities, while the '\u00ef\u00bf\u00bdlSonic Boom\u00ef\u00bf\u00bdr' enchantment will modify the tool to use magically generated sound waves, instead of gunpowder, to create explosions.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\n\n\u00ef\u00bf\u00bdl     Section 2\n\n\u00ef\u00bf\u00bdl      Devices\n\u00ef\u00bf\u00bdl     and Traps\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl  Powered Fence\n\nThe redstone dust applied to this metal fencing creates a buildup of charge which will be discharged into any creature that touches it.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl        Fans\n\nStrong enough to push items, creatures, and other people, these fans make a great alternative to water in mob traps, as well as elevators.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl       Flamer\n\nUnable to push entities, this little beauty set things on fire instead.\nManufacturer's notice; may start fires. Use at user's own risk.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl    Trap Plates\n\nA self contained trap that activates when stepped on. Some traps will cause damage, while others aim to disorient invaders.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl    Dispensers\n\nNo tweaking necessary, dispensers can be used for a variety of utilities, such as using weapons, shearing sheep, and milking cows.\""));
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (itemstack.func_77978_p() == null) {
            this.populatePages(itemstack);
        }
        if (!world.field_72995_K) {
            this.resolveContents(itemstack, player);
        }
        if (world.field_72995_K) {
            DungeonTactics.INSTANCE.openDungeonBook(player, itemstack, false);
        }
        player.func_71029_a(StatList.func_188057_b((Item)this));
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    public static boolean validBookTagContents(NBTTagCompound nbt) {
        if (!ItemWritableBook.func_150930_a((NBTTagCompound)nbt)) {
            return false;
        }
        if (!nbt.func_150297_b("title", 8)) {
            return false;
        }
        String s = nbt.func_74779_i("title");
        return s != null && s.length() <= 32 ? nbt.func_150297_b("author", 8) : false;
    }

    public static int getGeneration(ItemStack book) {
        return book.func_77978_p().func_74762_e("generation");
    }

    public String func_77653_i(ItemStack stack) {
        NBTTagCompound nbttagcompound;
        String s;
        if (stack.func_77942_o() && !StringUtils.func_151246_b((String)(s = (nbttagcompound = stack.func_77978_p()).func_74779_i("title")))) {
            return s;
        }
        return super.func_77653_i(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77942_o()) {
            NBTTagCompound nbttagcompound = stack.func_77978_p();
            String s = nbttagcompound.func_74779_i("author");
            if (!StringUtils.func_151246_b((String)s)) {
                tooltip.add(TextFormatting.GRAY + I18n.func_74837_a((String)"book.byAuthor", (Object[])new Object[]{s}));
            }
            tooltip.add(TextFormatting.GRAY + I18n.func_74838_a((String)("book.generation." + nbttagcompound.func_74762_e("generation"))));
        }
    }

    private void resolveContents(ItemStack stack, EntityPlayer player) {
        NBTTagCompound nbttagcompound;
        if (stack.func_77978_p() != null && !(nbttagcompound = stack.func_77978_p()).func_74767_n("resolved")) {
            nbttagcompound.func_74757_a("resolved", true);
            if (DTDungeonpediaBook7.validBookTagContents(nbttagcompound)) {
                NBTTagList nbttaglist = nbttagcompound.func_150295_c("pages", 8);
                for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                    ITextComponent itextcomponent;
                    String s = nbttaglist.func_150307_f(i);
                    try {
                        itextcomponent = ITextComponent.Serializer.func_186877_b((String)s);
                        itextcomponent = TextComponentUtils.func_179985_a((ICommandSender)player, (ITextComponent)itextcomponent, (Entity)player);
                    }
                    catch (Exception var9) {
                        itextcomponent = new TextComponentString(s);
                    }
                    nbttaglist.func_150304_a(i, (NBTBase)new NBTTagString(ITextComponent.Serializer.func_150696_a((ITextComponent)itextcomponent)));
                }
                nbttagcompound.func_74782_a("pages", (NBTBase)nbttaglist);
                if (player instanceof EntityPlayerMP && player.func_184614_ca() == stack) {
                    Slot slot = player.field_71070_bA.func_75147_a((IInventory)player.field_71071_by, player.field_71071_by.field_70461_c);
                    ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketSetSlot(0, slot.field_75222_d, stack));
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return false;
    }
}

