/*
 * Decompiled with CFR 0.152.
 */
package pegbeard.dungeontactics.items.books;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemWritableBook;
import net.minecraft.item.ItemWrittenBook;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSetSlot;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pegbeard.dungeontactics.DungeonTactics;
import pegbeard.dungeontactics.handlers.DTConfigHandler;
import pegbeard.dungeontactics.handlers.DTCreativeTab;

public class DTDungeonpediaBook4
extends ItemWrittenBook {
    public DTDungeonpediaBook4(String name) {
        this.setRegistryName("dungeontactics", name);
        this.func_77655_b(this.getRegistryName().toString());
        this.func_77637_a(DTCreativeTab.DT_TAB);
        ItemStack book = new ItemStack(Items.field_151099_bA);
        this.populatePages(book);
    }

    private void populatePages(ItemStack stack) {
        NBTTagCompound tag = new NBTTagCompound();
        stack.func_77982_d(tag);
        NBTTagList bookPages = new NBTTagList();
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("pages")) {
            stack.func_190919_e("pages");
        }
        tag.func_74782_a("pages", (NBTBase)bookPages);
        if (DTConfigHandler.configuration.get("1-Feature", "Seasonal Events", true).getBoolean(true) && DungeonTactics.fools) {
            tag.func_74778_a("author", "\u00ef\u00bf\u00bdkMoomin");
            tag.func_74778_a("title", "Super Useful Guidebook");
            bookPages.func_74742_a((NBTBase)new NBTTagString("\"\n\n\u00ef\u00bf\u00bdl     Book of All\n\n\u00ef\u00bf\u00bdl     Knowledge\n\n\u00ef\u00bf\u00bdl     Volume \u00ef\u00bf\u00bdk999\""));
            bookPages.func_74742_a((NBTBase)new NBTTagString("\"\nThis immense collection of books contains all knowledge of life, there-after, and the universe.\""));
            bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdkIf you can read this, you are cheating ;) Happy April Fools Day abcd efg hijk lmnop qrs tuv wxy and z 42\u00ef\u00bf\u00bdr.....\n\n*The ink has run and the words are completely illegible.*\""));
            return;
        }
        tag.func_74778_a("author", "Some probably-dead guy");
        tag.func_74778_a("title", "Magic & Alchemy");
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\n\n\u00ef\u00bf\u00bdl   Dungeonpedia\n\n\u00ef\u00bf\u00bdl     Volume 4\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\nThis volume contains information on alchemy and magic scrolls. Grab your spoon.\n\nSection 1 contains alchemy.\nSection 2 contains magic scrolls.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\n\n\u00ef\u00bf\u00bdl     Section 1\n\n\u00ef\u00bf\u00bdl      Alchemy\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\nMixing items in a cauldron is your gateway to ultimate power!!! Or, like, some extra resources and stuff.\nJust light a fire below the cauldron, throw the ingredients in and stir with your favourite spoon.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl   Cherrybombs\n\nActual cherries, that explode. They may only contain a small amount of a gunpowder like substance, but they are non-toxic and can be used to create quantities of real gunpowder.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\nCombine four of cherrybombs with four redstone dust, one flint, and water, in a cauldron, and stir with a spoon to create gunpowder.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl  Incindiberries\n\nKind of like a Persimmon, if the juice was lava. Really tasty and really good for your health, if you are immune to fire. Enough juice from these can melt magma. *recommond you do this in a bucket*\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\nCombine seven of incindiberries with magma and a bucket, in a dry cauldron, and stir with a spoon to create lava. Add water to create obsidian.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl   Glowcurrent\n\nIf you don't mind everything knowing where you are, these peculiar berries can keep an unprepared traveller going through the Nether. Strangely harmless when eaten. I mean, I expected more death from Nether berries...\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\nCombine four of glowcurrents with four redstone dust, one blaze powder, and water, in a cauldron, and stir with a spoon to create glowstone dust.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl    Magic Dust\n\nA neccesary catalyst for casting spells, because you have no latent magical abilities. None. So you need to syphon power from actually magical sources.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\nCombine glowstone dust with a red mushroom, a brown mushroom, and water, in a cauldron, and stir with a spoon to create magic dust.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl   Golden Hearts\n\nIf you can capture a heart and smother it in gold, it won't love you back, but you can still eat it.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\nCombine a bottled heart with two gold nuggets and two glowstone dust, in a dry cauldron, and stir with a spoon to create a golden heart.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\n\n\u00ef\u00bf\u00bdl     Section 2\n\n\u00ef\u00bf\u00bdl   Magic Scrolls\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\nCasting any spell will consume magic dust. Loose dust will be consumed even if the spell fails. so put it in a little baggy and your magic dust will be safe from your failures... Unless you die in lava, but that's a whole other story.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl    Magic Pouch\n\nYou could keep your magic dust up your sleeve, or in your belly button, but these nifty little pouches can hold a lot more. Just open it up and it will automatically eat magic dust from your pockets.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl   Concentration\n\nMost spells have two casting modes. Concentrating (sneaking) will change the effect, causeing some spells to cast as an AoE, or ignore other players.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl   Mage Affinity\n\nThe Mage Affinity enchantment takes the embued magical properties of the enchanted armour and reduces the cost of casting spells.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl    Restoration\n\nNormal cast will heal the caster and team-mates, concentration cast will heal the caster and ALL in range, for about half the amount.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl      Satiate\n\nNormal cast will feed the caster and team-mates, concentration cast will feed the caster and ALL in range, for about half the amount.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl      Forging\n\nNormal cast will smelt all ores and some other resources in the caster's pockets, concentration cast will smelt one stack but produce double the output.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl      Cooking\n\nNormal cast will cook all food in the caster's pockets, concentration cast will cook one stack but produce double the output.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl      Freezing\n\nNormal cast will apply slowness and cryo to all targets, except the caster and team-mates, concentration cast will ignore other players.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl      Uncover\n\nNormal cast will remove armour from all targets except the caster and team-mates, concentration cast will ignore other players.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl       Disarm\n\nNormal cast will cause all targets, except the caster and team-mates, to drop held items, concentration cast will ignore other players.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl      Disorient\n\nNormal cast will spin and blind all targets, except the caster and team-mates, concentration cast will ignore other players.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl       Punish\n\nNormal cast will deal magic damage all targets, except the caster and team-mates, concentration cast will ignore other players.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl       Wither\n\nNormal cast will apply wither all targets, except the caster and team-mates, concentration cast will ignore other players.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl        Smite\n\nNormal cast will invoke lightning on all targets, except the caster and team-mates, concentration cast will ignore other players.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl    Magic Missile\n\nNormal cast will launch a homing projectile all targets, except the caster and team-mates, concentration cast will ignore other players.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl     Pin Missile\n\nBasically what happens if a porkupine sneezes really hard.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl     Transport\n\nEver wanted a dead horse? Well that's what you get, so quit yer yappin'.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl     Companion\n\nDid your best friend die? Life's not fair, but magic plays dirty.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl       Sunder\n\nNormal cast deals heavy damage to all targets, except the caster and team-mates, concentration cast will ignore other players.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl        Rage\n\nNormal cast apply strength and resistance to the caster and team-mates, concentration cast will buff the caster and ALL in range, for about half the amount.\""));
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (itemstack.func_77978_p() == null) {
            this.populatePages(itemstack);
        }
        if (!world.field_72995_K) {
            this.resolveContents(itemstack, player);
        }
        if (world.field_72995_K) {
            DungeonTactics.INSTANCE.openDungeonBook(player, itemstack, false);
        }
        player.func_71029_a(StatList.func_188057_b((Item)this));
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    public static boolean validBookTagContents(NBTTagCompound nbt) {
        if (!ItemWritableBook.func_150930_a((NBTTagCompound)nbt)) {
            return false;
        }
        if (!nbt.func_150297_b("title", 8)) {
            return false;
        }
        String s = nbt.func_74779_i("title");
        return s != null && s.length() <= 32 ? nbt.func_150297_b("author", 8) : false;
    }

    public static int getGeneration(ItemStack book) {
        return book.func_77978_p().func_74762_e("generation");
    }

    public String func_77653_i(ItemStack stack) {
        NBTTagCompound nbttagcompound;
        String s;
        if (stack.func_77942_o() && !StringUtils.func_151246_b((String)(s = (nbttagcompound = stack.func_77978_p()).func_74779_i("title")))) {
            return s;
        }
        return super.func_77653_i(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77942_o()) {
            NBTTagCompound nbttagcompound = stack.func_77978_p();
            String s = nbttagcompound.func_74779_i("author");
            if (!StringUtils.func_151246_b((String)s)) {
                tooltip.add(TextFormatting.GRAY + I18n.func_74837_a((String)"book.byAuthor", (Object[])new Object[]{s}));
            }
            tooltip.add(TextFormatting.GRAY + I18n.func_74838_a((String)("book.generation." + nbttagcompound.func_74762_e("generation"))));
        }
    }

    private void resolveContents(ItemStack stack, EntityPlayer player) {
        NBTTagCompound nbttagcompound;
        if (stack.func_77978_p() != null && !(nbttagcompound = stack.func_77978_p()).func_74767_n("resolved")) {
            nbttagcompound.func_74757_a("resolved", true);
            if (DTDungeonpediaBook4.validBookTagContents(nbttagcompound)) {
                NBTTagList nbttaglist = nbttagcompound.func_150295_c("pages", 8);
                for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                    ITextComponent itextcomponent;
                    String s = nbttaglist.func_150307_f(i);
                    try {
                        itextcomponent = ITextComponent.Serializer.func_186877_b((String)s);
                        itextcomponent = TextComponentUtils.func_179985_a((ICommandSender)player, (ITextComponent)itextcomponent, (Entity)player);
                    }
                    catch (Exception var9) {
                        itextcomponent = new TextComponentString(s);
                    }
                    nbttaglist.func_150304_a(i, (NBTBase)new NBTTagString(ITextComponent.Serializer.func_150696_a((ITextComponent)itextcomponent)));
                }
                nbttagcompound.func_74782_a("pages", (NBTBase)nbttaglist);
                if (player instanceof EntityPlayerMP && player.func_184614_ca() == stack) {
                    Slot slot = player.field_71070_bA.func_75147_a((IInventory)player.field_71071_by, player.field_71071_by.field_70461_c);
                    ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketSetSlot(0, slot.field_75222_d, stack));
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return false;
    }
}

