/*
 * Decompiled with CFR 0.152.
 */
package pegbeard.dungeontactics.handlers;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import pegbeard.dungeontactics.reference.Reference;

public class DTConfigHandler {
    public static Configuration configuration;
    protected static List<Integer> dims;
    public static int hearts;
    public static int extraHearts;
    public static int boneCharms;
    public static int breakCharms;
    public static int potionFish;
    public static boolean flamerBehaviour;
    public static boolean oreClusters;
    public static boolean oreDusters;
    public static boolean clusterLootTable;
    public static int lootbags;
    public static boolean utilityBot;
    public static boolean attackBot;
    public static boolean seasonal;
    public static boolean inconveniant;
    public static boolean replaceBread;
    public static boolean replaceLighter;
    public static boolean betterModels;
    public static boolean steelRecipes;
    public static boolean modifyLoot;
    public static boolean weaponSpawn;
    public static boolean invisNoArmour;
    public static boolean swapArmour;
    public static boolean quickLadders;
    public static boolean chainCreepers;
    public static float hammerDamage;
    public static float hammerSpeed;
    public static float battleaxeDamage;
    public static float battleaxeSpeed;
    public static float glaiveDamage;
    public static float glaiveSpeed;
    public static float glaiveReach;
    public static float cutlassDamage;
    public static float cutlassSpeed;
    public static float knifeDamage;
    public static float knifeSpeed;
    public static float knifeReach;
    public static float cestusDamage;
    public static float cestusSpeed;
    public static float cestusReach;
    public static int toolDurability;
    public static int boneDurability;
    public static float boneDamage;
    public static int silverDurability;
    public static float silverDamage;
    public static int steelDurability;
    public static float steelDamage;
    public static boolean disableSmelting;
    public static boolean disableLifesteal;
    public static boolean disableBerserk;
    public static boolean disableRuned;
    public static float trinketSpeed;
    public static float trinketJump;
    public static float trinketMining;
    public static float trinketGills;
    public static float trinketNightVision;
    public static float trinketFire;
    public static float trinketResistance;
    public static float trinketStrength;
    public static float trinketInvisibility;
    public static boolean oreClustersOverride;
    public static String[] ironOverride;
    public static String[] goldOverride;
    public static String[] mithrilOverride;
    public static String[] tinOverride;
    public static String[] copperOverride;
    public static String[] aluminiumOverride;
    public static String[] nickelOverride;
    public static String[] leadOverride;
    public static String[] silverOverride;
    public static String[] platinumOverride;
    public static String[] tungstenOverride;
    public static String[] titaniumOverride;
    public static String[] ducttapeWhite;
    public static String[] ducttapeBlack;
    public static String[] slingshotWhite;
    public static String[] slingshotBlack;
    public static int silverOre;
    public static int mithrilOre;
    public static int netherGold;
    public static int stoneQuartz;
    public static int endDiamond;
    public static int endLapis;
    public static int flowers;
    public static String[] flowerBiomes;
    public static boolean dungeons;
    public static int shipSpacing;
    public static int dungeonSpacing;
    public static String[] dungeonDimensions;
    public static int dungeonMinHeight;
    public static int dungeonMaxHeight;
    public static int netherDungeonChance;

    public static void init(File configFile) {
        if (configuration == null) {
            configuration = new Configuration(configFile);
            DTConfigHandler.loadConfiguration();
        }
    }

    private static void loadConfiguration() {
        hearts = configuration.getInt("Heart Drops", "1-Feature", 20, 0, 100, "Percentage chance for Heart Drops. Set to 100 for guarenteed drops, 0 to disable.");
        extraHearts = configuration.getInt("Extra Hearts", "1-Feature", 20, 0, 60, "Maximum amount of extra hearts allowed.");
        boneCharms = configuration.getInt("Bone Charm Drops", "1-Feature", 10, 0, 100, "Percentage chance for Bone Charms to be dropped. Set to 100 for guarenteed drops, 0 to disable.");
        breakCharms = configuration.getInt("Bone Charm Break Chance", "1-Feature", 7, 1, 20, "Percentage chance for Bone Charms to break on use. Set to 1 to break on every use.");
        potionFish = configuration.getInt("Potion Fish Catch Chance", "1-Feature", 7, 0, 100, "Weight for catching Potion Fish, when fishing - 0 will disable, vanilla fish weight is 10.");
        flamerBehaviour = configuration.getBoolean("Flamer Behaviour", "1-Feature", true, "Set 'false' to disable certain flamer behaviour, such as heating furnaces and igniting TNT.");
        oreClusters = configuration.getBoolean("Ore Clusters", "1-Feature", true, "Set 'false' to disable fortunable metal ore drops.");
        oreDusters = configuration.getBoolean("Ore Clusters = Dust", "1-Feature", false, "Set 'true' to have ore clusters registered as dusts in the oredict.");
        clusterLootTable = configuration.getBoolean("Use Crushing Loot Table", "1-Feature", false, "Set 'true' to use a json loot tbale for crushing results. 'False' will use the oreDict to find resources.");
        lootbags = configuration.getInt("Loot Bag Drops", "1-Feature", 10, 0, 100, "Percentage chance for Loot Bags. Set to 100 for guarenteed drops, 0 to disable.");
        utilityBot = configuration.getBoolean("Dispensers use some tools", "1-Feature", true, "Set 'false' to disable Dispensers using tools.");
        attackBot = configuration.getBoolean("Dispensers use weapons", "1-Feature", true, "Set 'false' to disable Dispensers using weapons.");
        seasonal = configuration.getBoolean("Seasonal Events", "1-Feature", true, "Set 'false' to disable Seasonal Events, because you have no sense of fun, you monster.");
        inconveniant = configuration.getBoolean("Disable Conveniance Recipes", "1-Feature", false, "Set 'true' to disable conveniance recipes added by DT.");
        replaceBread = configuration.getBoolean("Replace Bread Recipe", "1-Feature", true, "Set 'false' to keep vanilla Bread recipe. Set 'true' to remove the Vanilla Bread recipe in favour of using Flour added by DT.");
        replaceLighter = configuration.getBoolean("Replace Flint and Steel Recipe", "1-Feature", true, "Set 'false' to keep vanilla Flint and Steel recipe. Set 'true' to replace the Vanilla Flint and Steel recipe with one that requires steel instead of iron.");
        betterModels = configuration.getBoolean("3D Item Models", "1-Feature", true, "Set 'false' to use vanilla style item Models.");
        steelRecipes = configuration.getBoolean("Enable Steel", "1-Feature", true, "Set 'false' to disable double cooking iron for steel.");
        modifyLoot = configuration.getBoolean("Modify Loot Pools", "1-Feature", true, "Set 'false' to disable loot pool manipulation - this stops the mod from adding content to vanilla loot pools.");
        weaponSpawn = configuration.getBoolean("Give Weapons to Mobs", "1-Feature", true, "Set 'false' to stop mobs spawning with DT weapons.");
        invisNoArmour = configuration.getBoolean("Invisiblity Removes Armour", "1-Feature", true, "If 'true' armour will be unequipped and placed into the inventory of players with invisibility.");
        swapArmour = configuration.getBoolean("Quick Change Armour", "1-Feature", true, "If enabled. right-clicking armour while already wearing a piece in the same slot will change over the piece in your hand and the piece you are wearing.");
        quickLadders = configuration.getBoolean("Quick Ladder Climb", "1-Feature", true, "Enable/disable ability to right-click a ladder to instantly climb it.");
        chainCreepers = configuration.getBoolean("Chained Creeper Explosions", "1-Feature", true, "If true, explosions will cause creepers to explode, in normal or hard difficulties.");
        hammerDamage = configuration.getFloat("Hammer Base Damage", "5-Weapon Modifiers", 7.0f, 0.0f, 100.0f, "This option allows you to set the base damage of Hammers.");
        hammerSpeed = configuration.getFloat("Hammer Base Speed", "5-Weapon Modifiers", -3.1f, 0.0f, 100.0f, "This option allows you to set the base swing speed of Hammers.");
        battleaxeDamage = configuration.getFloat("Battleaxe Base Damage", "5-Weapon Modifiers", 7.2f, 0.0f, 100.0f, "This option allows you to set the base damage of Battleaxes.");
        battleaxeSpeed = configuration.getFloat("Battleaxe Base Speed", "5-Weapon Modifiers", -3.3f, 0.0f, 100.0f, "This option allows you to set the base swing speed of Battleaxes.");
        glaiveDamage = configuration.getFloat("Glaive Base Damage", "5-Weapon Modifiers", 3.3f, 0.0f, 100.0f, "This option allows you to set the base damage of Glaives.");
        glaiveSpeed = configuration.getFloat("Glaive Base Speed", "5-Weapon Modifiers", -2.8f, 0.0f, 100.0f, "This option allows you to set the base swing speed of Glaives.");
        glaiveReach = configuration.getFloat("Glaive Base Reach", "5-Weapon Modifiers", 4.5f, 3.5f, 10.0f, "This option allows you to set the reach of Glaives.");
        cutlassDamage = configuration.getFloat("Cutlass Base Damage", "5-Weapon Modifiers", 2.0f, 0.0f, 100.0f, "This option allows you to set the base damage of Cutlass'.");
        cutlassSpeed = configuration.getFloat("Cutlass Base Speed", "5-Weapon Modifiers", -2.0f, 0.0f, 100.0f, "This option allows you to set the base swing speed of Cutlass'.");
        knifeDamage = configuration.getFloat("Knife Base Damage", "5-Weapon Modifiers", 1.0f, 0.0f, 100.0f, "This option allows you to set the base damage of Knives.");
        knifeSpeed = configuration.getFloat("Knife Base Speed", "5-Weapon Modifiers", -1.0f, 0.0f, 100.0f, "This option allows you to set the base swing speed of Knives.");
        knifeReach = configuration.getFloat("Knife Base Reach", "5-Weapon Modifiers", 2.5f, 0.0f, 100.0f, "This option allows you to set the reach of Knives.");
        cestusDamage = configuration.getFloat("Cestus Base Damage", "5-Weapon Modifiers", 0.5f, 0.0f, 100.0f, "This option allows you to set the base damage of Cestus'.");
        cestusSpeed = configuration.getFloat("Cestus Base Speed", "5-Weapon Modifiers", 1.0f, 0.0f, 100.0f, "This option allows you to set the base swing speed of Cestus'.");
        cestusReach = configuration.getFloat("Cestus Base Reach", "5-Weapon Modifiers", 2.0f, 0.0f, 100.0f, "This option allows you to set the reach of Cestus'.");
        toolDurability = configuration.getInt("Weapon/Tool Durability", "6-Material Modifiers", 0, 0, 2, "Setting this option to '1' will half weapon/tool durability, '2' will double it, '0' will do nothing.");
        boneDurability = configuration.getInt("Bone Durability Modifiers", "6-Material Modifiers", 59, 0, 5000, "Durability modifier for Bone material items.");
        boneDamage = configuration.getFloat("Bone Damage Modifiers", "6-Material Modifiers", 0.5f, 0.0f, 5000.0f, "Damage modifier for Bone material items.");
        silverDurability = configuration.getInt("Silver Durability Modifiers", "6-Material Modifiers", 70, 0, 5000, "Durability modifier for Silver material items.");
        silverDamage = configuration.getFloat("Silver Damage Modifiers", "6-Material Modifiers", 0.5f, 0.0f, 5000.0f, "Damage modifier for Silver material items.");
        steelDurability = configuration.getInt("Steel Durability Modifiers", "6-Material Modifiers", 500, 0, 5000, "Durability modifier for Steel material items.");
        steelDamage = configuration.getFloat("Steel Damage Modifiers", "6-Material Modifiers", 2.5f, 0.0f, 5000.0f, "Damage modifier for Steel material items.");
        disableSmelting = configuration.getBoolean("Disable Smelting Enchant", "1-Feature", false, "Set 'true' to disable Smelting Enchant.");
        disableLifesteal = configuration.getBoolean("Disable Lifesteal Enchant", "1-Feature", false, "Set 'true' to disable Lifesteal Enchant.");
        disableBerserk = configuration.getBoolean("Disable Berserk Enchant", "1-Feature", false, "Set 'true' to disable Berserk Enchant.");
        disableRuned = configuration.getBoolean("Disable Runed Enchant", "1-Feature", false, "Set 'true' to disable Runed Enchant.");
        trinketSpeed = configuration.getFloat("Trinket Speed Boost", "6-Other Modifiers", 0.1f, 0.0f, 100.0f, "Hunger cost value for Trinket Speed Effect.");
        trinketJump = configuration.getFloat("Trinket Jump Boost", "6-Other Modifiers", 0.1f, 0.0f, 100.0f, "Hunger cost value for Trinket Jump Effect.");
        trinketMining = configuration.getFloat("Trinket Minging Haste", "6-Other Modifiers", 0.1f, 0.0f, 100.0f, "Hunger cost value for Trinket Mining Haste Effect.");
        trinketGills = configuration.getFloat("Trinket Water Breathing", "6-Other Modifiers", 0.2f, 0.0f, 100.0f, "Hunger cost value for Trinket Gills Effect.");
        trinketNightVision = configuration.getFloat("Trinket Night Vision", "6-Other Modifiers", 0.2f, 0.0f, 100.0f, "Hunger cost value for Trinket Night Vision Effect.");
        trinketFire = configuration.getFloat("Trinket Fire Resistance", "6-Other Modifiers", 0.3f, 0.0f, 100.0f, "Hunger cost value for Trinket Fire Resistance Effect.");
        trinketResistance = configuration.getFloat("Trinket Resistance", "6-Other Modifiers", 0.3f, 0.0f, 100.0f, "Hunger cost value for Trinket Stone Skin Effect.");
        trinketStrength = configuration.getFloat("Trinket Strength", "6-Other Modifiers", 0.4f, 0.0f, 100.0f, "Hunger cost value for Trinket Strength Effect.");
        trinketInvisibility = configuration.getFloat("Trinket Invisibility", "6-Other Modifiers", 0.4f, 0.0f, 100.0f, "Hunger cost value for Trinket Invisibilty Effect.");
        oreClustersOverride = configuration.getBoolean("Cluster Output Override", "4-OreClusterOverrides", false, "Set 'true' to override Ore Cluster smelting outputs.");
        ironOverride = configuration.getStringList("Iron Override", "4-OreClusterOverrides", Reference.IRONOVERRIDEDEFAULT, "If empty output will be automatically assigned. Example= minecraft:iron_ingot or 265. If specified item does not exist, cluster will not be smeltable.");
        goldOverride = configuration.getStringList("Gold Override", "4-OreClusterOverrides", Reference.GOLDOVERRIDEDEFAULT, "If empty output will be automatically assigned. Example= minecraft:gold_ingot or 266. If specified item does not exist, cluster will not be smeltable.");
        mithrilOverride = configuration.getStringList("Mithril Override", "4-OreClusterOverrides", Reference.MITHRILOVERRIDEDEFAULT, "If empty output will be automatically assigned. Example= minecraft:gold_ingot or 266. If specified item does not exist, cluster will not be smeltable.");
        tinOverride = configuration.getStringList("Tin Override", "4-OreClusterOverrides", Reference.TINOVERRIDEDEFAULT, "If empty output will be automatically assigned. If specified item does not exist, cluster will not be smeltable.");
        copperOverride = configuration.getStringList("Copper Override", "4-OreClusterOverrides", Reference.COPPEROVERRIDEDEFAULT, "If empty output will be automatically assigned. If specified item does not exist, cluster will not be smeltable.");
        aluminiumOverride = configuration.getStringList("Aluminium Override", "4-OreClusterOverrides", Reference.ALUMINIUMOVERRIDEDEFAULT, "If empty output will be automatically assigned. If specified item does not exist, cluster will not be smeltable.");
        nickelOverride = configuration.getStringList("Nickel Override", "4-OreClusterOverrides", Reference.NICKELOVERRIDEDEFAULT, "If empty output will be automatically assigned. If specified item does not exist, cluster will not be smeltable.");
        leadOverride = configuration.getStringList("Lead Override", "4-OreClusterOverrides", Reference.LEADOVERRIDEDEFAULT, "If empty output will be automatically assigned. If specified item does not exist, cluster will not be smeltable.");
        silverOverride = configuration.getStringList("Silver Override", "4-OreClusterOverrides", Reference.SILVEROVERRIDEDEFAULT, "If empty output will be automatically assigned. If specified item does not exist, cluster will not be smeltable.");
        platinumOverride = configuration.getStringList("Platinum Override", "4-OreClusterOverrides", Reference.PLATINUMOVERRIDEDEFAULT, "If empty output will be automatically assigned. If specified item does not exist, cluster will not be smeltable.");
        tungstenOverride = configuration.getStringList("Tungsten Override", "4-OreClusterOverrides", Reference.TUNGSTENOVERRIDEDEFAULT, "If empty output will be automatically assigned. If specified item does not exist, cluster will not be smeltable.");
        titaniumOverride = configuration.getStringList("Titanium Override", "4-OreClusterOverrides", Reference.TITANIUMOVERRIDEDEFAULT, "If empty output will be automatically assigned. If specified item does not exist, cluster will not be smeltable.");
        ducttapeWhite = configuration.getStringList("Ductape White List", "2-Ducttapableslists", Reference.DUCTTAPEWHITELISTDEFAULT, "White List of items that can be repaired with Duct Tape. Weapons, tools, and armour should be detected by default.");
        ducttapeBlack = configuration.getStringList("Ductape Black List", "2-Ducttapableslists", Reference.DUCTTAPEBLACKLISTDEFAULT, "Black List of items that can not be repaired with Duct Tape. Example 'minecraft:fishing_rod'. Leave this EMPTY to blacklist ALL.");
        slingshotWhite = configuration.getStringList("Slingshot Ammo White List", "3-SlingshotAmmo", Reference.SLINGSHOTWHITELISTDEFAULT, "White List of items that can be used as ammo for the Slingshot. Items oreDicted as 'seeds' will be detected automatically.");
        slingshotBlack = configuration.getStringList("Slingshot Ammo Black List", "3-SlingshotAmmo", Reference.SLINGSHOTBLACKLISTDEFAULT, "Black List of items that can not used as ammo for the Slingshot.");
        silverOre = configuration.getInt("Silver Ore", "7-World", 6, 0, 100, "Number of times to attempt to generate Silver per chunk. Set to 0 to disable Silver from being generated in the Overworld.");
        mithrilOre = configuration.getInt("Mithril Ore", "7-World", 2, 0, 100, "Number of times to attempt to generate Mithril per chunk. Set to 0 to disable Mithril from being generated in the Overworld.");
        netherGold = configuration.getInt("Nether Gold", "7-World", 6, 0, 100, "Number of times to attempt to generate Gold per chunk. Set to 0 to disable Gold from being generated in the Nether.");
        stoneQuartz = configuration.getInt("Overworld Quartz", "7-World", 6, 0, 100, "Number of times to attempt to generate Quartz per chunk. Set to 0 to disable Quartz from being generated in the Overworld.");
        endDiamond = configuration.getInt("Overworld Quartz", "7-World", 6, 0, 100, "Number of times to attempt to generate Diamond per chunk. Set to 0 to disable Diamond from being generated in the End.");
        endLapis = configuration.getInt("Overworld Quartz", "7-World", 6, 0, 100, "Number of times to attempt to generate Lapis per chunk. Set to 0 to disable Lapis from being generated in the End.");
        flowers = configuration.getInt("Flower Generation", "7-World", 32, 0, 100, "Set higher for more Dungeon Tactics Flowers.");
        flowerBiomes = configuration.getStringList("Flower Biomes", "8-WorldGen", Reference.FLOWERBIOMESDEFAULT, "Whitelist of biomes where Dungeon Tactics Flowers can be generated (only effects worldgen).");
        dungeons = configuration.getBoolean("Dungeon Generation", "7-World", true, "Set 'false' to disable Dungeon Tactics structures.");
        shipSpacing = configuration.getInt("Ship Spacing", "7-World", 500, 50, 5000, "Rough distance between Ships (Only generated in oceans).");
        dungeonSpacing = configuration.getInt("Dungeon Spacing", "7-World", 1000, 50, 5000, "Rough distance between Towers/Dungeons.");
        dungeonDimensions = configuration.getStringList("Structure Dimensions", "7-World", Reference.DUNGEONDIMENSIONSDEFAULT, "Whitelist of dimensions in which Dungeon Tactics Structures can be generated.");
        dungeonMinHeight = configuration.getInt("Dungeon MinHeight", "7-World", 3, 0, 20, "Minimum floors for towers to generate (Setting this higher than 'Max Height' will make all towers this height).");
        dungeonMaxHeight = configuration.getInt("Dungeon MaxHeight", "7-World", 10, 0, 20, "Maximum floors for towers to generate.");
        netherDungeonChance = configuration.getInt("Nether Variant Chance", "7-World", 9, 0, 100, "Percentage chance for Towers/Dungeons to be 'Nether themed'. This only effects Overworld Towers/Dungeons. Set to 100 for guarenteed chance, 0 to disable.");
        DTConfigHandler.DimensionConfig("Structure Dimensions", "7-World", Reference.DUNGEONDIMENSIONSDEFAULT);
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    public static void DimensionConfig(String name, String category, String ... defaultStrs) {
        String[] dimStrs = configuration.getStringList(name, category, defaultStrs, "");
        dims = new ArrayList<Integer>();
        for (String s : dimStrs) {
            try {
                dims.add(Integer.parseInt(s));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public static boolean canSpawnHere(World world) {
        return dims.contains(world.field_73011_w.getDimension());
    }

    @SubscribeEvent
    public void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("dungeontactics")) {
            DTConfigHandler.loadConfiguration();
        }
    }

    static {
        hearts = 20;
        extraHearts = 20;
        boneCharms = 10;
        breakCharms = 7;
        potionFish = 7;
        flamerBehaviour = true;
        oreClusters = true;
        oreDusters = false;
        clusterLootTable = false;
        lootbags = 10;
        utilityBot = true;
        attackBot = true;
        seasonal = true;
        inconveniant = false;
        replaceBread = true;
        replaceLighter = true;
        betterModels = true;
        steelRecipes = true;
        modifyLoot = true;
        weaponSpawn = true;
        invisNoArmour = true;
        swapArmour = true;
        quickLadders = true;
        chainCreepers = true;
        hammerDamage = 7.0f;
        hammerSpeed = -3.1f;
        battleaxeDamage = 7.2f;
        battleaxeSpeed = -3.3f;
        glaiveDamage = 3.3f;
        glaiveSpeed = -2.8f;
        glaiveReach = 4.5f;
        cutlassDamage = 2.0f;
        cutlassSpeed = -2.0f;
        knifeDamage = 1.0f;
        knifeSpeed = -1.0f;
        knifeReach = 2.5f;
        cestusDamage = 0.5f;
        cestusSpeed = 1.0f;
        cestusReach = 2.0f;
        toolDurability = 0;
        boneDurability = 59;
        boneDamage = 0.5f;
        silverDurability = 70;
        silverDamage = 0.5f;
        steelDurability = 500;
        steelDamage = 2.5f;
        disableSmelting = false;
        disableLifesteal = false;
        disableBerserk = false;
        disableRuned = false;
        trinketSpeed = 0.1f;
        trinketJump = 0.1f;
        trinketMining = 0.1f;
        trinketGills = 0.2f;
        trinketNightVision = 0.2f;
        trinketFire = 0.3f;
        trinketResistance = 0.3f;
        trinketStrength = 0.4f;
        trinketInvisibility = 0.4f;
        oreClustersOverride = false;
        ironOverride = Reference.IRONOVERRIDEDEFAULT;
        goldOverride = Reference.GOLDOVERRIDEDEFAULT;
        mithrilOverride = Reference.MITHRILOVERRIDEDEFAULT;
        tinOverride = Reference.TINOVERRIDEDEFAULT;
        copperOverride = Reference.COPPEROVERRIDEDEFAULT;
        aluminiumOverride = Reference.ALUMINIUMOVERRIDEDEFAULT;
        nickelOverride = Reference.NICKELOVERRIDEDEFAULT;
        leadOverride = Reference.LEADOVERRIDEDEFAULT;
        silverOverride = Reference.SILVEROVERRIDEDEFAULT;
        platinumOverride = Reference.PLATINUMOVERRIDEDEFAULT;
        tungstenOverride = Reference.TUNGSTENOVERRIDEDEFAULT;
        titaniumOverride = Reference.TITANIUMOVERRIDEDEFAULT;
        ducttapeWhite = Reference.DUCTTAPEWHITELISTDEFAULT;
        ducttapeBlack = Reference.DUCTTAPEBLACKLISTDEFAULT;
        slingshotWhite = Reference.SLINGSHOTWHITELISTDEFAULT;
        slingshotBlack = Reference.SLINGSHOTBLACKLISTDEFAULT;
        silverOre = 6;
        mithrilOre = 2;
        netherGold = 6;
        stoneQuartz = 6;
        endDiamond = 6;
        endLapis = 6;
        flowers = 32;
        flowerBiomes = Reference.FLOWERBIOMESDEFAULT;
        dungeons = true;
        shipSpacing = 500;
        dungeonSpacing = 1000;
        dungeonDimensions = Reference.DUNGEONDIMENSIONSDEFAULT;
        dungeonMinHeight = 3;
        dungeonMaxHeight = 10;
        netherDungeonChance = 9;
    }
}

