/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.pickletweaks.feature.item;

import com.blakebr0.cucumber.iface.IEnableable;
import com.blakebr0.cucumber.item.ItemBase;
import com.blakebr0.cucumber.util.Utils;
import com.blakebr0.pickletweaks.PickleTweaks;
import com.blakebr0.pickletweaks.config.ModConfig;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemWateringCan
extends ItemBase
implements IEnableable {
    private boolean water = false;
    private long ticks;

    public ItemWateringCan() {
        super("pt.watering_can");
        this.func_77637_a(PickleTweaks.CREATIVE_TAB);
        this.func_77625_d(1);
    }

    public ItemStack initTags(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            stack.func_77982_d(tag);
            tag.func_74757_a("Water", false);
        }
        return stack;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.add((Object)this.initTags(new ItemStack((Item)this, 1, 0)));
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        if (selected) {
            ++this.ticks;
            if (this.ticks % 5L == 0L) {
                this.water = true;
            }
        }
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.NONE;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        RayTraceResult raytraceresult = this.func_77621_a(world, player, true);
        if (raytraceresult == null) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        if (world.func_180495_p(raytraceresult.func_178782_a()).func_185904_a() == Material.field_151586_h && (Integer)world.func_180495_p(raytraceresult.func_178782_a()).func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0) {
            this.initTags(stack);
            stack.func_77978_p().func_74757_a("Water", true);
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (!player.func_175151_a(pos.func_177972_a(facing), facing, stack)) {
            return EnumActionResult.FAIL;
        }
        if (stack.func_77978_p() == null) {
            return EnumActionResult.FAIL;
        }
        if (!stack.func_77978_p().func_74767_n("Water")) {
            return EnumActionResult.FAIL;
        }
        Iterable blocks = BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-1, -1, -1), (BlockPos)pos.func_177982_a(1, 1, 1));
        for (BlockPos aoePos : blocks) {
            int moisture;
            IBlockState aoeState = world.func_180495_p(aoePos);
            if (!(aoeState.func_177230_c() instanceof BlockFarmland) || (moisture = ((Integer)aoeState.func_177229_b((IProperty)BlockFarmland.field_176531_a)).intValue()) >= 7) continue;
            world.func_180501_a(aoePos, aoeState.func_177226_a((IProperty)BlockFarmland.field_176531_a, (Comparable)Integer.valueOf(7)), 2);
        }
        Random rand = new Random();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                double d0 = (float)pos.func_177982_a(x, 0, z).func_177958_n() + rand.nextFloat();
                double d1 = (double)pos.func_177982_a(x, 0, z).func_177956_o() + 1.0;
                double d2 = (float)pos.func_177982_a(x, 0, z).func_177952_p() + rand.nextFloat();
                IBlockState state = world.func_180495_p(pos);
                if (state.func_185917_h() || state.func_177230_c() instanceof BlockFarmland) {
                    d1 += 0.3;
                }
                world.func_175688_a(EnumParticleTypes.WATER_DROP, d0, d1, d2, 0.0, 0.0, 0.0, new int[5]);
            }
        }
        if (!world.field_72995_K && this.water) {
            this.water = false;
            int chance = Utils.randInt((int)1, (int)100);
            if (chance <= 25) {
                for (BlockPos aoePos : blocks) {
                    Block plant = world.func_180495_p(aoePos).func_177230_c();
                    if (!(plant instanceof IGrowable) && !(plant instanceof IPlantable) && plant != Blocks.field_150391_bh && plant != Blocks.field_185766_cS) continue;
                    world.func_180497_b(aoePos, plant, 0, 1);
                }
                return EnumActionResult.FAIL;
            }
        }
        return EnumActionResult.FAIL;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        this.initTags(stack);
        if (stack.func_77978_p().func_74767_n("Water")) {
            tooltip.add(Utils.localize((String)"tooltip.pt.filled"));
        } else {
            tooltip.add(Utils.localize((String)"tooltip.pt.empty"));
        }
    }

    public boolean isEnabled() {
        return ModConfig.confWateringCan;
    }
}

