/*
 * Decompiled with CFR 0.152.
 */
package li.cil.vials.common.item;

import java.util.List;
import javax.annotation.Nullable;
import li.cil.vials.common.integration.tconstruct.DrainHandler;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fluids.capability.ItemFluidContainer;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemVial
extends ItemFluidContainer {
    public ItemVial(int capacity) {
        super(capacity);
    }

    @SideOnly(value=Side.CLIENT)
    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (Loader.isModLoaded((String)"tconstruct")) {
            return DrainHandler.onItemUseFirst(player.func_184586_b(hand), player, world, pos, side, hitX, hitY, hitZ, hand);
        }
        return super.onItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, hand);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(I18n.func_135052_a((String)"vials.CAPACITY", (Object[])new Object[]{this.capacity}));
    }

    public String func_77653_i(ItemStack stack) {
        IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)stack);
        assert (fluidHandler != null);
        IFluidTankProperties iFluidTankProperties = fluidHandler.getTankProperties()[0];
        String itemStackDisplayName = super.func_77653_i(stack);
        if (iFluidTankProperties.getContents() != null) {
            itemStackDisplayName = itemStackDisplayName + " " + iFluidTankProperties.getContents().getLocalizedName();
        }
        return itemStackDisplayName;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new FluidHandlerItemStack(stack, this.capacity){

            public int fill(FluidStack resource, boolean doFill) {
                if (this.container.func_190916_E() != 1 || resource == null || resource.amount < this.capacity || this.getFluid() != null || !this.canFillFluidType(resource)) {
                    return 0;
                }
                if (doFill) {
                    FluidStack filled = resource.copy();
                    this.setFluid(filled);
                }
                return this.capacity;
            }

            @Nullable
            public FluidStack drain(FluidStack resource, boolean doDrain) {
                if (resource == null || resource.amount < this.capacity) {
                    return null;
                }
                FluidStack fluidStack = this.getFluid();
                if (fluidStack != null && fluidStack.isFluidEqual(resource)) {
                    if (doDrain) {
                        this.setContainerToEmpty();
                    }
                    return fluidStack;
                }
                return null;
            }

            public FluidStack drain(int maxDrain, boolean doDrain) {
                if (this.container.func_190916_E() != 1 || maxDrain <= 0) {
                    return null;
                }
                FluidStack contained = this.getFluid();
                if (contained == null || contained.amount <= 0 || !this.canDrainFluidType(contained)) {
                    return null;
                }
                if (maxDrain < this.capacity) {
                    return null;
                }
                int drainAmount = Math.min(contained.amount, maxDrain);
                FluidStack drained = contained.copy();
                drained.amount = drainAmount;
                if (doDrain) {
                    contained.amount -= drainAmount;
                    if (contained.amount == 0) {
                        this.setContainerToEmpty();
                    } else {
                        this.setFluid(contained);
                    }
                }
                return drained;
            }
        };
    }
}

