/*
 * Decompiled with CFR 0.152.
 */
package li.cil.vials.common.integration.tconstruct;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import slimeknights.tconstruct.smeltery.block.BlockSmelteryIO;

public class DrainHandler {
    public static EnumActionResult onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (pos != null) {
            IBlockState blockState = world.func_180495_p(pos);
            Block block = blockState.func_177230_c();
            if (block instanceof BlockSmelteryIO) {
                IFluidTankProperties[] tankProperties;
                IFluidHandlerItem fluidHandlerItem = FluidUtil.getFluidHandler((ItemStack)stack);
                IFluidHandler fluidHandlerDrain = DrainHandler.getFluidHandler(pos, side, world);
                if (fluidHandlerItem != null && (tankProperties = fluidHandlerItem.getTankProperties()).length != 0) {
                    FluidStack contents = tankProperties[0].getContents();
                    IItemHandler playerInventory = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
                    if (contents != null && contents.amount > 0) {
                        FluidActionResult result = FluidUtil.tryEmptyContainerAndStow((ItemStack)stack, (IFluidHandler)fluidHandlerDrain, (IItemHandler)playerInventory, (int)tankProperties[0].getCapacity(), (EntityPlayer)player);
                        if (result.isSuccess()) {
                            player.func_184611_a(hand, result.getResult());
                        }
                    } else {
                        FluidActionResult result = FluidUtil.tryFillContainerAndStow((ItemStack)stack, (IFluidHandler)fluidHandlerDrain, (IItemHandler)playerInventory, (int)tankProperties[0].getCapacity(), (EntityPlayer)player);
                        if (result.isSuccess()) {
                            player.func_184611_a(hand, result.getResult());
                        }
                    }
                    return EnumActionResult.SUCCESS;
                }
            } else {
                return EnumActionResult.PASS;
            }
        }
        return EnumActionResult.PASS;
    }

    protected static IFluidHandler getFluidHandler(BlockPos pos, EnumFacing direction, World world) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction)) {
            return (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction);
        }
        return null;
    }
}

