/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.block;

import com.feed_the_beast.ftbquests.block.BlockWithHorizontalFacing;
import com.feed_the_beast.ftbquests.item.FTBQuestsItems;
import com.feed_the_beast.ftbquests.tile.TileQuestChest;
import javax.annotation.Nullable;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockQuestChest
extends BlockWithHorizontalFacing {
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.875, 0.9375);

    public BlockQuestChest() {
        super(Material.field_151575_d, MapColor.field_151670_w);
        this.func_149711_c(1.0f);
    }

    public boolean isToolEffective(String type, IBlockState state) {
        return "axe".equals(type) || "pickaxe".equals(type);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileQuestChest();
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Deprecated
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ItemStack stack = new ItemStack(FTBQuestsItems.CHEST);
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileQuestChest) {
            ((TileQuestChest)tileEntity).writeToItem(stack);
        }
        return stack;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity;
        if (!world.field_72995_K && (tileEntity = world.func_175625_s(pos)) instanceof TileQuestChest) {
            ((TileQuestChest)tileEntity).openGui((EntityPlayerMP)player);
        }
        return true;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileQuestChest) {
            TileQuestChest tile = (TileQuestChest)tileEntity;
            tile.readFromItem(stack);
            tile.setIDFromPlacer(placer);
        }
    }

    @Deprecated
    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileQuestChest && ((TileQuestChest)tileEntity).indestructible) {
            return -1.0f;
        }
        return super.func_176195_g(state, world, pos);
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileQuestChest && ((TileQuestChest)tileEntity).indestructible) {
            return Float.MAX_VALUE;
        }
        return super.getExplosionResistance(world, pos, exploder, explosion);
    }
}

