/*
 * Decompiled with CFR 0.152.
 */
package ferro2000.immersivetech.common.integration.jei;

import ferro2000.immersivetech.api.craftings.BoilerRecipes;
import ferro2000.immersivetech.api.craftings.DistillerRecipes;
import ferro2000.immersivetech.api.craftings.SolarTowerRecipes;
import ferro2000.immersivetech.common.integration.ITIntegrationModule;
import ferro2000.immersivetech.common.integration.jei.ITFluidTooltipCallback;
import ferro2000.immersivetech.common.integration.jei.ITRecipeCategory;
import ferro2000.immersivetech.common.integration.jei.boiler.BoilerRecipeCategory;
import ferro2000.immersivetech.common.integration.jei.distiller.DistillerRecipeCategory;
import ferro2000.immersivetech.common.integration.jei.solartower.SolarTowerRecipeCategory;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.IRecipeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.ingredients.IModIngredientRegistration;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.IRecipeWrapperFactory;

@JEIPlugin
public class JEIHelper
implements IModPlugin {
    public static IJeiHelpers jeiHelpers;
    public static IModRegistry modRegistry;
    public static IDrawable slotDrawable;
    public static ITooltipCallback fluidTooltipCallback;
    Map<Class, ITRecipeCategory> categories = new LinkedHashMap<Class, ITRecipeCategory>();

    public void registerIngredients(IModIngredientRegistration registry) {
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        slotDrawable = guiHelper.getSlotDrawable();
        this.categories.put(DistillerRecipes.class, new DistillerRecipeCategory(guiHelper));
        this.categories.put(BoilerRecipes.class, new BoilerRecipeCategory(guiHelper));
        this.categories.put(SolarTowerRecipes.class, new SolarTowerRecipeCategory(guiHelper));
        registry.addRecipeCategories(this.categories.values().toArray(new IRecipeCategory[this.categories.size()]));
    }

    public void register(IModRegistry registryIn) {
        modRegistry = registryIn;
        for (ITRecipeCategory cat : this.categories.values()) {
            cat.addCatalysts(registryIn);
            modRegistry.handleRecipes(cat.getRecipeClass(), (IRecipeWrapperFactory)cat, cat.getRecipeCategoryUid());
        }
        modRegistry.addRecipes(new ArrayList<DistillerRecipes>(DistillerRecipes.recipeList), "it.distiller");
        modRegistry.addRecipes(new ArrayList<BoilerRecipes>(BoilerRecipes.recipeList), "it.boiler");
        modRegistry.addRecipes(new ArrayList<SolarTowerRecipes>(SolarTowerRecipes.recipeList), "it.solarTower");
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        IRecipeRegistry registry = jeiRuntime.getRecipeRegistry();
        ITIntegrationModule.jeiAddFunc = recipe -> {
            ITRecipeCategory factory = this.getFactory(recipe.getClass());
            if (factory != null) {
                registry.addRecipe(factory.getRecipeWrapper(recipe), factory.getUid());
            }
        };
        ITIntegrationModule.jeiRemoveFunc = recipe -> {
            ITRecipeCategory factory = this.getFactory(recipe.getClass());
            if (factory != null) {
                registry.removeRecipe(factory.getRecipeWrapper(recipe), factory.getUid());
            }
        };
    }

    private ITRecipeCategory getFactory(Class recipeClass) {
        ITRecipeCategory factory = this.categories.get(recipeClass);
        if (factory == null && recipeClass != Object.class) {
            factory = this.getFactory(recipeClass.getSuperclass());
        }
        return factory;
    }

    static {
        fluidTooltipCallback = new ITFluidTooltipCallback();
    }
}

