package atomicstryker.infernalmobs.common.mods;

import atomicstryker.infernalmobs.common.MobModifier;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;

public class MM_Storm extends MobModifier
{
    
    public MM_Storm()
    {
        super();
    }
    
    public MM_Storm(MobModifier next)
    {
        super(next);
    }

    @Override
    public String getModName()
    {
        return "Storm";
    }
    
    private long nextAbilityUse = 0L;
    private final static long coolDown = 15000L;
    private final static float MIN_DISTANCE = 3F;
    
    @Override
    public boolean onUpdate(EntityLivingBase mob)
    {
        if (hasSteadyTarget()
        && getMobTarget() instanceof EntityPlayer)
        {
            tryAbility(mob, getMobTarget());
        }
        
        return super.onUpdate(mob);
    }

    private void tryAbility(EntityLivingBase mob, EntityLivingBase target)
    {
        if (target == null || target.func_184187_bx() != null || !mob.func_70685_l(target))
        {
            return;
        }
        
        long time = System.currentTimeMillis();
        if (time > nextAbilityUse
        && mob.func_70032_d(target) > MIN_DISTANCE
        && target.field_70170_p.func_175710_j(new BlockPos(MathHelper.func_76128_c(target.field_70165_t), MathHelper.func_76128_c(target.field_70163_u), MathHelper.func_76128_c(target.field_70161_v))))
        {
            nextAbilityUse = time+coolDown;
            mob.field_70170_p.func_72942_c(new EntityLightningBolt(mob.field_70170_p, target.field_70165_t, target.field_70163_u-1, target.field_70161_v, false));
        }
    }
    
    @Override
    protected String[] getModNameSuffix()
    {
        return suffix;
    }
    private static String[] suffix = { "ofLightning", "theRaiden" };
    
    @Override
    protected String[] getModNamePrefix()
    {
        return prefix;
    }
    private static String[] prefix = { "striking", "thundering", "electrified" };
    
}
