package atomicstryker.infernalmobs.common.mods;

import atomicstryker.infernalmobs.common.InfernalMobsCore;
import atomicstryker.infernalmobs.common.MobModifier;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;

public class MM_Poisonous extends MobModifier
{
    
    public MM_Poisonous()
    {
        super();
    }
    
    public MM_Poisonous(MobModifier next)
    {
        super(next);
    }

    @Override
    public String getModName()
    {
        return "Poisonous";
    }
    
    @Override
    public float onHurt(EntityLivingBase mob, DamageSource source, float damage)
    {
        if (source.func_76346_g() != null
        && (source.func_76346_g() instanceof EntityLivingBase)
        && InfernalMobsCore.instance().getIsEntityAllowedTarget(source.func_76346_g()))
        {
            EntityLivingBase ent = (EntityLivingBase)source.func_76346_g();
            if (!ent.func_70644_a(MobEffects.field_76436_u)
            && !(source instanceof EntityDamageSourceIndirect))
            {
                ent.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 120, 0));
            }
        }
        
        return super.onHurt(mob, source, damage);
    }
    
    @Override
    public float onAttack(EntityLivingBase entity, DamageSource source, float damage)
    {
        if (entity != null
        && InfernalMobsCore.instance().getIsEntityAllowedTarget(entity)
        && !entity.func_70644_a(MobEffects.field_76436_u))
        {
            entity.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 120, 0));
        }
        
        return super.onAttack(entity, source, damage);
    }
    
    @Override
    protected String[] getModNameSuffix()
    {
        return suffix;
    }
    private static String[] suffix = { "ofVenom", "thedeadlyChalice" };
    
    @Override
    protected String[] getModNamePrefix()
    {
        return prefix;
    }
    private static String[] prefix = { "poisonous", "stinging", "despoiling" };
    
}
