package atomicstryker.infernalmobs.common.mods;

import atomicstryker.infernalmobs.common.InfernalMobsCore;
import atomicstryker.infernalmobs.common.MobModifier;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class MM_Ninja extends MobModifier
{

    public MM_Ninja()
    {
        super();
    }

    public MM_Ninja(MobModifier next)
    {
        super(next);
    }

    @Override
    public String getModName()
    {
        return "Ninja";
    }

    private long nextAbilityUse = 0L;
    private final static long coolDown = 15000L;

    @Override
    public float onHurt(EntityLivingBase mob, DamageSource source, float damage)
    {
        long time = System.currentTimeMillis();
        if (time > nextAbilityUse && source.func_76346_g() != null && source.func_76346_g() != mob && !InfernalMobsCore.instance().isInfiniteLoop(mob, source.func_76346_g())
                && teleportToEntity(mob, source.func_76346_g()))
        {
            nextAbilityUse = time + coolDown;
            source.func_76346_g().func_70097_a(DamageSource.func_76358_a(mob), InfernalMobsCore.instance().getLimitedDamage(damage));
            return super.onHurt(mob, source, 0);
        }

        return super.onHurt(mob, source, damage);
    }

    private boolean teleportToEntity(EntityLivingBase mob, Entity par1Entity)
    {
        Vec3d vector = new Vec3d(mob.field_70165_t - par1Entity.field_70165_t, mob.func_174813_aQ().field_72338_b + (double) (mob.field_70131_O / 2.0F) - par1Entity.field_70163_u + (double) par1Entity.func_70047_e(),
                mob.field_70161_v - par1Entity.field_70161_v);
        vector = vector.func_72432_b();
        double telDist = 8.0D;
        double destX = mob.field_70165_t + (mob.field_70170_p.field_73012_v.nextDouble() - 0.5D) * 4.0D - vector.field_72450_a * telDist;
        double destY = mob.field_70163_u + (double) (mob.field_70170_p.field_73012_v.nextInt(16) - 4) - vector.field_72448_b * telDist;
        double destZ = mob.field_70161_v + (mob.field_70170_p.field_73012_v.nextDouble() - 0.5D) * 4.0D - vector.field_72449_c * telDist;
        return teleportTo(mob, destX, destY, destZ);
    }

    private boolean teleportTo(EntityLivingBase mob, double destX, double destY, double destZ)
    {
        double oldX = mob.field_70165_t;
        double oldY = mob.field_70163_u;
        double oldZ = mob.field_70161_v;
        boolean success = false;
        mob.field_70165_t = destX;
        mob.field_70163_u = destY;
        mob.field_70161_v = destZ;
        int x = MathHelper.func_76128_c(mob.field_70165_t);
        int y = MathHelper.func_76128_c(mob.field_70163_u);
        int z = MathHelper.func_76128_c(mob.field_70161_v);

        boolean hitGround = false;
        while (!hitGround && y < 96 && y > 0)
        {
            IBlockState bs = mob.field_70170_p.func_180495_p(new BlockPos(x, y - 1, z));
            if (bs.func_185904_a().func_76230_c())
            {
                hitGround = true;
            }
            else
            {
                --mob.field_70163_u;
                --y;
            }
        }

        if (hitGround)
        {
            mob.func_70107_b(mob.field_70165_t, mob.field_70163_u, mob.field_70161_v);
            mob.field_70170_p.func_184133_a(null, new BlockPos(mob), SoundEvents.field_187539_bB, SoundCategory.HOSTILE, 1.0F + mob.func_70681_au().nextFloat(), mob.func_70681_au().nextFloat() * 0.7F + 0.3F);
            mob.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, oldX, oldY, oldZ, 0D, 0D, 0D);

            if (mob.field_70170_p.func_184144_a(mob, mob.func_174813_aQ()).isEmpty() && !mob.field_70170_p.func_72953_d(mob.func_174813_aQ())
                    && !mob.field_70170_p.func_72829_c(mob.func_174813_aQ()))
            {
                success = true;
            }
        }
        else
        {
            return false;
        }

        if (!success)
        {
            mob.func_70107_b(oldX, oldY, oldZ);
            return false;
        }
        return true;
    }

    @Override
    protected String[] getModNameSuffix()
    {
        return suffix;
    }

    private static String[] suffix = { "theZenMaster", "ofEquilibrium", "ofInnerPeace" };

    @Override
    protected String[] getModNamePrefix()
    {
        return prefix;
    }

    private static String[] prefix = { "totallyzen", "innerlypeaceful", "Ronin" };

}
