package atomicstryker.infernalmobs.common.mods;

import atomicstryker.infernalmobs.common.InfernalMobsCore;
import atomicstryker.infernalmobs.common.MobModifier;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;

public class MM_Gravity extends MobModifier
{

    public MM_Gravity()
    {
        super();
    }

    public MM_Gravity(MobModifier next)
    {
        super(next);
    }

    @Override
    public String getModName()
    {
        return "Gravity";
    }

    private long nextAbilityUse = 0L;
    private final static long coolDown = 5000L;

    @Override
    public boolean onUpdate(EntityLivingBase mob)
    {
        if (hasSteadyTarget() && getMobTarget() instanceof EntityPlayer)
        {
            tryAbility(mob, getMobTarget());
        }

        return super.onUpdate(mob);
    }

    private void tryAbility(EntityLivingBase mob, EntityLivingBase target)
    {
        if (target == null || !mob.func_70685_l(target))
        {
            return;
        }

        long time = System.currentTimeMillis();
        if (time > nextAbilityUse)
        {
            nextAbilityUse = time + coolDown;

            double diffX = target.field_70165_t - mob.field_70165_t;
            double diffZ;
            for (diffZ = target.field_70161_v - mob.field_70161_v; diffX * diffX + diffZ * diffZ < 1.0E-4D; diffZ = (Math.random() - Math.random()) * 0.01D)
            {
                diffX = (Math.random() - Math.random()) * 0.01D;
            }

            mob.field_70170_p.func_184133_a(null, new BlockPos(mob), SoundEvents.field_187596_cD, SoundCategory.HOSTILE, 1.0F + mob.func_70681_au().nextFloat(), mob.func_70681_au().nextFloat() * 0.7F + 0.3F);

            if (mob.field_70170_p.field_72995_K || !(target instanceof EntityPlayerMP))
            {
                knockBack(target, diffX, diffZ);
            }
            else
            {
                InfernalMobsCore.instance().sendKnockBackPacket((EntityPlayerMP) target, (float) diffX, (float) diffZ);
            }
        }
    }

    public static void knockBack(EntityLivingBase target, double x, double z)
    {
        target.field_70160_al = true;
        float normalizedPower = MathHelper.func_76133_a(x * x + z * z);
        float knockPower = 0.8F;
        target.field_70159_w /= 2.0D;
        target.field_70181_x /= 2.0D;
        target.field_70179_y /= 2.0D;
        target.field_70159_w -= x / (double) normalizedPower * (double) knockPower;
        target.field_70181_x += (double) knockPower;
        target.field_70179_y -= z / (double) normalizedPower * (double) knockPower;

        if (target.field_70181_x > 0.4000000059604645D)
        {
            target.field_70181_x = 0.4000000059604645D;
        }
    }

    @Override
    public Class<?>[] getModsNotToMixWith()
    {
        return modBans;
    }

    private static Class<?>[] modBans = { MM_Webber.class };

    @Override
    protected String[] getModNameSuffix()
    {
        return suffix;
    }

    private static String[] suffix = { "ofRepulsion", "theFlipper" };

    @Override
    protected String[] getModNamePrefix()
    {
        return prefix;
    }

    private static String[] prefix = { "repulsing", "sproing" };

}
