package atomicstryker.infernalmobs.common;

import org.apache.logging.log4j.Level;

import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class InfernalCommandSpawnInfernal extends CommandBase
{

    @Override
    public String func_71517_b()
    {
        return "spawninfernal";
    }

    @Override
    public String func_71518_a(ICommandSender sender)
    {
        return "/spawninfernal x y z ENTCLASS X spawns an Infernal Mob of class ENTCLASS at x, y, z with Modifiers X";
    }

    @SuppressWarnings({ "unchecked" })
    @Override
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException
    {
        if (args.length < 5)
        {
            throw new WrongUsageException("Invalid Usage of SpawnInfernal command, too few arguments", (Object) args);
        }
        else
        {
            try
            {
                final int x = (args[0].equals("~")) ? sender.func_174793_f().func_180425_c().func_177958_n() : Integer.valueOf(args[0]);
                final int y = (args[1].equals("~")) ? sender.func_174793_f().func_180425_c().func_177956_o() : Integer.valueOf(args[1]);
                final int z = (args[2].equals("~")) ? sender.func_174793_f().func_180425_c().func_177952_p() : Integer.valueOf(args[2]);
                String modifier = args[4];
                for (int i = 5; i < args.length; i++)
                {
                    modifier = modifier + " " + args[i];
                }

                Class<? extends EntityLivingBase> entClass = null;
                for (ResourceLocation rsl : EntityList.func_180124_b())
                {
                    if (rsl.func_110623_a().contains(args[3]))
                    {
                        Object o = EntityList.getClass(rsl);
                        if (o.getClass().isAssignableFrom(EntityLiving.class))
                        {
                            entClass = (Class<? extends EntityLivingBase>) o;
                        }
                    }
                }
                if (entClass != null)
                {
                    EntityLivingBase mob = entClass.getConstructor(World.class).newInstance(sender.func_130014_f_());
                    mob.func_70107_b(x + 0.5, y + 0.5, z + 0.5);
                    sender.func_130014_f_().func_72838_d(mob);

                    InfernalMobsCore.proxy.getRareMobs().remove(mob);
                    InfernalMobsCore.instance().addEntityModifiersByString(mob, modifier);
                    MobModifier mod = InfernalMobsCore.getMobModifiers(mob);
                    if (mod != null)
                    {
                        InfernalMobsCore.LOGGER.log(Level.INFO,
                                sender.func_70005_c_() + " spawned: " + InfernalMobsCore.getMobModifiers(mob).getLinkedModNameUntranslated() + " at [" + x + "|" + y + "|" + z + "]");
                    }
                    else
                    {
                        throw new WrongUsageException("Error adding Infernal Modifier " + modifier + " to mob " + mob);
                    }
                }
                else
                {
                    throw new WrongUsageException("Invalid SpawnInfernal command, no Entity [" + args[3] + "] known");
                }
            }
            catch (Exception e)
            {
                e.printStackTrace();
                throw new WrongUsageException("Problem executing SpawnInfernal command, stacktrace printed...");
            }
        }
    }

    @Override
    public int func_82362_a()
    {
        return 2;
    }

}
