package atomicstryker.infernalmobs.common;

import org.apache.logging.log4j.Level;

import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.EntityList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;

public class InfernalCommandFindEntityClass extends CommandBase
{

    @Override
    public String func_71517_b()
    {
        return "feclass";
    }

    @Override
    public String func_71518_a(ICommandSender sender)
    {
        return "/feclass X returns all currently registered Entities containing X in their classname's";
    }

    @Override
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException
    {
        if (args.length == 0)
        {
            throw new WrongUsageException("Invalid Usage of FindEntityClass command", (Object) args);
        }
        else
        {
            String classname = args[0];
            for (int i = 1; i < args.length; i++)
            {
                classname = classname + " " + args[i];
            }

            String result = "Found Entity classes: ";
            boolean found = false;
            for (ResourceLocation rsl : EntityList.func_180124_b())
            {
                String entclass = rsl.func_110623_a();
                if (entclass.toLowerCase().contains(classname.toLowerCase()))
                {
                    if (!found)
                    {
                        result += entclass;
                        found = true;
                    }
                    else
                    {
                        result += (", " + entclass);
                    }
                }
            }

            if (!found)
            {
                result += "Nothing found.";
            }

            InfernalMobsCore.LOGGER.log(Level.INFO, sender.func_70005_c_() + ": " + result);
        }
    }

    @Override
    public int func_82362_a()
    {
        return 2;
    }

}
