/*
 * Decompiled with CFR 0.152.
 */
package leviathan143.loottweaker.common.zenscript;

import com.google.common.collect.Lists;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.data.IData;
import crafttweaker.mc1120.data.NBTConverter;
import java.util.ArrayList;
import java.util.List;
import leviathan143.loottweaker.common.lib.DataToJSONConverter;
import leviathan143.loottweaker.common.lib.LootUtils;
import leviathan143.loottweaker.common.lib.ZenScriptUtils;
import leviathan143.loottweaker.common.zenscript.ZenLootFunctionWrapper;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.functions.EnchantRandomly;
import net.minecraft.world.storage.loot.functions.EnchantWithLevels;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.LootingEnchantBonus;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraft.world.storage.loot.functions.SetDamage;
import net.minecraft.world.storage.loot.functions.SetMetadata;
import net.minecraft.world.storage.loot.functions.SetNBT;
import net.minecraft.world.storage.loot.functions.Smelt;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="loottweaker.vanilla.loot.Functions")
public class FunctionHelper {
    @ZenMethod
    public static ZenLootFunctionWrapper enchantRandomly(String[] enchantIDList) {
        ArrayList enchantments = Lists.newArrayListWithCapacity((int)enchantIDList.length);
        for (String id : enchantIDList) {
            Enchantment ench = Enchantment.func_180305_b((String)id);
            if (ench == null) {
                CraftTweakerAPI.logError((String)String.format("%s is not a valid enchantment id", id));
                continue;
            }
            enchantments.add(ench);
        }
        return new ZenLootFunctionWrapper((LootFunction)new EnchantRandomly(LootUtils.NO_CONDITIONS, (List)enchantments));
    }

    @ZenMethod
    public static ZenLootFunctionWrapper enchantWithLevels(int min, int max, boolean isTreasure) {
        return new ZenLootFunctionWrapper((LootFunction)new EnchantWithLevels(LootUtils.NO_CONDITIONS, new RandomValueRange((float)min, (float)max), isTreasure));
    }

    @ZenMethod
    public static ZenLootFunctionWrapper lootingEnchantBonus(int min, int max, int limit) {
        return new ZenLootFunctionWrapper((LootFunction)new LootingEnchantBonus(LootUtils.NO_CONDITIONS, new RandomValueRange((float)min, (float)max), limit));
    }

    @ZenMethod
    public static ZenLootFunctionWrapper setCount(int min, int max) {
        return new ZenLootFunctionWrapper((LootFunction)new SetCount(LootUtils.NO_CONDITIONS, new RandomValueRange((float)min, (float)max)));
    }

    @ZenMethod
    public static ZenLootFunctionWrapper setDamage(float min, float max) {
        if (max > 1.0f) {
            CraftTweakerAPI.logError((String)"Items cannot recieve more than 100% damage!");
            max = 1.0f;
        }
        return new ZenLootFunctionWrapper((LootFunction)new SetDamage(LootUtils.NO_CONDITIONS, new RandomValueRange(min, max)));
    }

    @ZenMethod
    public static ZenLootFunctionWrapper setMetadata(int min, int max) {
        return new ZenLootFunctionWrapper((LootFunction)new SetMetadata(LootUtils.NO_CONDITIONS, new RandomValueRange((float)min, (float)max)));
    }

    @ZenMethod
    public static ZenLootFunctionWrapper setNBT(IData nbtData) {
        if (!ZenScriptUtils.checkIsMap(nbtData)) {
            return null;
        }
        return new ZenLootFunctionWrapper((LootFunction)new SetNBT(LootUtils.NO_CONDITIONS, (NBTTagCompound)NBTConverter.from((IData)nbtData)));
    }

    @ZenMethod
    public static ZenLootFunctionWrapper smelt() {
        return new ZenLootFunctionWrapper((LootFunction)new Smelt(LootUtils.NO_CONDITIONS));
    }

    @ZenMethod
    public static ZenLootFunctionWrapper parse(IData json) {
        if (!ZenScriptUtils.checkIsMap(json)) {
            return null;
        }
        return new ZenLootFunctionWrapper(LootUtils.parseJSONFunction(DataToJSONConverter.from(json)));
    }
}

