/*
 * Decompiled with CFR 0.152.
 */
package leviathan143.loottweaker.common.tweakers;

import com.google.common.collect.Maps;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import leviathan143.loottweaker.common.zenscript.ZenLootTableWrapper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="loottweaker.vanilla.loot.LootTables")
@Mod.EventBusSubscriber(modid="loottweaker")
public class LootTableTweaker {
    public static final Logger LOGGER = LogManager.getLogger();
    private static Map<ResourceLocation, ZenLootTableWrapper> tweakedTableStorage = Maps.newHashMap();
    private static Collection<ResourceLocation> uncheckedTables = new HashSet<ResourceLocation>();
    private static boolean tableLoadingStarted = false;

    @ZenMethod
    public static ZenLootTableWrapper getTable(String tableName) {
        return LootTableTweaker.getTableInternal(new ResourceLocation(tableName));
    }

    @ZenMethod
    public static ZenLootTableWrapper getTableUnchecked(String tableName) {
        ResourceLocation tableLoc = new ResourceLocation(tableName);
        uncheckedTables.add(tableLoc);
        return LootTableTweaker.getTableInternal(tableLoc);
    }

    private static ZenLootTableWrapper getTableInternal(ResourceLocation tableLoc) {
        if (!tweakedTableStorage.containsKey(tableLoc)) {
            tweakedTableStorage.put(tableLoc, new ZenLootTableWrapper(tableLoc));
        }
        return tweakedTableStorage.get(tableLoc);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onTableLoad(LootTableLoadEvent event) {
        LootTableTweaker.applyTweaks(event.getName(), event.getTable());
        if (!tableLoadingStarted) {
            tableLoadingStarted = true;
            LootTableTweaker.onTableLoadingStarted();
        }
    }

    private static void onTableLoadingStarted() {
        for (Map.Entry<ResourceLocation, ZenLootTableWrapper> entry : tweakedTableStorage.entrySet()) {
            if (LootTableList.func_186374_a().contains(entry.getKey()) || uncheckedTables.contains(entry.getKey())) continue;
            CraftTweakerAPI.logError((String)String.format("No loot table with name %s exists!", entry.getKey()));
        }
    }

    private static void applyTweaks(ResourceLocation tableName, LootTable table) {
        if (tweakedTableStorage.containsKey(tableName)) {
            if (table.isFrozen()) {
                LOGGER.debug("Skipped modifying loot table {} because it is frozen", (Object)tableName);
                return;
            }
            tweakedTableStorage.get(tableName).applyLootTweaks(table);
        }
    }
}

