/*
 * Decompiled with CFR 0.152.
 */
package leviathan143.loottweaker.common.commands;

import com.google.common.base.Enums;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import crafttweaker.mc1120.commands.CraftTweakerCommand;
import java.io.File;
import java.util.List;
import javax.annotation.Nullable;
import leviathan143.loottweaker.common.LootTweakerMain;
import leviathan143.loottweaker.common.darkmagic.CommonMethodHandles;
import leviathan143.loottweaker.common.lib.LootUtils;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.storage.loot.ILootContainer;
import net.minecraft.world.storage.loot.LootTableList;

public class CommandLootTables
extends CraftTweakerCommand {
    public CommandLootTables() {
        super("loottables");
    }

    protected void init() {
        this.setDescription(new ITextComponent[]{new TextComponentTranslation("loottweaker.commands.dump.desc", new Object[0])});
    }

    public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
        block21: {
            block20: {
                if (args.length < 1) {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("loottweaker.commands.dump.usage", new Object[0]));
                    return;
                }
                Optional subcommand = Enums.getIfPresent(Subcommand.class, (String)args[0]);
                if (!subcommand.isPresent()) break block20;
                ResourceLocation tableLoc = null;
                switch ((Subcommand)((Object)subcommand.get())) {
                    case all: {
                        for (ResourceLocation table : LootTableList.func_186374_a()) {
                            LootUtils.dump(LootTweakerMain.proxy.getWorld(), table, CommandLootTables.getLootTableDumpFilePath(table));
                        }
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation("loottweaker.commands.dump.all.done", new Object[0]));
                        break;
                    }
                    case byName: {
                        if (args.length < 2) {
                            sender.func_145747_a((ITextComponent)new TextComponentTranslation("loottweaker.commands.dump.byName.missingName", new Object[0]));
                            return;
                        }
                        tableLoc = new ResourceLocation(args[1]);
                        if (!LootTableList.func_186374_a().contains(tableLoc)) {
                            sender.func_145747_a((ITextComponent)new TextComponentTranslation("loottweaker.commands.dump.byName.invalidName", new Object[0]));
                            return;
                        }
                        File dumpPathByName = CommandLootTables.getLootTableDumpFilePath(tableLoc);
                        LootUtils.dump(LootTweakerMain.proxy.getWorld(), tableLoc, dumpPathByName);
                        CommandLootTables.linkDumpFileInChat(sender, dumpPathByName, tableLoc);
                        break;
                    }
                    case target: {
                        if (sender instanceof Entity) {
                            RayTraceResult target = CommandLootTables.getLookTarget((Entity)sender, 8.0);
                            switch (target.field_72313_a) {
                                case BLOCK: {
                                    TileEntity te = sender.func_130014_f_().func_175625_s(target.func_178782_a());
                                    if (te instanceof ILootContainer) {
                                        tableLoc = ((ILootContainer)te).func_184276_b();
                                        break;
                                    }
                                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("loottweaker.commands.dump.target.noTable", new Object[0]));
                                    break;
                                }
                                case ENTITY: {
                                    if (target.field_72308_g instanceof EntityLiving) {
                                        tableLoc = CommonMethodHandles.getEntityLootTable((EntityLiving)target.field_72308_g);
                                        break;
                                    }
                                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("loottweaker.commands.dump.target.noTable", new Object[0]));
                                    break;
                                }
                                case MISS: {
                                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("loottweaker.commands.dump.target.noTarget", new Object[0]));
                                    return;
                                }
                                default: {
                                    return;
                                }
                            }
                            if (tableLoc == null) {
                                return;
                            }
                            File dumpPathTarget = CommandLootTables.getLootTableDumpFilePath(tableLoc);
                            LootUtils.dump(LootTweakerMain.proxy.getWorld(), tableLoc, dumpPathTarget);
                            CommandLootTables.linkDumpFileInChat(sender, dumpPathTarget, tableLoc);
                            break;
                        }
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation("loottweaker.commands.dump.target.senderNotEntity", new Object[0]));
                        break;
                    }
                    case list: {
                        for (ResourceLocation table : LootTableList.func_186374_a()) {
                            sender.func_145747_a((ITextComponent)new TextComponentString(table.toString()));
                        }
                    }
                }
                break block21;
            }
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("loottweaker.commands.dump.unknownSubcommand", new Object[]{args[0]}));
        }
    }

    private static File getLootTableDumpFilePath(ResourceLocation tableLoc) {
        return new File("dumps" + File.separator + "loot_tables" + File.separator + tableLoc.func_110624_b() + File.separator + tableLoc.func_110623_a() + ".json");
    }

    private static void linkDumpFileInChat(ICommandSender sender, File dumpPath, ResourceLocation tableLoc) {
        TextComponentTranslation message = new TextComponentTranslation("loottweaker.commands.dump.dumpLink", new Object[]{tableLoc});
        TextComponentString link = new TextComponentString(dumpPath.toString());
        link.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_FILE, dumpPath.toString())).func_150228_d(Boolean.valueOf(true)).func_150238_a(TextFormatting.AQUA);
        sender.func_145747_a(message.func_150257_a((ITextComponent)link));
    }

    private static RayTraceResult getLookTarget(Entity entity, double distance) {
        RayTraceResult result = null;
        Entity targetedEntity = null;
        Vec3d eyePos = entity.func_174824_e(1.0f);
        Vec3d look = entity.func_70676_i(1.0f);
        Vec3d lookTarget = eyePos.func_72441_c(look.field_72450_a * distance, look.field_72448_b * distance, look.field_72449_c * distance);
        result = entity.func_130014_f_().func_147447_a(eyePos, lookTarget, false, false, true);
        boolean flag = false;
        double d1 = distance;
        if (result != null) {
            d1 = result.field_72307_f.func_72438_d(eyePos);
        }
        Vec3d vec3d3 = null;
        List list = entity.func_130014_f_().func_175674_a(entity, entity.func_174813_aQ().func_72321_a(look.field_72450_a * distance, look.field_72448_b * distance, look.field_72449_c * distance).func_72314_b(1.0, 1.0, 1.0), Predicates.and((Predicate)EntitySelectors.field_180132_d, (Predicate)new Predicate<Entity>(){

            public boolean apply(@Nullable Entity p_apply_1_) {
                return p_apply_1_ != null && p_apply_1_.func_70067_L();
            }
        }));
        double d2 = d1;
        for (Entity entity1 : list) {
            double d3;
            AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)entity1.func_70111_Y());
            RayTraceResult raytraceresult = axisalignedbb.func_72327_a(eyePos, lookTarget);
            if (axisalignedbb.func_72318_a(eyePos)) {
                if (!(d2 >= 0.0)) continue;
                targetedEntity = entity1;
                vec3d3 = raytraceresult == null ? eyePos : raytraceresult.field_72307_f;
                d2 = 0.0;
                continue;
            }
            if (raytraceresult == null || !((d3 = eyePos.func_72438_d(raytraceresult.field_72307_f)) < d2) && d2 != 0.0) continue;
            if (entity1.func_184208_bv() == entity.func_184208_bv() && !entity1.canRiderInteract()) {
                if (d2 != 0.0) continue;
                targetedEntity = entity1;
                vec3d3 = raytraceresult.field_72307_f;
                continue;
            }
            targetedEntity = entity1;
            vec3d3 = raytraceresult.field_72307_f;
            d2 = d3;
        }
        if (targetedEntity != null && flag && eyePos.func_72438_d(vec3d3) > 3.0) {
            targetedEntity = null;
            result = new RayTraceResult(RayTraceResult.Type.MISS, vec3d3, (EnumFacing)null, new BlockPos(vec3d3));
        }
        if (targetedEntity != null && (d2 < d1 || result == null)) {
            result = new RayTraceResult(targetedEntity, vec3d3);
        }
        return result;
    }

    private static enum Subcommand {
        all,
        target,
        byName,
        list;

    }
}

