/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import mekanism.api.TileNetworkList;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.common.config.MekanismConfig;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.common.tile.TileEntityGenerator;
import micdoodle8.mods.galacticraft.api.world.ISolarLevel;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TileEntitySolarGenerator
extends TileEntityGenerator {
    private static final String[] methods = new String[]{"getEnergy", "getOutput", "getMaxEnergy", "getEnergyNeeded", "getSeesSun"};
    private boolean seesSun;
    private boolean needsRainCheck = true;
    private float peakOutput;

    public TileEntitySolarGenerator() {
        this("SolarGenerator", 96000.0, MekanismConfig.current().generators.solarGeneration.val() * 2.0);
    }

    public TileEntitySolarGenerator(String name, double maxEnergy, double output) {
        super("solar", name, maxEnergy, output);
        this.inventory = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
    }

    public boolean canSeeSun() {
        return this.seesSun;
    }

    @Nonnull
    public int[] func_180463_a(@Nonnull EnumFacing side) {
        return new int[]{0};
    }

    @Override
    public boolean canSetFacing(int facing) {
        return facing != 0 && facing != 1;
    }

    public void func_145829_t() {
        super.func_145829_t();
        Biome b = this.field_145850_b.field_73011_w.getBiomeForCoords(this.func_174877_v());
        float tempEff = 0.3f * (0.8f - b.func_180626_a(this.func_174877_v()));
        float humidityEff = -0.3f * (b.func_76738_d() ? b.func_76727_i() : 0.0f);
        this.peakOutput = this.getConfiguredMax() * (1.0f + tempEff + humidityEff);
        this.needsRainCheck = b.func_76738_d();
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            ChargeUtils.charge((int)0, (IStrictEnergyStorage)this);
            boolean bl = this.seesSun = this.field_145850_b.func_72935_r() && this.field_145850_b.func_175678_i(this.func_174877_v().func_177981_b(4)) && !this.field_145850_b.field_73011_w.func_177495_o();
            if (this.canOperate()) {
                this.setActive(true);
                this.setEnergy(this.getEnergy() + this.getProduction());
            } else {
                this.setActive(false);
            }
        }
    }

    public boolean func_180461_b(int slotID, @Nonnull ItemStack itemstack, @Nonnull EnumFacing side) {
        if (slotID == 0) {
            return ChargeUtils.canBeOutputted((ItemStack)itemstack, (boolean)true);
        }
        return false;
    }

    public boolean func_94041_b(int slotID, @Nonnull ItemStack itemstack) {
        if (slotID == 0) {
            return ChargeUtils.canBeCharged((ItemStack)itemstack);
        }
        return true;
    }

    @Override
    public boolean canOperate() {
        return this.getEnergy() < this.getMaxEnergy() && this.seesSun && MekanismUtils.canFunction((TileEntity)this);
    }

    public double getProduction() {
        float brightness = this.field_145850_b.getSunBrightnessFactor(1.0f);
        if (MekanismUtils.existsAndInstance((Object)this.field_145850_b.field_73011_w, (String)"micdoodle8.mods.galacticraft.api.world.ISolarLevel")) {
            brightness = (float)((double)brightness * ((ISolarLevel)this.field_145850_b.field_73011_w).getSolarEnergyMultiplier());
        }
        float production = this.peakOutput * brightness;
        if (this.needsRainCheck && (this.field_145850_b.func_72896_J() || this.field_145850_b.func_72911_I())) {
            production = (float)((double)production * 0.2);
        }
        return production;
    }

    public String getEfficiencyStr() {
        return String.format("%2.0f", this.getProduction() / this.getMaxOutput() * 100.0);
    }

    public String[] getMethods() {
        return methods;
    }

    public Object[] invoke(int method, Object[] arguments) throws NoSuchMethodException {
        switch (method) {
            case 0: {
                return new Object[]{this.electricityStored};
            }
            case 1: {
                return new Object[]{this.output};
            }
            case 2: {
                return new Object[]{this.BASE_MAX_ENERGY};
            }
            case 3: {
                return new Object[]{this.BASE_MAX_ENERGY - this.electricityStored};
            }
            case 4: {
                return new Object[]{this.seesSun};
            }
        }
        throw new NoSuchMethodException();
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.seesSun = dataStream.readBoolean();
        }
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        data.add((Object)this.seesSun);
        return data;
    }

    @Override
    public boolean sideIsOutput(EnumFacing side) {
        return side == EnumFacing.DOWN;
    }

    @Override
    public boolean renderUpdate() {
        return false;
    }

    @Override
    public boolean lightUpdate() {
        return false;
    }

    protected float getConfiguredMax() {
        return (float)MekanismConfig.current().generators.solarGeneration.val();
    }

    @Override
    public double getMaxOutput() {
        return this.peakOutput;
    }
}

