/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.TileNetworkList;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.common.FluidSlot;
import mekanism.common.MekanismItems;
import mekanism.common.base.FluidHandlerWrapper;
import mekanism.common.base.IComparatorSupport;
import mekanism.common.base.IFluidHandlerWrapper;
import mekanism.common.base.ISustainedData;
import mekanism.common.config.MekanismConfig;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.PipeUtils;
import mekanism.generators.common.tile.TileEntityGenerator;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TileEntityBioGenerator
extends TileEntityGenerator
implements IFluidHandlerWrapper,
ISustainedData,
IComparatorSupport {
    private static final String[] methods = new String[]{"getEnergy", "getOutput", "getMaxEnergy", "getEnergyNeeded", "getBioFuel", "getBioFuelNeeded"};
    private static FluidTankInfo[] ALL_TANKS = new FluidTankInfo[0];
    public FluidSlot bioFuelSlot = new FluidSlot(24000, -1);
    private int currentRedstoneLevel;

    public TileEntityBioGenerator() {
        super("bio", "BioGenerator", 160000.0, MekanismConfig.current().generators.bioGeneration.val() * 2.0);
        this.inventory = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
    }

    @Override
    public void onUpdate() {
        int newRedstoneLevel;
        super.onUpdate();
        if (!((ItemStack)this.inventory.get(0)).func_190926_b()) {
            ChargeUtils.charge((int)1, (IStrictEnergyStorage)this);
            FluidStack fluid = FluidUtil.getFluidContained((ItemStack)((ItemStack)this.inventory.get(0)));
            if (fluid != null && FluidRegistry.isFluidRegistered((String)"bioethanol")) {
                IFluidHandlerItem handler;
                FluidStack drained;
                if (fluid.getFluid() == FluidRegistry.getFluid((String)"bioethanol") && (drained = (handler = FluidUtil.getFluidHandler((ItemStack)((ItemStack)this.inventory.get(0)))).drain(this.bioFuelSlot.MAX_FLUID - this.bioFuelSlot.fluidStored, true)) != null) {
                    this.bioFuelSlot.fluidStored += drained.amount;
                }
            } else {
                int fuelNeeded;
                int fuel = this.getFuel((ItemStack)this.inventory.get(0));
                if (fuel > 0 && fuel <= (fuelNeeded = this.bioFuelSlot.MAX_FLUID - this.bioFuelSlot.fluidStored)) {
                    this.bioFuelSlot.fluidStored += fuel;
                    if (!((ItemStack)this.inventory.get(0)).func_77973_b().getContainerItem((ItemStack)this.inventory.get(0)).func_190926_b()) {
                        this.inventory.set(0, (Object)((ItemStack)this.inventory.get(0)).func_77973_b().getContainerItem((ItemStack)this.inventory.get(0)));
                    } else {
                        ((ItemStack)this.inventory.get(0)).func_190918_g(1);
                    }
                }
            }
        }
        if (this.canOperate()) {
            if (!this.field_145850_b.field_72995_K) {
                this.setActive(true);
            }
            this.bioFuelSlot.setFluid(this.bioFuelSlot.fluidStored - 1);
            this.setEnergy(this.electricityStored + MekanismConfig.current().generators.bioGeneration.val());
        } else if (!this.field_145850_b.field_72995_K) {
            this.setActive(false);
        }
        if (!this.field_145850_b.field_72995_K && (newRedstoneLevel = this.getRedstoneLevel()) != this.currentRedstoneLevel) {
            this.field_145850_b.func_175666_e(this.field_174879_c, this.func_145838_q());
            this.currentRedstoneLevel = newRedstoneLevel;
        }
    }

    public boolean func_94041_b(int slotID, @Nonnull ItemStack itemstack) {
        if (slotID == 0) {
            FluidStack fluidContained;
            if (this.getFuel(itemstack) > 0) {
                return true;
            }
            if (FluidRegistry.isFluidRegistered((String)"bioethanol") && (fluidContained = FluidUtil.getFluidContained((ItemStack)itemstack)) != null) {
                return fluidContained.getFluid() == FluidRegistry.getFluid((String)"bioethanol");
            }
            return false;
        }
        if (slotID == 1) {
            return ChargeUtils.canBeCharged((ItemStack)itemstack);
        }
        return true;
    }

    @Override
    public boolean canOperate() {
        return this.electricityStored < this.BASE_MAX_ENERGY && this.bioFuelSlot.fluidStored > 0 && MekanismUtils.canFunction((TileEntity)this);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.bioFuelSlot.fluidStored = nbtTags.func_74762_e("bioFuelStored");
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74768_a("bioFuelStored", this.bioFuelSlot.fluidStored);
        return nbtTags;
    }

    public int getFuel(ItemStack itemstack) {
        return itemstack.func_77973_b() == MekanismItems.BioFuel ? 200 : 0;
    }

    public int getScaledFuelLevel(int i) {
        return this.bioFuelSlot.fluidStored * i / this.bioFuelSlot.MAX_FLUID;
    }

    @Nonnull
    public int[] func_180463_a(@Nonnull EnumFacing side) {
        int[] nArray;
        if (side == MekanismUtils.getRight((EnumFacing)this.facing)) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 1;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 0;
        }
        return nArray;
    }

    @Override
    public boolean canSetFacing(int facing) {
        return facing != 0 && facing != 1;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.bioFuelSlot.fluidStored = dataStream.readInt();
        }
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        data.add((Object)this.bioFuelSlot.fluidStored);
        return data;
    }

    public String[] getMethods() {
        return methods;
    }

    public Object[] invoke(int method, Object[] arguments) throws NoSuchMethodException {
        switch (method) {
            case 0: {
                return new Object[]{this.electricityStored};
            }
            case 1: {
                return new Object[]{this.output};
            }
            case 2: {
                return new Object[]{this.BASE_MAX_ENERGY};
            }
            case 3: {
                return new Object[]{this.BASE_MAX_ENERGY - this.electricityStored};
            }
            case 4: {
                return new Object[]{this.bioFuelSlot.fluidStored};
            }
            case 5: {
                return new Object[]{this.bioFuelSlot.MAX_FLUID - this.bioFuelSlot.fluidStored};
            }
        }
        throw new NoSuchMethodException();
    }

    public int fill(EnumFacing from, @Nullable FluidStack resource, boolean doFill) {
        if (resource != null && FluidRegistry.isFluidRegistered((String)"bioethanol") && from != this.facing && resource.getFluid() == FluidRegistry.getFluid((String)"bioethanol")) {
            int attemptTransfer = resource.amount;
            int fuelNeeded = this.bioFuelSlot.MAX_FLUID - this.bioFuelSlot.fluidStored;
            int fuelTransfer = attemptTransfer <= fuelNeeded ? attemptTransfer : fuelNeeded;
            if (doFill) {
                this.bioFuelSlot.setFluid(this.bioFuelSlot.fluidStored + fuelTransfer);
            }
            return fuelTransfer;
        }
        return 0;
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        return null;
    }

    public FluidStack drain(EnumFacing from, @Nullable FluidStack resource, boolean doDrain) {
        return null;
    }

    public boolean canFill(EnumFacing from, @Nullable FluidStack fluid) {
        return fluid != null && fluid.getFluid().equals(FluidRegistry.getFluid((String)"bioethanol"));
    }

    public boolean canDrain(EnumFacing from, @Nullable FluidStack fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return PipeUtils.EMPTY;
    }

    public void writeSustainedData(ItemStack itemStack) {
        ItemDataUtils.setInt((ItemStack)itemStack, (String)"fluidStored", (int)this.bioFuelSlot.fluidStored);
    }

    public void readSustainedData(ItemStack itemStack) {
        this.bioFuelSlot.setFluid(ItemDataUtils.getInt((ItemStack)itemStack, (String)"fluidStored"));
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing side) {
        return side != this.facing && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, side);
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing side) {
        if (side != this.facing && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new FluidHandlerWrapper((IFluidHandlerWrapper)this, side));
        }
        return (T)super.getCapability(capability, side);
    }

    public FluidTankInfo[] getAllTanks() {
        return ALL_TANKS;
    }

    public int getRedstoneLevel() {
        return Container.func_94526_b((IInventory)this);
    }
}

