/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.tileentity;

import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import ovh.corail.tombstone.ConfigTombstone;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.block.BlockDecorativeGrave;
import ovh.corail.tombstone.block.BlockGraveBase;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.TimeHelper;

public class TileEntityWritableGrave
extends TileEntity
implements ITickable {
    protected String ownerName = "";
    protected long deathDate;
    public int countTicks = 0;
    protected long lastCheckSoul = -1L;

    public boolean canShowFog() {
        return Helper.isNight(this.field_145850_b);
    }

    public void func_73660_a() {
        if (!(this.func_145838_q() instanceof BlockGraveBase)) {
            return;
        }
        ++this.countTicks;
        if (this.field_145850_b.field_72995_K) {
            if (TimeHelper.atInterval(this.countTicks, 100)) {
                IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
                if (!(state.func_177230_c() instanceof BlockGraveBase)) {
                    return;
                }
                if (((Boolean)state.func_177229_b((IProperty)BlockGraveBase.HAS_SOUL)).booleanValue()) {
                    ModTombstone.proxy.produceGraveSoul(this.field_145850_b, this.field_174879_c);
                }
            }
            if (this.canShowFog()) {
                ModTombstone.proxy.produceGraveSmoke(this.field_145850_b, this.field_174879_c);
            }
        } else if (this.func_145838_q() instanceof BlockDecorativeGrave) {
            if (this.lastCheckSoul <= 0L) {
                this.lastCheckSoul = TimeHelper.worldTicks(this.field_145850_b);
                return;
            }
            long elapsedMinutes = TimeHelper.minuteElapsed(this.field_145850_b, this.lastCheckSoul);
            if (elapsedMinutes >= (long)ConfigTombstone.decorativeGrave.timeSoul) {
                IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
                if (!(state.func_177230_c() instanceof BlockDecorativeGrave)) {
                    return;
                }
                if (((Boolean)state.func_177229_b((IProperty)BlockGraveBase.HAS_SOUL)).booleanValue()) {
                    this.resetCheckSoul();
                    return;
                }
                long count = elapsedMinutes / (long)ConfigTombstone.decorativeGrave.timeSoul;
                this.lastCheckSoul += count * (long)ConfigTombstone.decorativeGrave.timeSoul;
                double chance = 1.0 - Math.pow(1.0 - (double)ConfigTombstone.decorativeGrave.chanceSoul / 1000.0, count);
                if (chance >= 1.0 || Helper.random.nextDouble() <= chance) {
                    if (elapsedMinutes == (long)ConfigTombstone.decorativeGrave.timeSoul) {
                        this.field_145850_b.func_72942_c((Entity)new EntityLightningBolt(this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), true));
                    }
                    this.field_145850_b.func_180501_a(this.field_174879_c, state.func_177226_a((IProperty)BlockGraveBase.HAS_SOUL, (Comparable)Boolean.valueOf(true)), 3);
                }
            }
        }
    }

    public void resetCheckSoul() {
        this.lastCheckSoul = -1L;
    }

    public <T extends Entity> void setOwner(T owner, long deathDate) {
        this.setOwner(owner.func_145748_c_().func_150260_c(), deathDate);
    }

    public void setOwner(String ownerName, long deathDate) {
        this.ownerName = ownerName;
        this.deathDate = deathDate;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public boolean hasOwner() {
        return this.ownerName.length() > 0;
    }

    public void resetDeathTime() {
        this.deathDate = TimeHelper.systemTime();
    }

    public long getOwnerDeathTime() {
        return this.deathDate;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74778_a("ownerName", this.ownerName);
        compound.func_74772_a("deathDate", this.deathDate);
        compound.func_74768_a("countTicks", this.countTicks);
        if (this.lastCheckSoul > 0L) {
            compound.func_74772_a("lastCheckSoul", this.lastCheckSoul);
        }
        super.func_189515_b(compound);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.ownerName = compound.func_74779_i("ownerName");
        this.deathDate = compound.func_74763_f("deathDate");
        this.countTicks = compound.func_74762_e("countTicks");
        if (compound.func_74764_b("lastCheckSoul")) {
            this.lastCheckSoul = compound.func_74763_f("lastCheckSoul");
        }
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.serializeNBT());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }
}

