/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone;

import com.google.common.base.Predicate;
import com.google.common.reflect.Reflection;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import java.net.MalformedURLException;
import java.net.URL;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Logger;
import ovh.corail.tombstone.ConfigTombstone;
import ovh.corail.tombstone.api.capability.ITBCapability;
import ovh.corail.tombstone.capability.TBCapabilityDefault;
import ovh.corail.tombstone.capability.TBCapabilityStorage;
import ovh.corail.tombstone.command.CommandTBKnownledge;
import ovh.corail.tombstone.command.CommandTBRecovery;
import ovh.corail.tombstone.command.CommandTBRequestTeleport;
import ovh.corail.tombstone.command.CommandTBRestoreInventory;
import ovh.corail.tombstone.command.CommandTBReviveFamiliar;
import ovh.corail.tombstone.command.CommandTBShowLastGrave;
import ovh.corail.tombstone.command.CommandTBSiege;
import ovh.corail.tombstone.command.CommandTBTeleport;
import ovh.corail.tombstone.command.CommandTBTeleportDiscovery;
import ovh.corail.tombstone.command.CommandTBTeleportGrave;
import ovh.corail.tombstone.command.CommandTBTeleportVillage;
import ovh.corail.tombstone.compatibility.CompatibilityBloodMagic;
import ovh.corail.tombstone.compatibility.CompatibilityCosmeticArmor;
import ovh.corail.tombstone.compatibility.CompatibilityGraveStone;
import ovh.corail.tombstone.compatibility.CompatibilityOpenBlocks;
import ovh.corail.tombstone.compatibility.CompatibilityThaumcraft;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.event.EventHandler;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.ContributorStore;
import ovh.corail.tombstone.helper.DeathHandler;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.SoundHandler;
import ovh.corail.tombstone.helper.TombstoneDataFixer;
import ovh.corail.tombstone.helper.WorldFunctionInjector;
import ovh.corail.tombstone.item.ItemCraftingIngredient;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.proxy.IProxy;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModTriggers;
import ovh.corail.tombstone.tileentity.TileEntityTombstone;
import ovh.corail.tombstone.tileentity.TileEntityWritableGrave;

@Mod(modid="tombstone", name="Corail Tombstone", version="3.5.5", acceptedMinecraftVersions="[1.12,1.13)", updateJSON="https://raw.githubusercontent.com/Corail31/tombstone_lite/master/update.json")
public class ModTombstone {
    @Mod.Instance(value="tombstone")
    public static ModTombstone instance;
    @SidedProxy(clientSide="ovh.corail.tombstone.proxy.ClientProxy", serverSide="ovh.corail.tombstone.proxy.ServerProxy")
    public static IProxy proxy;
    public static Logger logger;
    private static final URL CONTRIBUTORS;
    public static final EnumEnchantmentType typeTombstoneAll;
    public static final EnumEnchantmentType typeTombstoneFeet;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        CapabilityManager.INSTANCE.register(ITBCapability.class, (Capability.IStorage)new TBCapabilityStorage(), TBCapabilityDefault::new);
        PacketHandler.init();
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
        SoundHandler.registerSounds();
        GameRegistry.registerTileEntity(TileEntityWritableGrave.class, (String)"tombstone:writable_grave");
        GameRegistry.registerTileEntity(TileEntityTombstone.class, (String)"tombstone:tombstone");
        proxy.preInit();
        Reflection.initialize((Class[])new Class[]{ModTriggers.class});
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.registerOreDicts();
        proxy.init();
        TombstoneDataFixer.init();
        if (SupportMods.BLOOD_MAGIC.isLoaded()) {
            logger.warn("Enabling the patch for Blood Magic (preventing the sacrificial dagger from killing a player twice, causing them to lose their inventory), you won't see this message again if you update your Blood Magic version.");
            MinecraftForge.EVENT_BUS.register((Object)CompatibilityBloodMagic.instance);
        }
        if (SupportMods.THAUMCRAFT.isLoaded() && ConfigTombstone.compatibilities.allowThaumcraftVisValues) {
            MinecraftForge.EVENT_BUS.register((Object)CompatibilityThaumcraft.instance);
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit();
        MinecraftForge.EVENT_BUS.register((Object)WorldFunctionInjector.builder().put(new ResourceLocation("tombstone", "knowledge"), (sender, params) -> {
            Entity entity = sender.func_174793_f();
            if (entity instanceof EntityPlayerMP) {
                EntityHelper.addKnowledge((EntityPlayerMP)entity, params.getInt("amount", 1));
            }
        }).build());
    }

    @Mod.EventHandler
    public void onServerStarted(FMLServerStartingEvent event) {
        if (CompatibilityGraveStone.instance.isEuhDawson()) {
            throw new RuntimeException("Corail Tombstone Exception : GraveStone (from EuhDawnson) is incompatible");
        }
        if (ConfigTombstone.general.handlePlayerDeath) {
            if (CompatibilityGraveStone.instance.isNightKosh()) {
                CompatibilityGraveStone.instance.disable();
            }
            if (SupportMods.OPENBLOCKS.isLoaded()) {
                MinecraftForge.EVENT_BUS.register((Object)CompatibilityOpenBlocks.instance);
            }
            if (SupportMods.COSMETIC_ARMOR.isLoaded()) {
                MinecraftForge.EVENT_BUS.register((Object)CompatibilityCosmeticArmor.instance);
            }
        }
        event.registerServerCommand((ICommand)new CommandTBTeleport());
        event.registerServerCommand((ICommand)new CommandTBTeleportGrave());
        event.registerServerCommand((ICommand)new CommandTBShowLastGrave());
        event.registerServerCommand((ICommand)new CommandTBRestoreInventory());
        event.registerServerCommand((ICommand)new CommandTBTeleportVillage());
        event.registerServerCommand((ICommand)new CommandTBTeleportDiscovery());
        event.registerServerCommand((ICommand)new CommandTBRecovery());
        event.registerServerCommand((ICommand)new CommandTBRequestTeleport());
        event.registerServerCommand((ICommand)new CommandTBKnownledge());
        event.registerServerCommand((ICommand)new CommandTBSiege());
        event.registerServerCommand((ICommand)new CommandTBReviveFamiliar());
        MinecraftForge.EVENT_BUS.register((Object)new CallbackHandler());
        Futures.addCallback(ContributorStore.read(CONTRIBUTORS, event.getServer().func_110454_ao()), (FutureCallback)new FutureCallback<ContributorStore>(){

            public void onSuccess(@Nullable ContributorStore result) {
                Helper.CONTRIBUTORS = result;
            }

            public void onFailure(@Nonnull Throwable t) {
                logger.info("The list of contributors and patreons can't be loaded");
            }
        });
    }

    @Mod.EventHandler
    public void onServerStoppingEvent(FMLServerStoppedEvent event) {
        CallbackHandler.clear();
        DeathHandler.instance.clear();
    }

    private void registerOreDicts() {
        OreDictionary.registerOre((String)"dustGrave", (ItemStack)ItemCraftingIngredient.IconType.GRAVE_DUST.getStack());
        OreDictionary.registerOre((String)"ingredientEnchantedGraveKey", (Item)Items.field_151079_bi);
        OreDictionary.registerOre((String)"decorativeGrave", (Block)ModBlocks.decorative_grave_simple);
        OreDictionary.registerOre((String)"decorativeGrave", (Block)ModBlocks.decorative_grave_normal);
        OreDictionary.registerOre((String)"decorativeGrave", (Block)ModBlocks.decorative_grave_cross);
        OreDictionary.registerOre((String)"decorativeGrave", (Block)ModBlocks.decorative_tombstone);
        OreDictionary.registerOre((String)"magicScroll", (Item)ModItems.scroll_buff);
        OreDictionary.registerOre((String)"magicScroll", (Item)ModItems.scroll_of_knowledge);
        OreDictionary.registerOre((String)"magicTablet", (Item)ModItems.tablet_of_recall);
        OreDictionary.registerOre((String)"magicTablet", (Item)ModItems.tablet_of_assistance);
    }

    static {
        try {
            CONTRIBUTORS = new URL("https://raw.githubusercontent.com/Corail31/trash/master/contributors.json");
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
        typeTombstoneAll = Helper.addEnchantmentType("typeTombstoneAll", (Predicate<Item>)((Predicate)p -> p != null && (p.func_77639_j() == 1 || p.func_77619_b() > 0)), EnumEnchantmentType.ALL);
        typeTombstoneFeet = Helper.addEnchantmentType("typeTombstoneFeet", (Predicate<Item>)((Predicate)arg_0 -> ((EnumEnchantmentType)EnumEnchantmentType.ARMOR_FEET).func_77557_a(arg_0)), EnumEnchantmentType.ARMOR_FEET);
    }
}

