/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.multiblock;

import com.google.common.collect.Iterators;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.malisis.core.block.IComponent;
import net.malisis.core.block.component.DirectionalComponent;
import net.malisis.core.registry.AutoLoad;
import net.malisis.core.util.BlockPosUtils;
import net.malisis.core.util.EnumFacingUtils;
import net.malisis.core.util.MBlockState;
import net.malisis.core.util.blockdata.BlockDataHandler;
import net.malisis.core.util.multiblock.MultiBlockAccess;
import net.malisis.core.util.multiblock.MultiBlockComponent;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

@AutoLoad
public abstract class MultiBlock
implements Iterable<MBlockState> {
    public static String ORIGIN_BLOCK_DATA = "malisiscore:multiBlockOrigin";
    protected Map<BlockPos, MBlockState> states = new HashMap<BlockPos, MBlockState>();
    protected BlockPos offset = BlockPos.field_177992_a;
    protected PropertyDirection property = DirectionalComponent.HORIZONTAL;
    private boolean bulkPlace;
    private boolean bulkBreak;

    public void setOffset(BlockPos offset) {
        this.offset = offset;
    }

    public void setPropertyDirection(PropertyDirection property) {
        this.property = property;
    }

    public int getRotation(IBlockState state) {
        if (state == null || !state.func_177228_b().containsKey((Object)this.property)) {
            return 0;
        }
        EnumFacing direction = (EnumFacing)state.func_177229_b((IProperty)this.property);
        return EnumFacingUtils.getRotationCount(direction);
    }

    public void setBulkProcess(boolean bulkPlace, boolean bulkBreak) {
        this.bulkPlace = bulkPlace;
        this.bulkBreak = bulkBreak;
    }

    public boolean isBulkPlace() {
        return this.bulkPlace;
    }

    public boolean isBulkBreak() {
        return this.bulkBreak;
    }

    public boolean isFromMultiblock(World world, BlockPos pos) {
        BlockPos origin = MultiBlock.getOrigin((IBlockAccess)world, pos);
        if (origin == null) {
            return false;
        }
        for (MBlockState mstate : this.worldStates((IBlockAccess)world, origin)) {
            if (!mstate.getPos().equals((Object)pos)) continue;
            return true;
        }
        return false;
    }

    public MBlockState getState(BlockPos pos, IBlockState originState) {
        pos = BlockPosUtils.rotate(pos, 4 - this.getRotation(originState));
        return this.states.get(pos);
    }

    public boolean canPlaceBlockAt(World world, BlockPos origin, IBlockState originState, boolean placeOrigin) {
        for (MBlockState mstate : this.worldStates(origin, originState)) {
            if (mstate.getPos().equals((Object)origin) && !placeOrigin || world.func_180495_p(mstate.getPos()).func_177230_c().func_176200_f((IBlockAccess)world, mstate.getPos())) continue;
            return false;
        }
        return true;
    }

    public void placeBlocks(World world, BlockPos origin, IBlockState originState, boolean placeOrigin) {
        for (MBlockState mstate : this.worldStates((IBlockAccess)world, origin)) {
            if (mstate.getPos().equals((Object)origin) && !placeOrigin) continue;
            BlockDataHandler.setData(ORIGIN_BLOCK_DATA, (IBlockAccess)world, mstate.getPos(), origin);
            mstate.placeBlock(world, 2);
        }
        BlockDataHandler.setData(ORIGIN_BLOCK_DATA, (IBlockAccess)world, origin, origin);
    }

    public void breakBlocks(World world, BlockPos pos, IBlockState state) {
        BlockPos origin = MultiBlock.getOrigin((IBlockAccess)world, pos);
        if (origin == null) {
            return;
        }
        IBlockState originState = world.func_180495_p(origin);
        BlockDataHandler.removeData(ORIGIN_BLOCK_DATA, (IBlockAccess)world, origin);
        for (MBlockState mstate : this.worldStates(origin, originState)) {
            BlockDataHandler.removeData(ORIGIN_BLOCK_DATA, (IBlockAccess)world, mstate.getPos());
            mstate.breakBlock(world, 2);
        }
    }

    public void setOriginData(World world, BlockPos pos, IBlockState state) {
        for (MBlockState mstate : this) {
            BlockDataHandler.setData(ORIGIN_BLOCK_DATA, (IBlockAccess)world, mstate.getPos(), pos);
        }
        BlockDataHandler.setData(ORIGIN_BLOCK_DATA, (IBlockAccess)world, pos, pos);
    }

    public boolean isComplete(World world, BlockPos pos) {
        return this.isComplete(world, pos, null);
    }

    public boolean isComplete(World world, BlockPos pos, MBlockState newState) {
        MultiBlockAccess mba = new MultiBlockAccess(this, (IBlockAccess)world);
        for (MBlockState mstate : this) {
            boolean matches = (mstate = new MBlockState((IBlockAccess)mba, mstate.getPos()).offset(pos)).matchesWorld((IBlockAccess)world);
            if (!matches) {
                mstate.matchesWorld((IBlockAccess)world);
            }
            if (matches || newState != null && mstate.equals(newState)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<MBlockState> iterator() {
        return this.states.values().iterator();
    }

    public Iterable<MBlockState> worldStates(IBlockAccess world, BlockPos origin) {
        return this.worldStates(origin, world.func_180495_p(origin));
    }

    public Iterable<MBlockState> worldStates(final BlockPos origin, final IBlockState originState) {
        return new Iterable<MBlockState>(){

            @Override
            public Iterator<MBlockState> iterator() {
                return Iterators.transform(MultiBlock.this.iterator(), mstate -> MultiBlock.this.getWorldState((MBlockState)mstate, origin, originState));
            }
        };
    }

    public MBlockState getWorldState(MBlockState mstate, BlockPos origin, IBlockState originState) {
        return mstate.rotate(this.getRotation(originState)).offset(origin);
    }

    protected abstract void buildStates();

    public static BlockPos getOrigin(IBlockAccess world, BlockPos pos) {
        BlockPos origin = (BlockPos)BlockDataHandler.getData(ORIGIN_BLOCK_DATA, world, pos);
        if (origin != null && IComponent.getComponent(MultiBlockComponent.class, world.func_180495_p(origin).func_177230_c()) == null) {
            origin = null;
            BlockDataHandler.removeData(ORIGIN_BLOCK_DATA, world, pos);
        }
        return world != null && pos != null ? origin : null;
    }

    public static boolean isOrigin(IBlockAccess world, BlockPos pos) {
        return world != null && pos != null && pos.equals((Object)MultiBlock.getOrigin(world, pos));
    }

    static {
        BlockDataHandler.registerBlockData(ORIGIN_BLOCK_DATA, BlockPosUtils::fromBytes, BlockPosUtils::toBytes);
    }
}

