/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.primitivemobs.entity.monster;

import com.google.common.base.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFindEntityNearestPlayer;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.scoreboard.Team;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;

public abstract class EntityTameableSlime
extends EntitySlime
implements IEntityOwnable {
    protected static final DataParameter<Boolean> TAMED = EntityDataManager.func_187226_a(EntityTameableSlime.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> SITTING = EntityDataManager.func_187226_a(EntityTameableSlime.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Optional<UUID>> OWNER_UNIQUE_ID = EntityDataManager.func_187226_a(EntityTameableSlime.class, (DataSerializer)DataSerializers.field_187203_m);

    public EntityTameableSlime(World worldIn) {
        super(worldIn);
        this.field_70765_h = new TameableSlimeMoveHelper(this);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AITameableSlimeFloat(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AITameableSlimeAttack(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AITameableSlimeFaceRandom(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AITameableSlimeHop(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIFindEntityNearestPlayer((EntityLiving)this));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TAMED, (Object)false);
        this.field_70180_af.func_187214_a(SITTING, (Object)false);
        this.field_70180_af.func_187214_a(OWNER_UNIQUE_ID, (Object)Optional.absent());
    }

    public void func_70071_h_() {
        if (this.isTamed() && !this.isSitting() && this.func_70638_az() == null) {
            this.func_70624_b(this.getOwner());
        }
        super.func_70071_h_();
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.func_184753_b() == null) {
            compound.func_74778_a("OwnerUUID", "");
        } else {
            compound.func_74778_a("OwnerUUID", this.func_184753_b().toString());
        }
        compound.func_74757_a("Sitting", this.isSitting());
    }

    public boolean isHealingItem(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151123_aH;
    }

    public boolean isTamingItem(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151123_aH;
    }

    protected void playHealEffect() {
        EnumParticleTypes enumparticletypes = EnumParticleTypes.HEART;
        for (int i = 0; i < 7; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.func_130014_f_().func_175688_a(enumparticletypes, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
        }
    }

    protected void playSitEffect() {
        EnumParticleTypes enumparticletypes = EnumParticleTypes.NOTE;
        for (int i = 0; i < 7; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.func_130014_f_().func_175688_a(enumparticletypes, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        String s;
        super.func_70037_a(compound);
        if (compound.func_150297_b("OwnerUUID", 8)) {
            s = compound.func_74779_i("OwnerUUID");
        } else {
            String s1 = compound.func_74779_i("Owner");
            s = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)s1);
        }
        if (!s.isEmpty()) {
            try {
                this.setOwnerId(UUID.fromString(s));
                this.setTamed(true);
            }
            catch (Throwable var4) {
                this.setTamed(false);
            }
        }
        this.setSitting(compound.func_74767_n("Sitting"));
    }

    public boolean func_184652_a(EntityPlayer player) {
        return this.isTamed() && this.isOwner((EntityLivingBase)player);
    }

    protected void playTameEffect(boolean play) {
        EnumParticleTypes enumparticletypes = EnumParticleTypes.HEART;
        if (!play) {
            enumparticletypes = EnumParticleTypes.SMOKE_NORMAL;
        }
        for (int i = 0; i < 7; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.func_130014_f_().func_175688_a(enumparticletypes, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
        }
    }

    public boolean isTamed() {
        return (Boolean)this.field_70180_af.func_187225_a(TAMED);
    }

    public void setTamed(boolean tamed) {
        this.field_70180_af.func_187227_b(TAMED, (Object)tamed);
    }

    public boolean isSitting() {
        return (Boolean)this.field_70180_af.func_187225_a(SITTING);
    }

    public void setSitting(boolean sitting) {
        this.field_70180_af.func_187227_b(SITTING, (Object)sitting);
    }

    @Nullable
    public UUID func_184753_b() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(OWNER_UNIQUE_ID)).orNull();
    }

    public void setOwnerId(@Nullable UUID p_184754_1_) {
        this.field_70180_af.func_187227_b(OWNER_UNIQUE_ID, (Object)Optional.fromNullable((Object)p_184754_1_));
    }

    @Nullable
    public EntityLivingBase getOwner() {
        try {
            UUID uuid = this.func_184753_b();
            return uuid == null ? null : this.func_130014_f_().func_152378_a(uuid);
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
    }

    public boolean isOwner(EntityLivingBase entityIn) {
        return entityIn == this.getOwner();
    }

    public void func_70100_b_(EntityPlayer entityIn) {
        if (this.func_70800_m() && !this.isTamed()) {
            this.func_175451_e((EntityLivingBase)entityIn);
        }
    }

    public Team func_96124_cp() {
        EntityLivingBase entitylivingbase;
        if (this.isTamed() && (entitylivingbase = this.getOwner()) != null) {
            return entitylivingbase.func_96124_cp();
        }
        return super.func_96124_cp();
    }

    public boolean func_184191_r(Entity entityIn) {
        if (this.isTamed()) {
            EntityLivingBase entitylivingbase = this.getOwner();
            if (entityIn == entitylivingbase) {
                return true;
            }
            if (entitylivingbase != null) {
                return entitylivingbase.func_184191_r(entityIn);
            }
        }
        return super.func_184191_r(entityIn);
    }

    public void func_70645_a(DamageSource cause) {
        if (!this.func_130014_f_().field_72995_K && this.func_130014_f_().func_82736_K().func_82766_b("showDeathMessages") && this.getOwner() instanceof EntityPlayerMP) {
            this.getOwner().func_145747_a(this.func_110142_aN().func_151521_b());
        }
        super.func_70645_a(cause);
    }

    static class TameableSlimeMoveHelper
    extends EntityMoveHelper {
        private float yRot;
        private int jumpDelay;
        private final EntityTameableSlime slime;
        private boolean isAggressive;

        public TameableSlimeMoveHelper(EntityTameableSlime slimeIn) {
            super((EntityLiving)slimeIn);
            this.slime = slimeIn;
            this.yRot = 180.0f * slimeIn.field_70177_z / (float)Math.PI;
        }

        public void setDirection(float p_179920_1_, boolean p_179920_2_) {
            this.yRot = p_179920_1_;
            this.isAggressive = p_179920_2_;
        }

        public void setSpeed(double speedIn) {
            this.field_75645_e = speedIn;
            this.field_188491_h = EntityMoveHelper.Action.MOVE_TO;
        }

        public void func_75641_c() {
            this.field_75648_a.field_70759_as = this.field_75648_a.field_70177_z = this.func_75639_a(this.field_75648_a.field_70177_z, this.yRot, 90.0f);
            this.field_75648_a.field_70761_aq = this.field_75648_a.field_70177_z;
            if (this.slime.isSitting()) {
                if (this.field_75648_a.func_70638_az() != null) {
                    this.field_75648_a.func_70671_ap().func_75651_a((Entity)this.field_75648_a.func_70638_az(), this.field_75648_a.field_70759_as, this.field_75648_a.field_70125_A);
                }
                this.field_75648_a.func_70659_e(0.0f);
            } else if (this.field_188491_h != EntityMoveHelper.Action.MOVE_TO) {
                this.field_75648_a.func_191989_p(0.0f);
            } else {
                this.field_188491_h = EntityMoveHelper.Action.WAIT;
                if (this.field_75648_a.field_70122_E) {
                    this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                    if (this.jumpDelay-- <= 0) {
                        this.jumpDelay = this.slime.func_70806_k();
                        if (this.isAggressive) {
                            this.jumpDelay /= 3;
                        }
                        this.slime.func_70683_ar().func_75660_a();
                        if (this.slime.func_70807_r()) {
                            this.slime.func_184185_a(this.slime.func_184710_cZ(), this.slime.func_70599_aP(), ((this.slime.func_70681_au().nextFloat() - this.slime.func_70681_au().nextFloat()) * 0.2f + 1.0f) * 0.8f);
                        }
                    } else {
                        this.slime.field_70702_br = 0.0f;
                        this.slime.field_191988_bg = 0.0f;
                        this.field_75648_a.func_70659_e(0.0f);
                    }
                } else {
                    this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                }
            }
        }
    }

    static class AITameableSlimeHop
    extends EntityAIBase {
        private final EntityTameableSlime slime;

        public AITameableSlimeHop(EntityTameableSlime slimeIn) {
            this.slime = slimeIn;
            this.func_75248_a(5);
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            ((TameableSlimeMoveHelper)this.slime.func_70605_aq()).setSpeed(1.0);
        }
    }

    static class AITameableSlimeFloat
    extends EntityAIBase {
        private final EntityTameableSlime slime;

        public AITameableSlimeFloat(EntityTameableSlime slimeIn) {
            this.slime = slimeIn;
            this.func_75248_a(5);
            ((PathNavigateGround)slimeIn.func_70661_as()).func_179693_d(true);
        }

        public boolean func_75250_a() {
            return this.slime.func_70090_H() || this.slime.func_180799_ab();
        }

        public void func_75246_d() {
            if (this.slime.func_70681_au().nextFloat() < 0.8f) {
                this.slime.func_70683_ar().func_75660_a();
            }
            ((TameableSlimeMoveHelper)this.slime.func_70605_aq()).setSpeed(1.2);
        }
    }

    static class AITameableSlimeFaceRandom
    extends EntityAIBase {
        private final EntityTameableSlime slime;
        private float chosenDegrees;
        private int nextRandomizeTime;

        public AITameableSlimeFaceRandom(EntityTameableSlime slimeIn) {
            this.slime = slimeIn;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            return this.slime.func_70638_az() == null && (this.slime.field_70122_E || this.slime.func_70090_H() || this.slime.func_180799_ab() || this.slime.func_70644_a(MobEffects.field_188424_y));
        }

        public void func_75246_d() {
            if (--this.nextRandomizeTime <= 0) {
                this.nextRandomizeTime = 40 + this.slime.func_70681_au().nextInt(60);
                this.chosenDegrees = this.slime.func_70681_au().nextInt(360);
            }
            ((TameableSlimeMoveHelper)this.slime.func_70605_aq()).setDirection(this.chosenDegrees, false);
        }
    }

    static class AITameableSlimeAttack
    extends EntityAIBase {
        private final EntityTameableSlime slime;

        public AITameableSlimeAttack(EntityTameableSlime slimeIn) {
            this.slime = slimeIn;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            EntityLivingBase entitylivingbase = this.slime.func_70638_az();
            if (this.slime.isSitting()) {
                return false;
            }
            if (entitylivingbase == null) {
                return false;
            }
            if (!entitylivingbase.func_70089_S()) {
                return false;
            }
            if (this.slime.isTamed() && this.slime.isOwner(entitylivingbase) && this.slime.func_70032_d((Entity)this.slime.getOwner()) > 2.0f) {
                return true;
            }
            return !this.slime.isTamed() && (!(entitylivingbase instanceof EntityPlayer) || !((EntityPlayer)entitylivingbase).field_71075_bZ.field_75102_a);
        }

        public void func_75249_e() {
            super.func_75249_e();
        }

        public boolean func_75253_b() {
            EntityLivingBase entitylivingbase = this.slime.func_70638_az();
            if (this.slime.isSitting()) {
                return false;
            }
            if (entitylivingbase == null) {
                return false;
            }
            if (!entitylivingbase.func_70089_S()) {
                return false;
            }
            if (this.slime.isTamed() && this.slime.isOwner(entitylivingbase) && this.slime.func_70032_d((Entity)this.slime.getOwner()) > 2.0f) {
                return true;
            }
            return !this.slime.isTamed() && (!(entitylivingbase instanceof EntityPlayer) || !((EntityPlayer)entitylivingbase).field_71075_bZ.field_75102_a);
        }

        public void func_75246_d() {
            this.slime.func_70625_a((Entity)this.slime.func_70638_az(), 10.0f, 10.0f);
            ((TameableSlimeMoveHelper)this.slime.func_70605_aq()).setDirection(this.slime.field_70177_z, true);
        }
    }
}

