/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.primitivemobs.entity.monster;

import com.google.common.base.Optional;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.daveyx0.multimob.client.particle.MMParticles;
import net.daveyx0.multimob.entity.IMultiMob;
import net.daveyx0.multimob.message.MMMessageRegistry;
import net.daveyx0.multimob.message.MessageMMParticle;
import net.daveyx0.multimob.network.MMNetworkWrapper;
import net.daveyx0.multimob.util.EntityUtil;
import net.daveyx0.primitivemobs.core.PrimitiveMobsSoundEvents;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFindEntityNearest;
import net.minecraft.entity.ai.EntityAIFindEntityNearestPlayer;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketSetPassengers;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntityBrainSlime
extends EntitySlime
implements IMultiMob {
    public int attackDelay;
    public float suckingb;
    public float suckingc;
    public float suckingd;
    public float suckinge;
    public float suckingh;
    private boolean wasOnGround;
    public int maxStack;
    private boolean checkedAI = false;
    private final EntityAIFindEntityNearest hostilityAI = new EntityAIFindEntityNearest((EntityLiving)this, EntityAnimal.class);
    private static final DataParameter<Integer> SATURATION = EntityDataManager.func_187226_a(EntityBrainSlime.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> ATTACK_DELAY = EntityDataManager.func_187226_a(EntityBrainSlime.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Optional<UUID>> VICTIM_UNIQUE_ID = EntityDataManager.func_187226_a(EntityBrainSlime.class, (DataSerializer)DataSerializers.field_187203_m);
    protected Block spawnableBlock = Blocks.field_150354_m;

    public EntityBrainSlime(World worldIn) {
        super(worldIn);
        this.field_70765_h = new SlimeMoveHelper(this);
        this.setAttackDelay(0);
        this.suckingb = 0.0f;
        this.suckingc = 0.0f;
        this.suckingh = 1.0f;
        this.maxStack = 10;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AISlimeFloat(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AISlimeAttack(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AISlimeFaceRandom(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AISlimeHop(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIFindEntityNearestPlayer((EntityLiving)this));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(ATTACK_DELAY, (Object)0);
        this.func_184212_Q().func_187214_a(SATURATION, (Object)0);
        this.func_184212_Q().func_187214_a(VICTIM_UNIQUE_ID, (Object)Optional.absent());
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        int i = this.field_70146_Z.nextInt(3);
        this.func_70799_a(i, true);
        return livingdata;
    }

    public void func_70071_h_() {
        if (this.getSaturation() >= 10) {
            this.setSaturation(this.getSaturation() + 1);
            if (this.getSaturation() >= 100) {
                this.func_70799_a(this.func_70809_q() + 1, true);
                this.setSaturation(0);
                this.setAttackDelay(50);
                if (!this.field_70170_p.field_72995_K) {
                    MMMessageRegistry.getNetwork().sendToAll((IMessage)new MessageMMParticle(EnumParticleTypes.SMOKE_NORMAL.func_179348_c(), 10, (float)this.field_70165_t + 0.5f, (float)this.field_70163_u + 0.5f, (float)this.field_70161_v + 0.5f, 0.0, 0.0, 0.0, 0));
                }
            }
        }
        this.suckinge = this.suckingb;
        this.suckingd = this.suckingc;
        this.setAttackDelay(this.getAttackDelay() - 1);
        if (this.func_70638_az() != null) {
            this.setVictimId(this.func_70638_az().func_110124_au());
            this.func_184212_Q().func_187217_b(VICTIM_UNIQUE_ID);
        }
        if (!this.func_184218_aH() && this.getVictim() != null) {
            this.suckingb = 0.0f;
            this.suckingc = 0.0f;
            this.suckingh = 1.0f;
            if (this.getAttackDelay() <= 0 && this.func_70068_e((Entity)this.getVictim()) < 6.0) {
                this.startRidingTopEntity((Entity)this.getVictim());
                this.setAttackDelay(5);
            }
        }
        if (this.func_184218_aH()) {
            if (this.getAttackDelay() <= 0) {
                this.attackRiddenEntity();
                this.setAttackDelay(20);
            }
            this.suckingc = (float)((double)this.suckingc + 3.2);
            if (this.suckingc < 0.0f) {
                this.suckingc = 0.0f;
            }
            if (this.suckingc > 0.2f) {
                this.suckingc = 0.2f;
            }
            if (this.suckingh < 0.2f) {
                this.suckingh = 0.2f;
            }
            this.suckingh = (float)((double)this.suckingh * 0.9);
            this.suckingb += this.suckingh * 2.0f;
            if (this.getVictim() == null || this.field_70128_L) {
                this.dismountSelf();
            }
        }
        super.func_70071_h_();
    }

    public boolean hasBrainToSuck(EntityLivingBase entity) {
        EntityCreature creature;
        EntityTameable tameable;
        if (this.getSaturation() >= 10) {
            return false;
        }
        if (entity instanceof EntityTameable && (tameable = (EntityTameable)entity).func_70909_n()) {
            return false;
        }
        if (entity instanceof EntityCreature && (creature = (EntityCreature)entity).func_70668_bt() == EnumCreatureAttribute.UNDEAD) {
            return false;
        }
        return !(entity instanceof EntitySlime);
    }

    public void startRidingTopEntity(Entity entity) {
        Entity top = EntityBrainSlime.getTopPassenger(entity);
        if (top != null && !top.field_70128_L) {
            if (top instanceof EntityPlayerMP) {
                EntityPlayerMP player = (EntityPlayerMP)top;
                this.func_184205_a((Entity)player, false);
                MMNetworkWrapper.sendPacket((Entity)player, (Packet)new SPacketSetPassengers((Entity)player));
            } else {
                this.func_184205_a(top, false);
            }
        }
    }

    public static Entity getTopPassenger(Entity entity) {
        Entity top = entity;
        while (entity.func_184207_aI()) {
            List list = entity.func_184188_bt();
            if (list.isEmpty()) continue;
            top = entity = (Entity)list.get(0);
        }
        return top;
    }

    public static Entity getBottomPassenger(Entity entity) {
        Entity top = entity;
        while (entity.func_184218_aH()) {
            Entity ridingEntity = entity.func_184187_bx();
            if (ridingEntity == null || ridingEntity.field_70128_L) continue;
            top = entity = ridingEntity;
        }
        return top;
    }

    public void attackRiddenEntity() {
        Entity entity = EntityBrainSlime.getBottomPassenger((Entity)this);
        if (entity != null && !entity.field_70128_L && entity instanceof EntityLivingBase) {
            EntityLivingBase entityLiving = (EntityLivingBase)entity;
            if (this.hasBrainToSuck(entityLiving)) {
                this.damageHelmetOrEntity(entityLiving);
                this.setSaturation(this.getSaturation() + 1);
            } else {
                this.dismountSelf();
                this.setAttackDelay(20);
            }
        }
    }

    public void dismountSelf() {
        this.setVictimId(null);
        this.setAttackDelay(20);
        this.func_184210_p();
    }

    public void damageHelmetOrEntity(EntityLivingBase base) {
        ItemStack stack = base.func_184582_a(EntityEquipmentSlot.HEAD);
        int damage = this.func_70805_n();
        if (!stack.func_190926_b() && stack.func_77973_b().func_77645_m() && stack.func_77984_f()) {
            if (stack.func_77973_b() instanceof ISpecialArmor) {
                ((ISpecialArmor)stack.func_77973_b()).damageArmor(base, stack, DamageSource.func_76358_a((EntityLivingBase)this), damage, EntityEquipmentSlot.HEAD.func_188454_b());
            } else {
                stack.func_77972_a(damage, base);
            }
        } else if (base.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), damage >= 6 ? (float)damage : 6.0f)) {
            this.func_184185_a(SoundEvents.field_187870_fk, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            this.func_174815_a((EntityLivingBase)this, (Entity)base);
        }
    }

    protected boolean spawnCustomParticles() {
        if (this.func_130014_f_().field_72995_K) {
            int i = this.func_70809_q();
            for (int j = 0; j < i * 8; ++j) {
                float f = this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
                float f1 = this.field_70146_Z.nextFloat() * 0.5f + 0.5f;
                float f2 = MathHelper.func_76126_a((float)f) * (float)i * 0.5f * f1;
                float f3 = MathHelper.func_76134_b((float)f) * (float)i * 0.5f * f1;
                World world = this.func_130014_f_();
                double d0 = this.field_70165_t + (double)f2;
                double d1 = this.field_70161_v + (double)f3;
                MMParticles.spawnParticle((String)"slime", (World)this.field_70170_p, (double)d0, (double)this.func_174813_aQ().field_72338_b, (double)d1, (double)0.0, (double)0.0, (double)0.0, (float[])new float[]{209.0f, 165.0f, 189.0f});
            }
        }
        return true;
    }

    protected int func_70805_n() {
        return (this.func_70809_q() + 1) / 3;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_184218_aH()) {
            this.dismountSelf();
            this.setAttackDelay(10);
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_189101_db() {
        return false;
    }

    protected EntitySlime func_70802_j() {
        return new EntityBrainSlime(this.func_130014_f_());
    }

    public EntityMoveHelper func_70605_aq() {
        return this.field_70765_h;
    }

    public void func_70108_f(Entity entityIn) {
        super.func_70108_f(entityIn);
    }

    public void func_70100_b_(EntityPlayer entityIn) {
    }

    public double func_70033_W() {
        if (this.func_184187_bx() != null && this.func_184187_bx() instanceof EntityPlayer) {
            return 0.25;
        }
        return 0.0;
    }

    public void setAttackDelay(int delay) {
        this.func_184212_Q().func_187227_b(ATTACK_DELAY, (Object)delay);
    }

    public int getAttackDelay() {
        return (Integer)this.func_184212_Q().func_187225_a(ATTACK_DELAY);
    }

    public void setSaturation(int delay) {
        this.func_184212_Q().func_187227_b(SATURATION, (Object)delay);
    }

    public int getSaturation() {
        return (Integer)this.func_184212_Q().func_187225_a(SATURATION);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("CurrentsAttackDelay", this.getAttackDelay());
        compound.func_74768_a("Saturation", this.getSaturation());
        if (this.getVictimId() == null) {
            compound.func_74778_a("VictimUUID", "");
        } else {
            compound.func_74778_a("VictimUUID", this.getVictimId().toString());
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        String s;
        super.func_70037_a(compound);
        this.setAttackDelay(compound.func_74762_e("CurrentAttackDelay"));
        this.setSaturation(compound.func_74762_e("Saturation"));
        if (compound.func_150297_b("VictimUUID", 8)) {
            s = compound.func_74779_i("VictimUUID");
        } else {
            String s1 = compound.func_74779_i("Victim");
            s = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)s1);
        }
        if (!s.isEmpty()) {
            try {
                this.setVictimId(UUID.fromString(s));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Nullable
    public UUID getVictimId() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(VICTIM_UNIQUE_ID)).orNull();
    }

    public void setVictimId(@Nullable UUID p_184754_1_) {
        this.field_70180_af.func_187227_b(VICTIM_UNIQUE_ID, (Object)Optional.fromNullable((Object)p_184754_1_));
    }

    @Nullable
    public EntityLivingBase getVictim() {
        try {
            UUID uuid = this.getVictimId();
            if (uuid != null) {
                EntityPlayer player = this.field_70170_p.func_152378_a(uuid);
                if (player != null) {
                    return player;
                }
                EntityLivingBase entity = EntityUtil.getLoadedEntityByUUID((UUID)uuid, (World)this.field_70170_p);
                if (entity != null) {
                    return entity;
                }
                return null;
            }
            return null;
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
    }

    public boolean func_70601_bi() {
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        int j = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b);
        int k = MathHelper.func_76128_c((double)this.field_70161_v);
        BlockPos blockpos = new BlockPos(i, j, k);
        return this.func_130014_f_().func_180495_p(blockpos.func_177977_b()).func_177230_c() == this.spawnableBlock;
    }

    public boolean isCreatureType(EnumCreatureType type, boolean forSpawnCount) {
        if (type == EnumCreatureType.MONSTER) {
            return false;
        }
        return super.isCreatureType(type, forSpawnCount);
    }

    static class SlimeMoveHelper
    extends EntityMoveHelper {
        private float yRot;
        private int jumpDelay;
        private final EntityBrainSlime slime;
        private boolean isAggressive;

        public SlimeMoveHelper(EntityBrainSlime slimeIn) {
            super((EntityLiving)slimeIn);
            this.slime = slimeIn;
            this.yRot = 180.0f * slimeIn.field_70177_z / (float)Math.PI;
        }

        public void setDirection(float p_179920_1_, boolean p_179920_2_) {
            this.yRot = p_179920_1_;
            this.isAggressive = p_179920_2_;
        }

        public void setSpeed(double speedIn) {
            this.field_75645_e = speedIn;
            this.field_188491_h = EntityMoveHelper.Action.MOVE_TO;
        }

        public void func_75641_c() {
            this.field_75648_a.field_70759_as = this.field_75648_a.field_70177_z = this.func_75639_a(this.field_75648_a.field_70177_z, this.yRot, 90.0f);
            this.field_75648_a.field_70761_aq = this.field_75648_a.field_70177_z;
            if (this.field_188491_h != EntityMoveHelper.Action.MOVE_TO) {
                this.field_75648_a.func_191989_p(0.0f);
            } else {
                this.field_188491_h = EntityMoveHelper.Action.WAIT;
                if (this.field_75648_a.field_70122_E) {
                    this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                    if (this.jumpDelay-- <= 0) {
                        this.jumpDelay = this.slime.func_70806_k();
                        if (this.isAggressive && this.slime.getSaturation() < 10) {
                            if (this.slime.func_70807_r()) {
                                this.slime.func_184185_a(PrimitiveMobsSoundEvents.ENTITY_BRAINSLIME_CHARGE, this.slime.func_70599_aP(), ((this.slime.func_70681_au().nextFloat() - this.slime.func_70681_au().nextFloat()) * 0.2f + 1.0f) * 0.8f);
                            }
                            this.performChargeAttack();
                        } else {
                            this.slime.func_70683_ar().func_75660_a();
                            if (this.slime.func_70807_r()) {
                                this.slime.func_184185_a(this.slime.func_184710_cZ(), this.slime.func_70599_aP(), ((this.slime.func_70681_au().nextFloat() - this.slime.func_70681_au().nextFloat()) * 0.2f + 1.0f) * 0.8f);
                            }
                        }
                    } else {
                        this.slime.field_70702_br = 0.0f;
                        this.slime.field_191988_bg = 0.0f;
                        this.field_75648_a.func_70659_e(0.0f);
                    }
                } else {
                    this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                }
            }
        }

        public void performChargeAttack() {
            EntityLivingBase entity = this.field_75648_a.func_70638_az();
            if (entity != null) {
                this.field_75648_a.field_70159_w += (entity.field_70165_t - this.field_75648_a.field_70165_t) / 8.0;
                this.field_75648_a.field_70181_x += (entity.field_70163_u - this.field_75648_a.field_70163_u) / 8.0;
                if (this.field_75648_a.field_70181_x <= 0.0) {
                    this.field_75648_a.field_70181_x = 0.0;
                }
                this.field_75648_a.field_70181_x += 0.5;
                this.field_75648_a.field_70179_y += (entity.field_70161_v - this.field_75648_a.field_70161_v) / 8.0;
            }
        }
    }

    static class AISlimeFloat
    extends EntityAIBase {
        private final EntityBrainSlime slime;

        public AISlimeFloat(EntityBrainSlime slimeIn) {
            this.slime = slimeIn;
            this.func_75248_a(5);
            ((PathNavigateGround)slimeIn.func_70661_as()).func_179693_d(true);
        }

        public boolean func_75250_a() {
            return this.slime.func_70090_H() || this.slime.func_180799_ab();
        }

        public void func_75246_d() {
            if (this.slime.func_70681_au().nextFloat() < 0.8f) {
                this.slime.func_70683_ar().func_75660_a();
            }
            ((SlimeMoveHelper)this.slime.func_70605_aq()).setSpeed(1.2);
        }
    }

    static class AISlimeHop
    extends EntityAIBase {
        private final EntityBrainSlime slime;

        public AISlimeHop(EntityBrainSlime slimeIn) {
            this.slime = slimeIn;
            this.func_75248_a(5);
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            ((SlimeMoveHelper)this.slime.func_70605_aq()).setSpeed(1.0);
        }
    }

    static class AISlimeFaceRandom
    extends EntityAIBase {
        private final EntityBrainSlime slime;
        private float chosenDegrees;
        private int nextRandomizeTime;

        public AISlimeFaceRandom(EntityBrainSlime slimeIn) {
            this.slime = slimeIn;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            return this.slime.func_70638_az() == null && (this.slime.field_70122_E || this.slime.func_70090_H() || this.slime.func_180799_ab() || this.slime.func_70644_a(MobEffects.field_188424_y));
        }

        public void func_75246_d() {
            if (--this.nextRandomizeTime <= 0) {
                this.nextRandomizeTime = 10 + this.slime.func_70681_au().nextInt(60);
                this.chosenDegrees = this.slime.func_70681_au().nextInt(360);
            }
            ((SlimeMoveHelper)this.slime.func_70605_aq()).setDirection(this.chosenDegrees, false);
        }
    }

    static class AISlimeAttack
    extends EntityAIBase {
        private final EntityBrainSlime slime;

        public AISlimeAttack(EntityBrainSlime slimeIn) {
            this.slime = slimeIn;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            EntityLivingBase entitylivingbase = this.slime.func_70638_az();
            if (this.slime.getSaturation() >= 10) {
                return false;
            }
            if (entitylivingbase != null && this.slime.func_184215_y((Entity)entitylivingbase)) {
                return false;
            }
            if (entitylivingbase != null && this.slime.func_70032_d((Entity)entitylivingbase) > 12.0f) {
                return false;
            }
            return entitylivingbase == null ? false : (!entitylivingbase.func_70089_S() ? false : !(entitylivingbase instanceof EntityPlayer) || !((EntityPlayer)entitylivingbase).field_71075_bZ.field_75102_a);
        }

        public void func_75249_e() {
            super.func_75249_e();
        }

        public boolean continueExecuting() {
            return this.func_75250_a();
        }

        public void func_75246_d() {
            this.slime.func_70625_a((Entity)this.slime.func_70638_az(), 10.0f, 10.0f);
            EntityLivingBase entitylivingbase = this.slime.func_70638_az();
            ((SlimeMoveHelper)this.slime.func_70605_aq()).setDirection(this.slime.field_70177_z, this.slime.func_70800_m());
        }
    }
}

